/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Capsule;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Protocol;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.ProtocolContainer;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTConnector;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTRedefinedElement;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.util.UMLRealTimeSwitch;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTGuard;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTPseudostate;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTRegion;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTState;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTStateMachine;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.util.UMLRTStateMachinesSwitch;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeAdapter;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTClassifier;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTRedefinitionContext;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTRegion;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTStateMachine;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.impl.UMLRTUMLPlugin;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util.ExtensionResource;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class InheritanceAdapter
extends AdapterImpl {
    InheritanceAdapter() {
    }

    public static InheritanceAdapter getInstance(Notifier notifier) {
        InheritanceAdapter result = (InheritanceAdapter)EcoreUtil.getExistingAdapter((Notifier)notifier, InheritanceAdapter.class);
        if (result == null) {
            if (notifier instanceof Resource) {
                result = new ForResource((Resource)notifier);
                result.adapt(notifier);
            } else if (notifier instanceof InternalUMLRTClassifier) {
                Resource resource = ((InternalUMLRTClassifier)notifier).eResource();
                if (resource != null) {
                    result = InheritanceAdapter.getInstance((Notifier)resource);
                }
                if (result != null) {
                    result.getClassifierAdapter().adapt(notifier);
                }
            } else if (notifier instanceof InternalUMLRTStateMachine || notifier instanceof InternalUMLRTRegion || notifier instanceof InternalUMLRTState || notifier instanceof InternalUMLRTTransition) {
                Resource resource = ((EObject)notifier).eResource();
                if (resource != null) {
                    result = InheritanceAdapter.getInstance((Notifier)resource);
                }
                if (result != null) {
                    result.getStateMachineAdapter().adapt(notifier);
                }
            }
        }
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == InheritanceAdapter.class;
    }

    public boolean adapt(Notifier notifier) {
        boolean result = false;
        EList adapters = notifier.eAdapters();
        if (!adapters.contains((Object)this)) {
            result = notifier.eAdapters().add((Object)this);
        }
        return result;
    }

    public boolean unadapt(Notifier notifier) {
        return notifier.eAdapters().remove((Object)this);
    }

    public final void notifyChanged(Notification msg) {
        if (msg.isTouch()) {
            return;
        }
        if (!this.isUndoRedoNotification(msg)) {
            this.prune(msg);
        }
        this.handleNotification(msg);
    }

    InheritanceAdapter getResourceAdapter() {
        return null;
    }

    InheritanceAdapter getClassifierAdapter() {
        return this.getResourceAdapter().getClassifierAdapter();
    }

    InheritanceAdapter getGeneralizationAdapter() {
        return this.getResourceAdapter().getGeneralizationAdapter();
    }

    InheritanceAdapter getStateMachineAdapter() {
        return this.getResourceAdapter().getStateMachineAdapter();
    }

    InheritanceAdapter getStructureStereotypeAdapter() {
        return this.getResourceAdapter().getStructureStereotypeAdapter();
    }

    InheritanceAdapter getStateMachineStereotypeAdapter() {
        return this.getResourceAdapter().getStructureStereotypeAdapter();
    }

    protected abstract void handleNotification(Notification var1);

    protected void touch(Notifier notifier) {
    }

    protected void prune(Notification msg) {
        if (msg.getFeature() instanceof EReference && ((EReference)msg.getFeature()).isContainment() && msg.getNotifier() instanceof InternalUMLRTRedefinitionContext) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: {
                    if (msg.getOldValue() == null) break;
                }
                case 4: 
                case 6: {
                    Object oldValue = msg.getOldValue();
                    List<Object> removed = oldValue instanceof Collection ? new ArrayList((Collection)oldValue) : (oldValue != null ? new ArrayList<EObject>(Collections.singletonList((EObject)oldValue)) : Collections.emptyList());
                    removed.removeIf(e -> e.eResource() != null);
                    if (removed.isEmpty()) break;
                    ((InternalUMLRTRedefinitionContext)msg.getNotifier()).rtPruneInheritance(removed);
                }
            }
        }
    }

    protected final <T extends InternalUMLRTRedefinitionContext<T>> void processInheritance(T root) {
        if (this.throttleInheritance(root)) {
            return;
        }
        this.processInheritance(root, null);
    }

    final <T extends InternalUMLRTRedefinitionContext<T>> void processInheritance(T root, Consumer<? super T> postAction) {
        ExtensionResource.demandExtensionExtent(root).run(root, () -> {
            HashSet<InternalUMLRTRedefinitionContext> seen = new HashSet<InternalUMLRTRedefinitionContext>();
            ArrayDeque<InternalUMLRTRedefinitionContext> breadthFirst = new ArrayDeque<InternalUMLRTRedefinitionContext>();
            seen.add(root);
            breadthFirst.offer(root);
            InternalUMLRTRedefinitionContext next = (InternalUMLRTRedefinitionContext)breadthFirst.poll();
            while (next != null) {
                InternalUMLRTRedefinitionContext ancestor = next;
                next.rtDescendants().forEach(descendant -> {
                    if (seen.add((InternalUMLRTRedefinitionContext)descendant)) {
                        breadthFirst.offer((InternalUMLRTRedefinitionContext)descendant);
                        descendant.rtInherit(ancestor);
                    }
                });
                if (postAction != null) {
                    postAction.accept(ancestor);
                }
                next = (InternalUMLRTRedefinitionContext)breadthFirst.poll();
            }
        });
    }

    protected final boolean throttleInheritance(InternalUMLRTRedefinitionContext<?> root) {
        return ((ForResource)this.getResourceAdapter()).doThrottleInheritance(root);
    }

    protected final void whileTrackingInheritance(Runnable action) {
        ((ForResource)this.getResourceAdapter()).doWhileTrackingInheritance(action);
    }

    protected <T extends InternalUMLRTRedefinitionContext<T>> void handleAncestorChanged(T descendant, Object oldObject, Object newObject, java.lang.Class<T> type) {
        InternalUMLRTRedefinitionContext oldAncestor = null;
        InternalUMLRTRedefinitionContext newAncestor = null;
        if (type.isInstance(oldObject)) {
            oldAncestor = (InternalUMLRTRedefinitionContext)type.cast(oldObject);
            descendant.rtDisinherit((InternalUMLRTRedefinitionContext)oldAncestor);
            this.unadapt((Notifier)oldAncestor);
        }
        if (type.isInstance(newObject)) {
            newAncestor = (InternalUMLRTRedefinitionContext)type.cast(newObject);
            this.adapt((Notifier)newAncestor);
            descendant.rtInherit((InternalUMLRTRedefinitionContext)newAncestor);
        }
    }

    boolean isResourceLoading() {
        return this.getResourceAdapter().isResourceLoading();
    }

    protected boolean isUndoRedoNotification(Notification msg) {
        return this.getResourceAdapter().isUndoRedoNotification(msg);
    }

    boolean isStructureStereotype(EObject object) {
        return object.eClass().getEPackage() == UMLRealTimePackage.eINSTANCE;
    }

    boolean isStateMachineStereotype(EObject object) {
        return object.eClass().getEPackage() == UMLRTStateMachinesPackage.eINSTANCE;
    }

    private static class ForClassifier
    extends InheritanceAdapter {
        private final ForResource forResource;

        ForClassifier(ForResource forResource) {
            this.forResource = forResource;
        }

        @Override
        InheritanceAdapter getResourceAdapter() {
            return this.forResource;
        }

        @Override
        InheritanceAdapter getClassifierAdapter() {
            return this;
        }

        public void setTarget(Notifier newTarget) {
            InternalUMLRTClassifier specific;
            EList generalizations;
            if (newTarget instanceof InternalUMLRTClassifier && !(generalizations = (specific = (InternalUMLRTClassifier)newTarget).getGeneralizations()).isEmpty()) {
                this.getGeneralizationAdapter().adapt((Notifier)generalizations.get(0));
                this.getGeneralizationAdapter().touch((Notifier)generalizations.get(0));
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof InternalUMLRTClassifier) {
                InternalUMLRTClassifier specific = (InternalUMLRTClassifier)oldTarget;
                specific.getGeneralizations().forEach(this.getGeneralizationAdapter()::touch);
                specific.getGeneralizations().forEach(this.getGeneralizationAdapter()::unadapt);
            }
        }

        @Override
        protected void handleNotification(Notification msg) {
            if (msg.getFeature() instanceof EReference) {
                this.handleReference(msg, (EReference)msg.getFeature());
            }
        }

        protected void handleReference(Notification msg, EReference reference) {
            block23: {
                Class class_;
                boolean notUndoRedo;
                block22: {
                    boolean bl = notUndoRedo = !this.isUndoRedoNotification(msg);
                    if (reference != UMLPackage.Literals.CLASSIFIER__GENERALIZATION) break block22;
                    InternalUMLRTClassifier specific = (InternalUMLRTClassifier)msg.getNotifier();
                    switch (msg.getEventType()) {
                        case 3: {
                            if (specific.getGeneralizations().size() == 1) {
                                Generalization gen = (Generalization)msg.getNewValue();
                                this.getGeneralizationAdapter().adapt((Notifier)gen);
                                if (notUndoRedo) {
                                    this.getGeneralizationAdapter().touch((Notifier)gen);
                                    break;
                                }
                            }
                            break block23;
                        }
                        case 4: {
                            if (specific.getGeneralizations().isEmpty()) {
                                Generalization gen = (Generalization)msg.getOldValue();
                                if (notUndoRedo) {
                                    this.getGeneralizationAdapter().touch((Notifier)gen);
                                }
                                this.getGeneralizationAdapter().unadapt((Notifier)gen);
                                break;
                            }
                            break block23;
                        }
                        case 1: {
                            if (specific.getGeneralizations().size() != 1) break block23;
                            Generalization oldGen = (Generalization)msg.getOldValue();
                            Generalization newGen = (Generalization)msg.getNewValue();
                            if (notUndoRedo) {
                                this.getGeneralizationAdapter().touch((Notifier)oldGen);
                            }
                            this.getGeneralizationAdapter().unadapt((Notifier)oldGen);
                            this.getGeneralizationAdapter().adapt((Notifier)newGen);
                            if (!notUndoRedo) break block23;
                            this.getGeneralizationAdapter().touch((Notifier)newGen);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block23;
                }
                if (reference.isContainment() && UMLPackage.Literals.OPERATION.isSuperTypeOf(reference.getEReferenceType()) && msg.getNotifier() instanceof Interface && notUndoRedo) {
                    switch (msg.getEventType()) {
                        case 1: 
                        case 3: 
                        case 5: {
                            this.touch((Notifier)msg.getNotifier());
                        }
                    }
                } else if (reference == UMLPackage.Literals.BEHAVIORED_CLASSIFIER__CLASSIFIER_BEHAVIOR && msg.getNotifier() instanceof Class && notUndoRedo && UMLUtil.getStereotypeApplication((Element)(class_ = (Class)msg.getNotifier()), Capsule.class) != null) {
                    switch (msg.getEventType()) {
                        case 1: 
                        case 2: 
                        case 9: {
                            this.touch((Notifier)class_);
                        }
                    }
                }
            }
        }

        @Override
        protected void touch(Notifier notifier) {
            if (!this.isResourceLoading() && notifier instanceof InternalUMLRTClassifier) {
                InternalUMLRTClassifier root = (InternalUMLRTClassifier)notifier;
                this.processInheritance(root);
            }
        }
    }

    private static class ForGeneralization
    extends InheritanceAdapter {
        private final ForResource forResource;

        ForGeneralization(ForResource forResource) {
            this.forResource = forResource;
        }

        @Override
        InheritanceAdapter getResourceAdapter() {
            return this.forResource;
        }

        @Override
        InheritanceAdapter getGeneralizationAdapter() {
            return this;
        }

        @Override
        protected void touch(Notifier notifier) {
            Generalization gen;
            if (notifier instanceof Generalization && (gen = (Generalization)notifier).getSpecific() != null && this.isCompatible(gen.getSpecific(), gen.getGeneral())) {
                this.handleGeneralAdded((InternalUMLRTClassifier)gen.getSpecific(), (InternalUMLRTClassifier)gen.getGeneral());
            }
        }

        boolean isCompatible(Classifier specific, Classifier general) {
            return specific instanceof InternalUMLRTClassifier && general instanceof InternalUMLRTClassifier && specific.eClass() == general.eClass();
        }

        @Override
        protected void handleNotification(Notification msg) {
            if (msg.getFeature() instanceof EReference && !this.isUndoRedoNotification(msg)) {
                this.handleReference(msg, (EReference)msg.getFeature());
            }
        }

        protected void handleReference(Notification msg, EReference reference) {
            if (reference == UMLPackage.Literals.GENERALIZATION__GENERAL) {
                Generalization generalization = (Generalization)msg.getNotifier();
                InternalUMLRTClassifier specific = (InternalUMLRTClassifier)generalization.getSpecific();
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        Classifier newGeneral;
                        Classifier oldGeneral = (Classifier)msg.getOldValue();
                        if (this.isCompatible(specific, oldGeneral)) {
                            this.handleGeneralRemoved(specific, (InternalUMLRTClassifier)oldGeneral);
                        }
                        if (!this.isCompatible(specific, newGeneral = (Classifier)msg.getNewValue())) break;
                        this.handleGeneralAdded(specific, (InternalUMLRTClassifier)newGeneral);
                    }
                }
            }
        }

        void handleGeneralAdded(InternalUMLRTClassifier specific, InternalUMLRTClassifier general) {
            UMLRTExtensionUtil.run((Element)specific, () -> ExtensionResource.demandExtensionExtent(specific).run(specific, () -> specific.rtInherit(general)));
        }

        void handleGeneralRemoved(InternalUMLRTClassifier specific, InternalUMLRTClassifier general) {
            UMLRTExtensionUtil.run((Element)specific, () -> ExtensionResource.demandExtensionExtent(specific).run(specific, () -> specific.rtDisinherit(general)));
        }
    }

    private static class ForResource
    extends InheritanceAdapter {
        private final ForClassifier forClassifier = new ForClassifier(this);
        private final ForGeneralization forGeneralization = new ForGeneralization(this);
        private final ForStateMachine forStateMachine = new ForStateMachine(this);
        private final ForStructureStereotype forStructureStereotype = new ForStructureStereotype(this);
        private final ForStateMachineStereotype forStateMachineStereotype = new ForStateMachineStereotype(this);
        private ReificationAdapter reification;
        private InheritanceTracker inheritanceTracker;

        ForResource(Resource resource) {
        }

        @Override
        final InheritanceAdapter getResourceAdapter() {
            return this;
        }

        @Override
        final InheritanceAdapter getClassifierAdapter() {
            return this.forClassifier;
        }

        @Override
        final InheritanceAdapter getGeneralizationAdapter() {
            return this.forGeneralization;
        }

        @Override
        final InheritanceAdapter getStateMachineAdapter() {
            return this.forStateMachine;
        }

        @Override
        final ForStructureStereotype getStructureStereotypeAdapter() {
            return this.forStructureStereotype;
        }

        @Override
        final ForStateMachineStereotype getStateMachineStereotypeAdapter() {
            return this.forStateMachineStereotype;
        }

        @Override
        protected boolean isUndoRedoNotification(Notification msg) {
            return this.getReificationAdapter().isUndoRedoNotification(msg);
        }

        final ReificationAdapter getReificationAdapter() {
            if (this.reification == null) {
                this.reification = ExtensionResource.demandExtensionExtent(this.getTarget()).getReificationAdapter();
            }
            return this.reification;
        }

        @Override
        boolean isResourceLoading() {
            return this.target != null && ((Resource.Internal)this.target).isLoading();
        }

        final boolean doThrottleInheritance(InternalUMLRTRedefinitionContext<?> root) {
            return this.inheritanceTracker != null && this.inheritanceTracker.track(root);
        }

        final void doWhileTrackingInheritance(Runnable action) {
            boolean postProcess;
            if (this.inheritanceTracker == null) {
                this.inheritanceTracker = new InheritanceTracker();
                postProcess = true;
            } else {
                postProcess = false;
            }
            try {
                action.run();
            }
            finally {
                if (postProcess) {
                    InheritanceTracker deferred = this.inheritanceTracker;
                    this.inheritanceTracker = null;
                    deferred.processInheritance();
                }
            }
        }

        boolean isUMLRTStereotype(EObject object) {
            EPackage ePackage = object.eClass().getEPackage();
            return ePackage == UMLRealTimePackage.eINSTANCE || ePackage == UMLRTStateMachinesPackage.eINSTANCE;
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget == this.target) {
                Resource resource = (Resource)oldTarget;
                resource.getContents().stream().filter(this::isUMLRTStereotype).forEach(stereo -> {
                    boolean bl = stereo.eAdapters().remove((Object)this);
                });
                super.unsetTarget(oldTarget);
            }
        }

        @Override
        protected void handleNotification(Notification msg) {
            block21: {
                block22: {
                    if (!(msg.getNotifier() instanceof Resource)) break block21;
                    if (msg.getFeatureID(Resource.class) != 2) break block22;
                    switch (msg.getEventType()) {
                        case 3: {
                            EObject newObject = (EObject)msg.getNewValue();
                            if (this.isStructureStereotype(newObject)) {
                                this.getStructureStereotypeAdapter().adapt((Notifier)newObject);
                                this.getStructureStereotypeAdapter().handleStereotypeAdded(newObject, msg);
                                break;
                            }
                            if (this.isStateMachineStereotype(newObject)) {
                                this.getStateMachineStereotypeAdapter().adapt((Notifier)newObject);
                                this.getStateMachineStereotypeAdapter().handleStereotypeAdded(newObject, msg);
                                break;
                            }
                            break block21;
                        }
                        case 4: {
                            EObject oldObject = (EObject)msg.getOldValue();
                            if (this.isStructureStereotype(oldObject)) {
                                this.getStructureStereotypeAdapter().unadapt((Notifier)oldObject);
                                this.getStructureStereotypeAdapter().handleStereotypeRemoved(oldObject, msg);
                                break;
                            }
                            if (this.isStateMachineStereotype(oldObject)) {
                                this.getStateMachineStereotypeAdapter().unadapt((Notifier)oldObject);
                                this.getStateMachineStereotypeAdapter().handleStereotypeRemoved(oldObject, msg);
                                break;
                            }
                            break block21;
                        }
                        case 1: {
                            EObject oldObject = (EObject)msg.getOldValue();
                            if (this.isStructureStereotype(oldObject)) {
                                this.getStructureStereotypeAdapter().unadapt((Notifier)oldObject);
                                this.getStructureStereotypeAdapter().handleStereotypeRemoved(oldObject, msg);
                            } else if (this.isStateMachineStereotype(oldObject)) {
                                this.getStateMachineStereotypeAdapter().unadapt((Notifier)oldObject);
                                this.getStateMachineStereotypeAdapter().handleStereotypeRemoved(oldObject, msg);
                            }
                            EObject newObject = (EObject)msg.getNewValue();
                            if (this.isStructureStereotype(newObject)) {
                                this.getStructureStereotypeAdapter().adapt((Notifier)newObject);
                                this.getStructureStereotypeAdapter().handleStereotypeAdded(newObject, msg);
                                break;
                            }
                            if (this.isStateMachineStereotype(newObject)) {
                                this.getStateMachineStereotypeAdapter().adapt((Notifier)newObject);
                                this.getStateMachineStereotypeAdapter().handleStereotypeAdded(newObject, msg);
                                break;
                            }
                            break block21;
                        }
                        case 5: {
                            for (Object next : (Collection)msg.getNewValue()) {
                                EObject newObject = (EObject)next;
                                if (this.isStructureStereotype(newObject)) {
                                    this.getStructureStereotypeAdapter().adapt((Notifier)newObject);
                                    this.getStructureStereotypeAdapter().handleStereotypeAdded(newObject, msg);
                                    continue;
                                }
                                if (!this.isStateMachineStereotype(newObject)) continue;
                                this.getStateMachineStereotypeAdapter().adapt((Notifier)newObject);
                                this.getStateMachineStereotypeAdapter().handleStereotypeAdded(newObject, msg);
                            }
                            break block21;
                        }
                        case 6: {
                            for (Object next : (Collection)msg.getOldValue()) {
                                EObject oldObject = (EObject)next;
                                if (this.isStructureStereotype(oldObject)) {
                                    this.getStructureStereotypeAdapter().unadapt((Notifier)oldObject);
                                    this.getStructureStereotypeAdapter().handleStereotypeRemoved(oldObject, msg);
                                    continue;
                                }
                                if (!this.isStateMachineStereotype(oldObject)) continue;
                                this.getStateMachineStereotypeAdapter().unadapt((Notifier)oldObject);
                                this.getStateMachineStereotypeAdapter().handleStereotypeRemoved(oldObject, msg);
                            }
                        }
                    }
                    break block21;
                }
                if (msg.getFeatureID(Resource.class) == 4 && !msg.getOldBooleanValue() && msg.getNewBooleanValue()) {
                    this.whileTrackingInheritance(() -> this.discoverContents((Resource)msg.getNotifier()));
                }
            }
        }

        void discoverContents(Resource resource) {
            UMLRTStateMachinesSwitch<EObject> smDiscoverySwitch = new UMLRTStateMachinesSwitch<EObject>(){

                public EObject caseRTStateMachine(RTStateMachine object) {
                    if (object.getBase_StateMachine() != null) {
                        this.getStateMachineAdapter().touch((Notifier)object.getBase_StateMachine());
                    }
                    return object;
                }

                public EObject caseRTRegion(RTRegion object) {
                    Region region = object.getBase_Region();
                    if (region != null) {
                        this.getStateMachineAdapter().touch((Notifier)region);
                        UMLRTExtensionUtil.getUMLRTContents((EObject)region, (EStructuralFeature)UMLPackage.Literals.REGION__TRANSITION, new EStructuralFeature[0]).forEach(this.getStateMachineAdapter()::touch);
                    }
                    return object;
                }

                public EObject caseRTState(RTState object) {
                    if (object.getBase_State() != null) {
                        this.getStateMachineAdapter().touch((Notifier)object.getBase_State());
                    }
                    return object;
                }

                public EObject caseRTGuard(RTGuard object) {
                    Namespace context;
                    Constraint base = object.getBase_Constraint();
                    if (base != null && (context = base.getContext()) instanceof Transition) {
                        this.getStateMachineAdapter().touch((Notifier)context);
                    }
                    return object;
                }
            };
            UMLRealTimeSwitch<EObject> discoverySwitch = new UMLRealTimeSwitch<EObject>((Switch)smDiscoverySwitch){
                private final /* synthetic */ Switch val$smDiscoverySwitch;
                {
                    this.val$smDiscoverySwitch = switch_;
                }

                public EObject caseCapsule(Capsule object) {
                    if (object.getBase_Class() != null) {
                        this.getClassifierAdapter().touch((Notifier)object.getBase_Class());
                    }
                    return object;
                }

                public EObject caseProtocol(Protocol object) {
                    if (object.getBase_Collaboration() != null) {
                        this.getClassifierAdapter().touch((Notifier)object.getBase_Collaboration());
                    }
                    return object;
                }

                public EObject caseRTMessageSet(RTMessageSet object) {
                    if (object.getBase_Interface() != null) {
                        this.getClassifierAdapter().touch((Notifier)object.getBase_Interface());
                    }
                    return object;
                }

                public EObject defaultCase(EObject object) {
                    return (EObject)this.val$smDiscoverySwitch.doSwitch(object);
                }
            };
            EList contents = resource.getContents();
            List range = new ArrayList(contents);
            do {
                int count = contents.size();
                ArrayList range_ = range;
                ExtensionResource extent = ExtensionResource.demandExtensionExtent(resource);
                extent.run(resource, () -> ForResource.lambda$2(range_, (Switch)discoverySwitch));
                range = contents.subList(count, contents.size());
                if (range.isEmpty()) continue;
                range = new ArrayList(range);
            } while (!range.isEmpty());
        }

        private static /* synthetic */ void lambda$2(List list, Switch switch_) {
            list.forEach(arg_0 -> ((Switch)switch_).doSwitch(arg_0));
        }
    }

    private static class ForStateMachine
    extends InheritanceAdapter {
        private final ForResource forResource;

        ForStateMachine(ForResource forResource) {
            this.forResource = forResource;
        }

        @Override
        InheritanceAdapter getResourceAdapter() {
            return this.forResource;
        }

        @Override
        InheritanceAdapter getStateMachineAdapter() {
            return this;
        }

        public void setTarget(Notifier newTarget) {
            InternalUMLRTTransition transition;
            InternalUMLRTTransition redefined;
            if (newTarget instanceof InternalUMLRTStateMachine) {
                EList regions;
                InternalUMLRTStateMachine machine = (InternalUMLRTStateMachine)newTarget;
                InternalUMLRTStateMachine extended = (InternalUMLRTStateMachine)machine.rtGetAncestor();
                if (extended != null) {
                    this.getStateMachineAdapter().adapt((Notifier)extended);
                    this.touch((Notifier)extended);
                }
                if (!(regions = machine.getRegions()).isEmpty()) {
                    regions.forEach(this.getStateMachineAdapter()::adapt);
                }
            } else if (newTarget instanceof InternalUMLRTRegion) {
                EList members;
                InternalUMLRTRegion region = (InternalUMLRTRegion)newTarget;
                InternalUMLRTRegion extended = (InternalUMLRTRegion)region.rtGetAncestor();
                if (extended != null) {
                    this.getStateMachineAdapter().adapt((Notifier)extended);
                    this.touch((Notifier)extended);
                    UMLRTExtensionUtil.getUMLRTContents((EObject)region, (EStructuralFeature)UMLPackage.Literals.REGION__TRANSITION, new EStructuralFeature[0]).forEach(this.getStateMachineAdapter()::adapt);
                }
                if (!(members = region.getOwnedMembers()).isEmpty()) {
                    Predicate<NamedElement> isState = State.class::isInstance;
                    Predicate<NamedElement> isTransition = Transition.class::isInstance;
                    members.stream().filter(isState.or(isTransition)).forEach(this.getStateMachineAdapter()::adapt);
                }
            } else if (newTarget instanceof InternalUMLRTState) {
                EList regions;
                InternalUMLRTState state = (InternalUMLRTState)newTarget;
                InternalUMLRTState redefined2 = (InternalUMLRTState)state.rtGetAncestor();
                if (redefined2 != null) {
                    this.getStateMachineAdapter().adapt((Notifier)redefined2);
                    this.touch((Notifier)redefined2);
                }
                if (!(regions = state.getRegions()).isEmpty()) {
                    regions.forEach(this.getStateMachineAdapter()::adapt);
                }
            } else if (newTarget instanceof InternalUMLRTTransition && (redefined = (InternalUMLRTTransition)(transition = (InternalUMLRTTransition)newTarget).rtGetAncestor()) != null) {
                this.getStateMachineAdapter().adapt((Notifier)redefined);
                this.touch((Notifier)redefined);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof InternalUMLRTStateMachine) {
                EList regions;
                InternalUMLRTStateMachine machine = (InternalUMLRTStateMachine)oldTarget;
                InternalUMLRTStateMachine redefined = (InternalUMLRTStateMachine)machine.rtGetAncestor();
                if (redefined != null) {
                    this.getStateMachineAdapter().unadapt((Notifier)redefined);
                }
                if (!(regions = machine.getRegions()).isEmpty()) {
                    regions.forEach(this.getStateMachineAdapter()::unadapt);
                }
            }
        }

        @Override
        protected void handleNotification(Notification msg) {
            if (msg.getFeature() instanceof EReference) {
                EReference reference = (EReference)msg.getFeature();
                if (!this.isUndoRedoNotification(msg)) {
                    this.handleReference(msg, reference);
                } else if (msg.getNotifier() instanceof Transition && UMLPackage.Literals.CONSTRAINT.isSuperTypeOf(reference.getEReferenceType())) {
                    Transition transition = (Transition)msg.getNotifier();
                    FacadeAdapter.getInstance((Notifier)transition).ifPresent(fa -> UMLRTExtensionUtil.getUMLRTContents((EObject)transition, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TRIGGER, new EStructuralFeature[0]).forEach(fa::tickle));
                }
            }
        }

        protected void handleReference(Notification msg, EReference reference) {
            Notifier notifier;
            if (reference == UMLPackage.Literals.STATE_MACHINE__EXTENDED_STATE_MACHINE) {
                InternalUMLRTStateMachine machine = (InternalUMLRTStateMachine)msg.getNotifier();
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: {
                        this.handleAncestorChanged(machine, msg.getOldValue(), msg.getNewValue(), InternalUMLRTStateMachine.class);
                    }
                }
            } else if (reference == UMLPackage.Literals.REGION__EXTENDED_REGION) {
                InternalUMLRTRegion region = (InternalUMLRTRegion)msg.getNotifier();
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: 
                    case 9: {
                        this.handleAncestorChanged(region, msg.getOldValue(), msg.getNewValue(), InternalUMLRTRegion.class);
                    }
                }
            } else if (reference == UMLPackage.Literals.STATE__REDEFINED_STATE) {
                InternalUMLRTState state = (InternalUMLRTState)msg.getNotifier();
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: 
                    case 9: {
                        this.handleAncestorChanged(state, msg.getOldValue(), msg.getNewValue(), InternalUMLRTState.class);
                    }
                }
            } else if (reference == UMLPackage.Literals.TRANSITION__REDEFINED_TRANSITION) {
                InternalUMLRTTransition transition = (InternalUMLRTTransition)msg.getNotifier();
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: 
                    case 9: {
                        this.handleAncestorChanged(transition, msg.getOldValue(), msg.getNewValue(), InternalUMLRTTransition.class);
                    }
                }
            } else if (reference.isContainment() && ((notifier = (Notifier)msg.getNotifier()) instanceof Region && UMLPackage.Literals.TRANSITION.isSuperTypeOf(reference.getEReferenceType()) || notifier instanceof Transition && UMLPackage.Literals.TRIGGER.isSuperTypeOf(reference.getEReferenceType()) || notifier instanceof Transition && UMLPackage.Literals.CONSTRAINT.isSuperTypeOf(reference.getEReferenceType()))) {
                if (UMLPackage.Literals.TRANSITION.isSuperTypeOf(reference.getEReferenceType())) {
                    if (msg.getNewValue() instanceof Transition) {
                        this.getStateMachineAdapter().adapt((Notifier)((Transition)msg.getNewValue()));
                    } else if (msg.getNewValue() instanceof Collection) {
                        Collection newTransitions = (Collection)msg.getNewValue();
                        newTransitions.forEach(this.getStateMachineAdapter()::adapt);
                    }
                }
                switch (msg.getEventType()) {
                    case 1: 
                    case 3: 
                    case 5: {
                        this.touch(notifier);
                    }
                }
            }
        }

        @Override
        protected void touch(Notifier notifier) {
            if (!this.isResourceLoading()) {
                if (notifier instanceof InternalUMLRTStateMachine) {
                    InternalUMLRTStateMachine root = (InternalUMLRTStateMachine)notifier;
                    this.processInheritance(root);
                } else if (notifier instanceof InternalUMLRTRegion) {
                    InternalUMLRTRegion root = (InternalUMLRTRegion)notifier;
                    this.processInheritance(root);
                } else if (notifier instanceof InternalUMLRTState) {
                    InternalUMLRTState root = (InternalUMLRTState)notifier;
                    this.processInheritance(root);
                } else if (notifier instanceof InternalUMLRTTransition) {
                    InternalUMLRTTransition root = (InternalUMLRTTransition)notifier;
                    this.processInheritance(root);
                }
            }
        }
    }

    private static class ForStateMachineStereotype
    extends InheritanceAdapter {
        private final ForResource forResource;

        ForStateMachineStereotype(ForResource forResource) {
            this.forResource = forResource;
        }

        @Override
        InheritanceAdapter getResourceAdapter() {
            return this.forResource;
        }

        @Override
        InheritanceAdapter getStateMachineStereotypeAdapter() {
            return this;
        }

        @Override
        protected void handleNotification(Notification msg) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: {
                    EReference ref;
                    if (!(msg.getFeature() instanceof EReference) || !(ref = (EReference)msg.getFeature()).getName().startsWith("base_")) break;
                    EObject application = (EObject)msg.getNotifier();
                    if (msg.getOldValue() != null) {
                        this.handleStereotypeRemoved(application, msg);
                    }
                    if (msg.getNewValue() == null) break;
                    this.handleStereotypeAdded(application, msg);
                }
            }
        }

        void handleStereotypeAdded(EObject stereotypeApplication, Notification msg) {
            boolean isUndoRedo = this.isUndoRedoNotification(msg);
            switch (stereotypeApplication.eClass().getClassifierID()) {
                case 0: {
                    RTStateMachine machine = (RTStateMachine)stereotypeApplication;
                    StateMachine base = machine.getBase_StateMachine();
                    if (base == null) break;
                    this.getStateMachineAdapter().adapt((Notifier)machine.getBase_StateMachine());
                    if (isUndoRedo || base.getContext() == null) break;
                    this.getClassifierAdapter().touch((Notifier)base.getContext());
                    break;
                }
                case 1: {
                    RTRegion region = (RTRegion)stereotypeApplication;
                    Region base = region.getBase_Region();
                    if (base == null) break;
                    this.getStateMachineAdapter().adapt((Notifier)base);
                    if (isUndoRedo) break;
                    if (base.getStateMachine() != null) {
                        this.getStateMachineAdapter().touch((Notifier)base.getStateMachine());
                    }
                    if (base.getState() == null) break;
                    this.getStateMachineAdapter().touch((Notifier)base.getState());
                    break;
                }
                case 2: {
                    Region container;
                    RTState state = (RTState)stereotypeApplication;
                    State base = state.getBase_State();
                    if (base == null || base.getContainer() == null) break;
                    this.getStateMachineAdapter().adapt((Notifier)state.getBase_State());
                    if (!isUndoRedo) {
                        this.getStateMachineAdapter().touch((Notifier)base.getContainer());
                    }
                    if ((container = base.getContainer()) == null) break;
                    FacadeAdapter.getInstance((Notifier)container).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 3: {
                    RTPseudostate pseudo = (RTPseudostate)stereotypeApplication;
                    Pseudostate base = pseudo.getBase_Pseudostate();
                    if (base == null) break;
                    if (base.getContainer() != null) {
                        if (!isUndoRedo) {
                            this.getStateMachineAdapter().touch((Notifier)base.getContainer());
                        }
                        FacadeAdapter.getInstance((Notifier)base.getContainer()).ifPresent(a -> a.tickle((NamedElement)base));
                        break;
                    }
                    if (base.getState() != null) {
                        if (!isUndoRedo) {
                            this.getStateMachineAdapter().touch((Notifier)base.getState());
                        }
                        FacadeAdapter.getInstance((Notifier)base.getState()).ifPresent(a -> a.tickle((NamedElement)base));
                        break;
                    }
                    if (base.getStateMachine() == null) break;
                    if (!isUndoRedo) {
                        this.getStateMachineAdapter().touch((Notifier)base.getStateMachine());
                    }
                    FacadeAdapter.getInstance((Notifier)base.getStateMachine()).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 5: {
                    Namespace context;
                    RTGuard guard = (RTGuard)stereotypeApplication;
                    Constraint base = guard.getBase_Constraint();
                    if (base == null || !((context = base.getContext()) instanceof Transition)) break;
                    if (!isUndoRedo) {
                        this.getStateMachineAdapter().touch((Notifier)context);
                    }
                    FacadeAdapter.getInstance((Notifier)context).ifPresent(a -> a.tickle((NamedElement)base));
                }
            }
        }

        void handleStereotypeRemoved(EObject stereotypeApplication, Notification msg) {
        }
    }

    private static class ForStructureStereotype
    extends InheritanceAdapter {
        private final ForResource forResource;

        ForStructureStereotype(ForResource forResource) {
            this.forResource = forResource;
        }

        @Override
        InheritanceAdapter getResourceAdapter() {
            return this.forResource;
        }

        @Override
        InheritanceAdapter getStructureStereotypeAdapter() {
            return this;
        }

        @Override
        protected void handleNotification(Notification msg) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: {
                    if (!(msg.getFeature() instanceof EReference)) break;
                    EReference ref = (EReference)msg.getFeature();
                    if (ref.getName().startsWith("base_")) {
                        EObject application = (EObject)msg.getNotifier();
                        if (msg.getOldValue() != null) {
                            this.handleStereotypeRemoved(application, msg);
                        }
                        if (msg.getNewValue() == null) break;
                        this.handleStereotypeAdded(application, msg);
                        break;
                    }
                    if (this.isResourceLoading() || ref != UMLRealTimePackage.Literals.RT_REDEFINED_ELEMENT__ROOT_FRAGMENT) break;
                    this.notifyExclusion((RTRedefinedElement)msg.getNotifier(), (RedefinableElement)msg.getNewValue());
                }
            }
        }

        void handleStereotypeAdded(EObject stereotypeApplication, Notification msg) {
            boolean isUndoRedo = this.isUndoRedoNotification(msg);
            switch (stereotypeApplication.eClass().getClassifierID()) {
                case 0: {
                    Capsule capsule = (Capsule)stereotypeApplication;
                    Class base = capsule.getBase_Class();
                    if (base == null) break;
                    this.getClassifierAdapter().adapt((Notifier)base);
                    Package package_ = base.getNearestPackage();
                    if (package_ == null) break;
                    FacadeAdapter.getInstance((Notifier)package_).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 3: {
                    Class capsule;
                    RTPort port = (RTPort)stereotypeApplication;
                    Port base = port.getBase_Port();
                    Class clazz = capsule = base == null ? null : base.getClass_();
                    if (capsule == null) break;
                    if (!isUndoRedo) {
                        this.getClassifierAdapter().touch((Notifier)capsule);
                    }
                    FacadeAdapter.getInstance((Notifier)capsule).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 1: {
                    Class capsule;
                    CapsulePart part = (CapsulePart)stereotypeApplication;
                    Property base = part.getBase_Property();
                    Class clazz = capsule = base == null ? null : base.getClass_();
                    if (capsule == null) break;
                    if (!isUndoRedo) {
                        this.getClassifierAdapter().touch((Notifier)capsule);
                    }
                    FacadeAdapter.getInstance((Notifier)capsule).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 4: {
                    Namespace capsule;
                    RTConnector connector = (RTConnector)stereotypeApplication;
                    Connector base = connector.getBase_Connector();
                    Namespace namespace = capsule = base == null ? null : base.getNamespace();
                    if (!(capsule instanceof Class)) break;
                    if (!isUndoRedo) {
                        this.getClassifierAdapter().touch((Notifier)capsule);
                    }
                    FacadeAdapter.getInstance((Notifier)capsule).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 2: {
                    Protocol protocol = (Protocol)stereotypeApplication;
                    Collaboration base = protocol.getBase_Collaboration();
                    if (base == null) break;
                    this.getClassifierAdapter().adapt((Notifier)base);
                    Package package_ = base.getNearestPackage();
                    if (package_ == null || (package_ = package_.getNestingPackage()) == null) break;
                    FacadeAdapter.getInstance((Notifier)package_).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 7: {
                    RTMessageSet messageSet = (RTMessageSet)stereotypeApplication;
                    Interface base = messageSet.getBase_Interface();
                    if (base == null) break;
                    this.getClassifierAdapter().adapt((Notifier)base);
                    FacadeAdapter.getInstance((Notifier)base).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 5: {
                    Package package_;
                    ProtocolContainer protocolContainer = (ProtocolContainer)stereotypeApplication;
                    Package base = protocolContainer.getBase_Package();
                    if (base == null || (package_ = base.getNestingPackage()) == null) break;
                    FacadeAdapter.getInstance((Notifier)package_).ifPresent(a -> a.tickle((NamedElement)base));
                    break;
                }
                case 6: {
                    RTRedefinedElement redefinedElement = (RTRedefinedElement)stereotypeApplication;
                    RedefinableElement base = redefinedElement.getBase_RedefinableElement();
                    if (base == null || this.isResourceLoading()) break;
                    this.notifyExclusion(redefinedElement, redefinedElement.getRootFragment());
                }
            }
        }

        void handleStereotypeRemoved(EObject stereotypeApplication, Notification msg) {
        }

        void notifyExclusion(RTRedefinedElement rtRedef, RedefinableElement newRoot) {
            RedefinableElement uml = rtRedef.getBase_RedefinableElement();
            if (uml != null) {
                InternalEObject ext;
                ENotificationImpl exclusionMsg = null;
                Namespace namespace = null;
                if (newRoot != null) {
                    namespace = uml.getNamespace();
                    if (namespace instanceof InternalUMLRTElement) {
                        ext = (InternalEObject)namespace.eGet((EStructuralFeature)ExtUMLExtPackage.Literals.ELEMENT__EXTENSION);
                        exclusionMsg = new ENotificationImpl(ext, 4, (EStructuralFeature)ExtUMLExtPackage.Literals.ELEMENT__EXCLUDED_ELEMENT, (Object)uml, null, -1);
                        if (ext == null) {
                            exclusionMsg = NotificationForwarder.wrap((InternalEObject)namespace, (Notification)exclusionMsg);
                        }
                    }
                } else if (newRoot == null && (namespace = uml.getNamespace()) instanceof InternalUMLRTElement) {
                    ext = (InternalEObject)namespace.eGet((EStructuralFeature)ExtUMLExtPackage.Literals.ELEMENT__EXTENSION);
                    exclusionMsg = new ENotificationImpl(ext, 3, (EStructuralFeature)ExtUMLExtPackage.Literals.ELEMENT__EXCLUDED_ELEMENT, null, (Object)uml, -1);
                    if (ext == null) {
                        exclusionMsg = NotificationForwarder.wrap((InternalEObject)namespace, (Notification)exclusionMsg);
                    }
                }
                if (exclusionMsg != null) {
                    ENotificationImpl msgs = new ENotificationImpl((InternalEObject)uml, 1, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__QUALIFIED_NAME, uml.getQualifiedName(), uml.getQualifiedName()){

                        public boolean isTouch() {
                            return false;
                        }
                    };
                    msgs.add(exclusionMsg);
                    msgs.dispatch();
                    if (namespace != null) {
                        Consumer<FacadeAdapter> action = newRoot == null ? a -> a.excluded((Element)uml) : a -> a.reinherited((Element)uml);
                        FacadeAdapter.getInstance((Notifier)namespace).ifPresent(action);
                    }
                }
            }
        }
    }

    private class InheritanceTracker {
        private final Set<InternalUMLRTRedefinitionContext<?>> elements = new HashSet();
        private final boolean deferred;

        InheritanceTracker(boolean deferred) {
            this.deferred = deferred;
        }

        InheritanceTracker() {
            this(true);
        }

        boolean track(InternalUMLRTRedefinitionContext<?> element) {
            return !this.elements.add(element) || this.deferred;
        }

        void processInheritance() {
            if (!this.deferred || this.elements.isEmpty()) {
                return;
            }
            Resource resource = (Resource)InheritanceAdapter.this.getResourceAdapter().getTarget();
            CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)resource);
            if (cache != null) {
                cache.clear(resource);
            }
            List<InternalUMLRTRedefinitionContext> roots = this.elements.stream().filter(e -> e.rtGetAncestor() == null).collect(Collectors.toList());
            roots.forEach(this::doProcessInheritance);
            if (!this.elements.isEmpty()) {
                UMLRTUMLPlugin.INSTANCE.log("Deferred inheritance processing has left-overs: " + this.elements);
                new ArrayList(this.elements).forEach((Consumer<InternalUMLRTRedefinitionContext<?>>)((Consumer<InternalUMLRTRedefinitionContext>)this::doProcessInheritance));
            }
        }

        private void doProcessInheritance(InternalUMLRTRedefinitionContext root) {
            InheritanceAdapter.this.processInheritance(root, this.elements::remove);
        }
    }
}

