/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.BaseContainer;
import org.eclipse.papyrusrt.xtumlrt.common.Behaviour;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.Generalization;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolContainer;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class XTUMLRTVirtualInheritanceExtensions {
    public static Behaviour getActualBehaviour(Capsule capsule) {
        Behaviour _xblockexpression = null;
        Behaviour behaviour = null;
        if (capsule != null) {
            boolean _tripleNotEquals;
            Behaviour _behaviour = capsule.getBehaviour();
            boolean bl = _tripleNotEquals = _behaviour != null;
            if (_tripleNotEquals) {
                Behaviour _behaviour_1;
                behaviour = _behaviour_1 = capsule.getBehaviour();
            } else if (capsule.getRedefines() != null && capsule.getRedefines() instanceof Capsule) {
                Behaviour _actualBehaviour;
                RedefinableElement _redefines = capsule.getRedefines();
                behaviour = _actualBehaviour = XTUMLRTVirtualInheritanceExtensions.getActualBehaviour((Capsule)_redefines);
            }
        }
        _xblockexpression = behaviour;
        return _xblockexpression;
    }

    public static Iterable<Attribute> getAllAttributes(final StructuredType struct) {
        LinkedHashSet<Attribute> _xblockexpression = null;
        LinkedHashSet<Attribute> allAttributes = new LinkedHashSet<Attribute>();
        if (struct != null) {
            Iterable<Attribute> _classAttributes = XTUMLRTUtil.getClassAttributes(struct);
            Iterables.addAll(allAttributes, _classAttributes);
            RedefinableElement parentElement = struct.getRedefines();
            if (parentElement != null && parentElement instanceof StructuredType) {
                StructuredType parent = (StructuredType)parentElement;
                Iterable<Attribute> _allAttributes = XTUMLRTVirtualInheritanceExtensions.getAllAttributes(parent);
                Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

                    public Boolean apply(Attribute it) {
                        boolean _redefines = XTUMLRTVirtualInheritanceExtensions.redefines((NamedElement)struct, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allAttributes, (Functions.Function1)_function);
                Iterables.addAll(allAttributes, (Iterable)_filter);
            }
        }
        _xblockexpression = allAttributes;
        return _xblockexpression;
    }

    public static Iterable<Capsule> getAllCapsules(BaseContainer packge) {
        LinkedHashSet<Capsule> _xblockexpression = null;
        LinkedHashSet<Capsule> set = new LinkedHashSet<Capsule>();
        EList _entities = packge.getEntities();
        Iterable _filter = Iterables.filter((Iterable)_entities, Capsule.class);
        Iterables.addAll(set, (Iterable)_filter);
        EList _packages = packge.getPackages();
        for (Package pkg : _packages) {
            Iterable<Capsule> _allCapsules = XTUMLRTVirtualInheritanceExtensions.getAllCapsules((BaseContainer)pkg);
            Iterables.addAll(set, _allCapsules);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    public static Iterable<Port> getAllRTPorts(final Capsule capsule) {
        LinkedHashSet<Port> _xblockexpression = null;
        LinkedHashSet<Port> allPorts = new LinkedHashSet<Port>();
        if (capsule != null) {
            Iterable<Port> _rTPorts = XTUMLRTUtil.getRTPorts(capsule);
            Iterables.addAll(allPorts, _rTPorts);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Port> _allRTPorts = XTUMLRTVirtualInheritanceExtensions.getAllRTPorts(parent);
                Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                    public Boolean apply(Port it) {
                        boolean _redefines = XTUMLRTVirtualInheritanceExtensions.redefines((NamedElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allRTPorts, (Functions.Function1)_function);
                Iterables.addAll(allPorts, (Iterable)_filter);
            }
        }
        _xblockexpression = allPorts;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getAllCapsuleParts(final Capsule capsule) {
        LinkedHashSet<CapsulePart> _xblockexpression = null;
        LinkedHashSet<CapsulePart> allParts = new LinkedHashSet<CapsulePart>();
        if (capsule != null) {
            Iterable<CapsulePart> _capsuleParts = XTUMLRTUtil.getCapsuleParts(capsule);
            Iterables.addAll(allParts, _capsuleParts);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<CapsulePart> _allCapsuleParts = XTUMLRTVirtualInheritanceExtensions.getAllCapsuleParts(parent);
                Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

                    public Boolean apply(CapsulePart it) {
                        boolean _redefines = XTUMLRTVirtualInheritanceExtensions.redefines((NamedElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allCapsuleParts, (Functions.Function1)_function);
                Iterables.addAll(allParts, (Iterable)_filter);
            }
        }
        _xblockexpression = allParts;
        return _xblockexpression;
    }

    public static Iterable<Connector> getAllConnectors(final Capsule capsule) {
        LinkedHashSet<Connector> _xblockexpression = null;
        LinkedHashSet<Connector> allConnectors = new LinkedHashSet<Connector>();
        if (capsule != null) {
            Iterable<Connector> _capsuleConnectors = XTUMLRTUtil.getCapsuleConnectors(capsule);
            Iterables.addAll(allConnectors, _capsuleConnectors);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Connector> _allConnectors = XTUMLRTVirtualInheritanceExtensions.getAllConnectors(parent);
                Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

                    public Boolean apply(Connector it) {
                        boolean _redefines = XTUMLRTVirtualInheritanceExtensions.redefines((NamedElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allConnectors, (Functions.Function1)_function);
                Iterables.addAll(allConnectors, (Iterable)_filter);
            }
        }
        _xblockexpression = allConnectors;
        return _xblockexpression;
    }

    public static Iterable<Protocol> getAllProtocols(ProtocolContainer packge) {
        LinkedHashSet<Protocol> _xblockexpression = null;
        LinkedHashSet<Protocol> set = new LinkedHashSet<Protocol>();
        EList _protocols = packge.getProtocols();
        set.addAll((Collection<Protocol>)_protocols);
        EList _packages = packge.getPackages();
        for (Package pkg : _packages) {
            Iterable<Protocol> _allProtocols = XTUMLRTVirtualInheritanceExtensions.getAllProtocols((ProtocolContainer)pkg);
            Iterables.addAll(set, _allProtocols);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    public static Iterable<Signal> getAllSignals(final Protocol protocol) {
        LinkedHashSet<Signal> _xblockexpression = null;
        LinkedHashSet<Signal> allSignals = new LinkedHashSet<Signal>();
        if (protocol != null) {
            Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
            Iterables.addAll(allSignals, _signals);
            RedefinableElement parentElement = protocol.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Protocol parent = (Protocol)parentElement;
                Iterable<Signal> _allSignals = XTUMLRTVirtualInheritanceExtensions.getAllSignals(parent);
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it) {
                        boolean _redefines = XTUMLRTVirtualInheritanceExtensions.redefines((NamedElement)protocol, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allSignals, (Functions.Function1)_function);
                Iterables.addAll(allSignals, (Iterable)_filter);
            }
        }
        _xblockexpression = allSignals;
        return _xblockexpression;
    }

    public static Iterable<Attribute> getAttributeRedefinitions(StructuredType struct) {
        EList _attributes = struct.getAttributes();
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Attribute;
            }
        };
        return IterableExtensions.filter((Iterable)_attributes, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getPartRedefinitions(Capsule capsule) {
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return it.getRedefines() != null && it.getRedefines() instanceof CapsulePart;
            }
        };
        return IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
    }

    public static Iterable<Port> getPortRedefinitions(Capsule capsule) {
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Port;
            }
        };
        return IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
    }

    public static Iterable<Connector> getConnectorRedefinitions(Capsule capsule) {
        EList _connectors = capsule.getConnectors();
        Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Connector;
            }
        };
        return IterableExtensions.filter((Iterable)_connectors, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getSignalRedefinitions(Protocol protocol) {
        Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Signal;
            }
        };
        return IterableExtensions.filter(_signals, (Functions.Function1)_function);
    }

    public static Iterable<Attribute> getRedefinedAttributes(StructuredType struct) {
        Iterable<Attribute> _attributeRedefinitions = XTUMLRTVirtualInheritanceExtensions.getAttributeRedefinitions(struct);
        Functions.Function1<Attribute, Attribute> _function = new Functions.Function1<Attribute, Attribute>(){

            public Attribute apply(Attribute it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Attribute)_redefines;
            }
        };
        return IterableExtensions.map(_attributeRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getRedefinedParts(Capsule capsule) {
        Iterable<CapsulePart> _partRedefinitions = XTUMLRTVirtualInheritanceExtensions.getPartRedefinitions(capsule);
        Functions.Function1<CapsulePart, CapsulePart> _function = new Functions.Function1<CapsulePart, CapsulePart>(){

            public CapsulePart apply(CapsulePart it) {
                RedefinableElement _redefines = it.getRedefines();
                return (CapsulePart)_redefines;
            }
        };
        return IterableExtensions.map(_partRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Port> getRedefinedPorts(Capsule capsule) {
        Iterable<Port> _portRedefinitions = XTUMLRTVirtualInheritanceExtensions.getPortRedefinitions(capsule);
        Functions.Function1<Port, Port> _function = new Functions.Function1<Port, Port>(){

            public Port apply(Port it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Port)_redefines;
            }
        };
        return IterableExtensions.map(_portRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Connector> getRedefinedConnectors(Capsule capsule) {
        Iterable<Connector> _connectorRedefinitions = XTUMLRTVirtualInheritanceExtensions.getConnectorRedefinitions(capsule);
        Functions.Function1<Connector, Connector> _function = new Functions.Function1<Connector, Connector>(){

            public Connector apply(Connector it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Connector)_redefines;
            }
        };
        return IterableExtensions.map(_connectorRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getRedefinedSignals(Protocol protocol) {
        Iterable<Signal> _signalRedefinitions = XTUMLRTVirtualInheritanceExtensions.getSignalRedefinitions(protocol);
        Functions.Function1<Signal, Signal> _function = new Functions.Function1<Signal, Signal>(){

            public Signal apply(Signal it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Signal)_redefines;
            }
        };
        return IterableExtensions.map(_signalRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<StructuredType> getSupertypes(StructuredType type) {
        EList _generalizations = type.getGeneralizations();
        List _map = null;
        if (_generalizations != null) {
            Functions.Function1<Generalization, StructuredType> _function = new Functions.Function1<Generalization, StructuredType>(){

                public StructuredType apply(Generalization it) {
                    return it.getSuper();
                }
            };
            _map = ListExtensions.map((List)_generalizations, (Functions.Function1)_function);
        }
        return _map;
    }

    private static boolean _redefines(StructuredType struct, final Attribute attr) {
        Iterable<Attribute> _redefinedAttributes = XTUMLRTVirtualInheritanceExtensions.getRedefinedAttributes(struct);
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return Objects.equal((Object)it, (Object)attr);
            }
        };
        return IterableExtensions.exists(_redefinedAttributes, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final Port port) {
        Iterable<Port> _redefinedPorts = XTUMLRTVirtualInheritanceExtensions.getRedefinedPorts(capsule);
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it, (Object)port);
            }
        };
        return IterableExtensions.exists(_redefinedPorts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final CapsulePart part) {
        Iterable<CapsulePart> _redefinedParts = XTUMLRTVirtualInheritanceExtensions.getRedefinedParts(capsule);
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return Objects.equal((Object)it, (Object)part);
            }
        };
        return IterableExtensions.exists(_redefinedParts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final Connector conn) {
        Iterable<Connector> _redefinedConnectors = XTUMLRTVirtualInheritanceExtensions.getRedefinedConnectors(capsule);
        Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                return Objects.equal((Object)it, (Object)conn);
            }
        };
        return IterableExtensions.exists(_redefinedConnectors, (Functions.Function1)_function);
    }

    private static boolean _redefines(Protocol protocol, final Signal signal) {
        Iterable<Signal> _redefinedSignals = XTUMLRTVirtualInheritanceExtensions.getRedefinedSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return Objects.equal((Object)it, (Object)signal);
            }
        };
        return IterableExtensions.exists(_redefinedSignals, (Functions.Function1)_function);
    }

    private static boolean redefines(NamedElement capsule, RedefinableElement part) {
        if (capsule instanceof Capsule && part instanceof CapsulePart) {
            return XTUMLRTVirtualInheritanceExtensions._redefines((Capsule)capsule, (CapsulePart)part);
        }
        if (capsule instanceof Capsule && part instanceof Connector) {
            return XTUMLRTVirtualInheritanceExtensions._redefines((Capsule)capsule, (Connector)part);
        }
        if (capsule instanceof Capsule && part instanceof Port) {
            return XTUMLRTVirtualInheritanceExtensions._redefines((Capsule)capsule, (Port)part);
        }
        if (capsule instanceof StructuredType && part instanceof Attribute) {
            return XTUMLRTVirtualInheritanceExtensions._redefines((StructuredType)capsule, (Attribute)part);
        }
        if (capsule instanceof Protocol && part instanceof Signal) {
            return XTUMLRTVirtualInheritanceExtensions._redefines((Protocol)capsule, (Signal)part);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(capsule, part).toString());
    }
}

