/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.architecture;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.editor.ModelSetServiceFactory;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;

public class UMLRTArchitectureContextSnippet
implements IModelSetSnippet {
    public void start(ModelSet modelsManager) {
        ArchitectureDescriptionUtils utils;
        MergedArchitectureContext context;
        ILanguageService service = (ILanguageService)ServiceUtils.getInstance().getService(ILanguageService.class, (Object)ModelSetServiceFactory.getServiceRegistry((ResourceSet)modelsManager), null);
        if (service != null && service.getLanguages(modelsManager).stream().anyMatch(l -> "org.eclipse.papyrusrt.umlrt.core.language".equals(l.getID())) && !"org.eclipse.papyrusrt.umlrt.architecture".equals((context = (utils = new ArchitectureDescriptionUtils(modelsManager)).getArchitectureContext()).getId())) {
            try {
                GMFUnsafe.write((TransactionalEditingDomain)modelsManager.getTransactionalEditingDomain(), (Command)utils.switchArchitectureContextId("org.eclipse.papyrusrt.umlrt.architecture"));
                Collection viewpoints = utils.getArchitectureContext().getDefaultViewpoints().stream().map(ctx -> ctx.getId()).collect(Collectors.toList());
                GMFUnsafe.write((TransactionalEditingDomain)modelsManager.getTransactionalEditingDomain(), (Command)utils.switchArchitectureViewpointIds(viewpoints.toArray(new String[viewpoints.size()])));
            }
            catch (InterruptedException | RollbackException e) {
                Activator.log.error(e);
            }
        }
    }

    public void dispose(ModelSet modelsManager) {
    }
}

