/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolMessageChange;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom.UMLRTDiffCustomItemProvider;
import org.eclipse.uml2.uml.Operation;

public class ProtocolMessageChangeCustomItemProvider
extends UMLRTDiffCustomItemProvider {
    public ProtocolMessageChangeCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ProtocolMessageChange protocolMessageChange = (ProtocolMessageChange)object;
        ComposeableAdapterFactory rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)rootAdapterFactory.adapt(object, IItemLabelProvider.class);
        String valueText = itemLabelProvider.getText(object);
        String referenceText = this.getReferenceText(protocolMessageChange);
        ComposedStyledString ret = new ComposedStyledString(valueText);
        ret.append(" [" + referenceText, IStyledString.Style.DECORATIONS_STYLER);
        switch (protocolMessageChange.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" change", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + protocolMessageChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    private String getReferenceText(ProtocolMessageChange change) {
        String referenceText = " protocol message";
        EObject discriminant = change.getDiscriminant();
        if (!(discriminant instanceof Operation)) {
            return referenceText;
        }
        RTMessageKind messageKind = RTMessageUtils.getMessageKind((Object)discriminant);
        if (messageKind != null) {
            return String.valueOf(messageKind.toString()) + referenceText;
        }
        return referenceText;
    }

    public Object getImage(Object object) {
        ComposeableAdapterFactory rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)rootAdapterFactory.adapt(object, IItemLabelProvider.class);
        return itemLabelProvider.getImage(object);
    }

    public String getDescription(Object object) {
        ProtocolMessageChange protocolMessageChange = (ProtocolMessageChange)object;
        IItemDescriptionProvider delegate = (IItemDescriptionProvider)this.adapt((Notifier)protocolMessageChange, IItemDescriptionProvider.class);
        return delegate.getDescription(object);
    }

    public String getSemanticObjectLabel(Object object) {
        ProtocolMessageChange protocolMessageChange = (ProtocolMessageChange)object;
        ISemanticObjectLabelProvider delegate = (ISemanticObjectLabelProvider)this.adapt((Notifier)protocolMessageChange, ISemanticObjectLabelProvider.class);
        return delegate.getSemanticObjectLabel((Object)protocolMessageChange);
    }

    private Object adapt(Notifier diff, Class<?> type) {
        return this.getRootAdapterFactory().adapt(diff, type);
    }
}

