/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils;

import java.util.function.Predicate;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.BorderMarchIterator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.ILocationIterator;

public class PortLayoutIterator
implements ILocationIterator {
    private static final int FORWARDS = 1;
    private static final int BACKWARDS = -1;
    private static final int STAGE_LEFT_DOWN = 0;
    private static final int STAGE_RIGHT_DOWN = 1;
    private static final int STAGE_LEFT_UP = 2;
    private static final int STAGE_RIGHT_UP = 3;
    private static final int STAGE_BOTTOM = 4;
    private static final int STAGE_TOP = 5;
    private static final int STAGE_WHATEVER = 6;
    private final Rectangle bounds;
    private final Rectangle interior;
    private final Predicate<? super Point> hitDetect;
    private int stage;
    private ILocationIterator delegate;
    private int direction;
    private Point preparedNext;

    private PortLayoutIterator(Rectangle bounds, Predicate<? super Point> hitDetect) {
        this.bounds = bounds.getCopy();
        this.interior = bounds.getShrinked(1, 1);
        this.hitDetect = hitDetect;
        this.advance(0, 0.0);
    }

    public static ILocationIterator on(Rectangle border, Predicate<? super Point> hitDetect) {
        return new PortLayoutIterator(border, hitDetect);
    }

    @Override
    public Point next(double distance) {
        Point result;
        do {
            Point here = this.where();
            if (this.preparedNext != null) {
                result = this.preparedNext;
                this.preparedNext = null;
            } else {
                result = this.delegate.next(distance * (double)this.direction);
            }
            if (this.interior.getPosition(result) == this.interior.getPosition(here) || !this.advance(this.stage + 1, distance)) continue;
            result = this.where();
            this.preparedNext = null;
        } while (!this.whatever() && this.hitDetect.test((Point)result));
        return result;
    }

    @Override
    public Point where() {
        return this.delegate.where();
    }

    private boolean advance(int toStage, double offset) {
        boolean result = toStage <= 6;
        switch (toStage) {
            case 0: {
                this.delegate = BorderMarchIterator.from(this.bounds.getLeft(), this.bounds);
                this.direction = 1;
                break;
            }
            case 1: {
                this.delegate = BorderMarchIterator.from(this.bounds.getRight(), this.bounds);
                this.direction = 1;
                break;
            }
            case 2: {
                this.delegate = BorderMarchIterator.from(this.bounds.getLeft(), this.bounds);
                this.direction = -1;
                this.delegate.next(offset * (double)this.direction);
                break;
            }
            case 3: {
                this.delegate = BorderMarchIterator.from(this.bounds.getRight(), this.bounds);
                this.direction = -1;
                this.delegate.next(offset * (double)this.direction);
                break;
            }
            case 4: {
                this.delegate = BorderMarchIterator.from(this.bounds.getBottomLeft(), this.bounds, false);
                this.direction = 1;
                this.delegate.next(offset * (double)this.direction);
                break;
            }
            case 5: {
                this.delegate = BorderMarchIterator.from(this.bounds.getTopLeft(), this.bounds, true);
                this.delegate.next(offset * (double)this.direction);
                break;
            }
        }
        if (toStage < 6) {
            this.stage = toStage;
            this.preparedNext = this.delegate.where();
        }
        return result;
    }

    private boolean whatever() {
        return this.stage >= 6;
    }
}

