/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Compartment;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies.NavigationEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrusrt.umlrt.common.ui.preferences.DialogPreferences;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.CreateNestedStateMachineDiagramCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.RerouteTransitionsToConnectionPointsCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.SetVisibilityCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IRTPseudostateEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies.Messages;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;

public class RTCustomStateNavigationEditPolicy
extends NavigationEditPolicy {
    private static final String CONFIRMATION_DIALOG_ID = "org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.confirmCreateNestedSMD";

    protected Command getOpenCommand(Request request) {
        Command result;
        View internalTransitionsView;
        IGraphicalEditPart compartmentEditPart;
        IFigure targetFigure;
        IGraphicalEditPart editPart;
        IFigure root;
        if (!(request instanceof SelectionRequest)) {
            return super.getOpenCommand(request);
        }
        Point location = ((SelectionRequest)request).getLocation().getCopy();
        if (this.getHost() instanceof IGraphicalEditPart && (root = FigureUtilities.getRoot((IFigure)(editPart = (IGraphicalEditPart)this.getHost()).getFigure())) != null && (targetFigure = root.findFigureAt(location)) != null && this.isInternalTransitionsDecorator(targetFigure) && (compartmentEditPart = editPart.getChildBySemanticHint("InternalTransitions")) instanceof IGraphicalEditPart && (internalTransitionsView = compartmentEditPart.getNotationView()) instanceof Compartment) {
            return new ICommandProxy((ICommand)new SetVisibilityCommand(this.getEditingDomain(), internalTransitionsView, !internalTransitionsView.isVisible()));
        }
        Diagram stateMachineDiagram = UMLRTStateMachineDiagramUtils.getStateMachineDiagram((State)this.getState());
        if (stateMachineDiagram != null) {
            result = super.getOpenCommand(request);
        } else {
            switch (this.promptToCreateNestedDiagram()) {
                case 3: {
                    result = super.getOpenCommand(request);
                    break;
                }
                case 1025: {
                    IInheritableEditPart editPart2 = (IInheritableEditPart)this.getHost();
                    View restore = editPart2.getNotationView();
                    View inherited = editPart2.getRedefinedView();
                    try {
                        editPart2.setModel((Object)inherited);
                        result = super.getOpenCommand(request);
                        break;
                    }
                    finally {
                        editPart2.setModel((Object)restore);
                    }
                }
                case 2: 
                case 1024: {
                    CreateNestedStateMachineDiagramCommand createDiagram = new CreateNestedStateMachineDiagramCommand(this.getEditingDomain(), this.getState(), this.getGraphicalHost(), true);
                    Supplier<Diagram> newDiagram = () -> RTCustomStateNavigationEditPolicy.lambda$0((ICommand)createDiagram);
                    CreateNestedStateMachineDiagramCommand composed = createDiagram;
                    ICommand rerouteTransitions = RerouteTransitionsToConnectionPointsCommand.createRerouteTransitionsCommand(this.getEditingDomain(), this.getState(), this.getGraphicalHost());
                    if (rerouteTransitions != null) {
                        composed = composed.compose((IUndoableOperation)rerouteTransitions);
                    }
                    composed = composed.compose((IUndoableOperation)this.getConnectionPointMatchingCommand(newDiagram));
                    result = GMFtoGEFCommandWrapper.wrap((ICommand)composed);
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    protected boolean isInternalTransitionsDecorator(IFigure targetFigure) {
        IFigure parentFigure = targetFigure.getParent();
        while (parentFigure != null) {
            if (parentFigure instanceof Decoration) {
                return true;
            }
            parentFigure = parentFigure.getParent();
        }
        return false;
    }

    int promptToCreateNestedDiagram() {
        boolean isRedefinitionOfCompositeState;
        Shell parentShell = this.getHost().getViewer().getControl().getShell();
        boolean isCompositeState = this.getState().isComposite();
        boolean isInheritedCompositeState = isCompositeState && UMLRTExtensionUtil.isVirtualElement((Element)this.getState());
        boolean isRedefinition = UMLRTExtensionUtil.isRedefinition((Element)this.getState());
        boolean bl = isRedefinitionOfCompositeState = isRedefinition && Optional.of(this.getState()).map(UMLRTExtensionUtil::getRedefinedElement).map(State::isComposite).orElse(false) != false;
        return isInheritedCompositeState ? DialogPreferences.custom((int)6, (Shell)parentShell, (String)Messages.RTCustomStateNavigationEditPolicy_0, (String)Messages.RTCustomStateNavigationEditPolicy_1, null, (int)0x10000000, (String)Messages.RTCustomStateNavigationEditPolicy_2, (String)Messages.RTCustomStateNavigationEditPolicy_3) : (isCompositeState ? (isRedefinition ? (isRedefinitionOfCompositeState ? DialogPreferences.custom((int)6, (Shell)parentShell, (String)Messages.RTCustomStateNavigationEditPolicy_4, (String)Messages.RTCustomStateNavigationEditPolicy_5, null, (int)0x10000000, (String)Messages.RTCustomStateNavigationEditPolicy_6, (String)Messages.RTCustomStateNavigationEditPolicy_3) : DialogPreferences.yesNoCancel((Shell)parentShell, (String)Messages.RTCustomStateNavigationEditPolicy_4, (String)Messages.RTCustomStateNavigationEditPolicy_7, (String)CONFIRMATION_DIALOG_ID)) : DialogPreferences.yesNoCancel((Shell)parentShell, (String)Messages.RTCustomStateNavigationEditPolicy_4, (String)Messages.RTCustomStateNavigationEditPolicy_12, (String)CONFIRMATION_DIALOG_ID)) : DialogPreferences.yesNoCancel((Shell)parentShell, (String)Messages.RTCustomStateNavigationEditPolicy_8, (String)Messages.RTCustomStateNavigationEditPolicy_9, (String)CONFIRMATION_DIALOG_ID));
    }

    IGraphicalEditPart getGraphicalHost() {
        return (IGraphicalEditPart)this.getHost();
    }

    TransactionalEditingDomain getEditingDomain() {
        return this.getGraphicalHost().getEditingDomain();
    }

    State getState() {
        return (State)this.getGraphicalHost().resolveSemanticElement();
    }

    private ICommand getConnectionPointMatchingCommand(final Supplier<? extends Diagram> newDiagram) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.RTCustomStateNavigationEditPolicy_10, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View frame;
                Diagram smd = (Diagram)newDiagram.get();
                View view = frame = smd == null ? null : ViewUtil.getChildBySemanticHint((View)smd, (String)"State_Shape_TN");
                if (frame instanceof Node) {
                    Rectangle frameRect = RTCustomStateNavigationEditPolicy.this.getBounds((Node)frame);
                    IGraphicalEditPart stateEP = RTCustomStateNavigationEditPolicy.this.getGraphicalHost();
                    Rectangle stateRect = RTCustomStateNavigationEditPolicy.this.getBounds(stateEP);
                    View stateView = stateEP.getNotationView();
                    for (Pseudostate connPt : RTCustomStateNavigationEditPolicy.this.getState().getConnectionPoints()) {
                        Rectangle connPtRect = RTCustomStateNavigationEditPolicy.this.getBounds(RTCustomStateNavigationEditPolicy.this.findChildNode(stateView, (EObject)connPt));
                        RelativePortLocation loc = RelativePortLocation.of((Rectangle)connPtRect, (Rectangle)stateRect);
                        String semanticHint = connPt.getKind() == PseudostateKind.ENTRY_POINT_LITERAL ? "Pseudostate_EntryPointShape" : "Pseudostate_ExitPointShape";
                        Node onFrame = ViewService.getInstance().createNode((IAdaptable)new SemanticAdapter((EObject)connPt, null), frame, semanticHint, -1, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                        Point moveTo = loc.applyTo(frameRect, IRTPseudostateEditPart.getDefaultSize(connPt.getKind()));
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__X, (Object)moveTo.x());
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__Y, (Object)moveTo.y());
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    Rectangle getBounds(IGraphicalEditPart editPart) {
        return editPart.getFigure().getBounds().getCopy();
    }

    Node findChildNode(View parent, EObject element) {
        return parent.getChildren().stream().filter(Node.class::isInstance).map(Node.class::cast).filter(n -> n.getElement() == element).findFirst().get();
    }

    Rectangle getBounds(Node node) {
        Bounds result = (Bounds)node.getLayoutConstraint();
        return new Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
    }

    protected Command getShortCutOpenCommand(Request request) {
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        EObject element = host.resolveSemanticElement();
        if (element instanceof Diagram && element.eResource() != null) {
            OpenDiagramCommand openDiagramCommand = new OpenDiagramCommand(host.getEditingDomain(), (Diagram)element);
            return new ICommandProxy((ICommand)openDiagramCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private static /* synthetic */ Diagram lambda$0(ICommand iCommand) {
        return (Diagram)iCommand.getCommandResult().getReturnValue();
    }

    protected static class OpenDiagramCommand
    extends AbstractTransactionalCommand {
        private Diagram diagramToOpen = null;

        public OpenDiagramCommand(TransactionalEditingDomain domain, Diagram diagram) {
            super(domain, Messages.RTCustomStateNavigationEditPolicy_11, null);
            this.diagramToOpen = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                IPageManager pageMngr = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)this.diagramToOpen);
                if (pageMngr.isOpen((Object)this.diagramToOpen)) {
                    pageMngr.selectPage((Object)this.diagramToOpen);
                } else {
                    pageMngr.openPage((Object)this.diagramToOpen);
                }
                return CommandResult.newOKCommandResult();
            }
            catch (Exception e) {
                throw new ExecutionException("Can't open diagram", (Throwable)e);
            }
        }
    }
}

