/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratableElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;

public class CppNamespace
extends NamedElement
implements IUserElement {
    private final List<IGeneratableElement> members = new ArrayList<IGeneratableElement>();

    public CppNamespace(String ident) {
        super(ident);
    }

    public CppNamespace(HeaderFile header, Name name) {
        super(header, name);
    }

    public void addMember(IGeneratableElement member) {
        if (member instanceof NamedElement) {
            ((NamedElement)((Object)member)).setParent(this);
        }
        this.members.add(member);
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        for (IGeneratableElement member : this.members) {
            if (member.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(CppWriter out) {
        if (!(out.decl().write("namespace") && out.decl().space() && out.decl().write(this.getName()) && out.decl().openBrace())) {
            return false;
        }
        out.decl().enter(this.getName());
        try {
            for (IGeneratableElement member : this.members) {
                if (member.write(out)) continue;
                return false;
            }
            boolean bl = out.decl().closeBrace(false) && out.decl().terminate();
            return bl;
        }
        finally {
            out.decl().exit();
        }
    }
}

