/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import com.google.common.base.Strings;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.core.utils.PostTransactionExecutor;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class NewElementUtil {
    public static void elementCreated(EObject object) {
        if (!NewElementUtil.isCreatedElement(object)) {
            object.eAdapters().add((Object)new NewElementAdapter());
        }
    }

    public static boolean isCreatedElement(EObject object) {
        return EcoreUtil.getExistingAdapter((Notifier)object, NewElementAdapter.class) != null;
    }

    public static String getUniqueName(NamedElement element, String baseName) {
        return NewElementUtil.getUniqueName(element, baseName, 2);
    }

    public static String getUniqueName(NamedElement element, String baseName, int startIndex) {
        return NewElementUtil.getUniqueName(element, baseName, startIndex, false);
    }

    public static String getUniqueName(NamedElement element, String baseName, int startIndex, boolean forceSuffix) {
        String result = null;
        if (!Strings.isNullOrEmpty((String)baseName)) {
            result = baseName;
            if (element.getNamespace() != null) {
                String nameBase = result;
                boolean done = false;
                if (forceSuffix) {
                    result = String.valueOf(nameBase) + startIndex;
                    ++startIndex;
                }
                int suffix = startIndex;
                while (!done) {
                    done = true;
                    for (NamedElement next : element.getNamespace().getMembers()) {
                        if (next == element || !next.eClass().isSuperTypeOf(element.eClass()) && !element.eClass().isSuperTypeOf(next.eClass()) || !result.equals(next.getName())) continue;
                        result = String.valueOf(nameBase) + suffix;
                        done = false;
                        break;
                    }
                    ++suffix;
                }
            }
        }
        return result;
    }

    public static String getUniqueName(Property property, Type type) {
        String result = null;
        String typeName = type.getName();
        if (!Strings.isNullOrEmpty((String)typeName)) {
            result = NewElementUtil.getUniqueName((NamedElement)property, String.valueOf(Character.toLowerCase(typeName.charAt(0))) + typeName.substring(1));
        }
        return result;
    }

    private static final class NewElementAdapter
    extends AdapterImpl {
        NewElementAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            if (newTarget instanceof EObject) {
                EObject element = (EObject)newTarget;
                PostTransactionExecutor.getInstance(element).execute(() -> {
                    boolean bl = element.eAdapters().remove((Object)this);
                });
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == NewElementAdapter.class;
        }
    }
}

