/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.utils.PackageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class ProtocolContainerUtils {
    public static boolean containsProtocolContainer(Package container) {
        Collection packages = EcoreUtil.getObjectsByType((Collection)container.getPackagedElements(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        if (packages != null && !packages.isEmpty()) {
            IElementType type = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer");
            if (!(type instanceof ISpecializationType)) {
                return false;
            }
            for (Package pkg : packages) {
                if (!((ISpecializationType)type).getMatcher().matches((EObject)pkg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProtocolContainer(EObject package_) {
        IElementType type = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer");
        if (!(type instanceof ISpecializationType)) {
            return false;
        }
        return ((ISpecializationType)type).getMatcher().matches(package_);
    }

    public static List<PackageableElement> getFilteredPackagedElements(Element source) {
        if (!(source instanceof Package)) {
            return Collections.emptyList();
        }
        if (!ProtocolContainerUtils.containsProtocolContainer((Package)source)) {
            return ((Package)source).getPackagedElements();
        }
        ArrayList<PackageableElement> result = new ArrayList<PackageableElement>((Collection<PackageableElement>)((Package)source).getPackagedElements());
        ListIterator<Collaboration> iter = result.listIterator();
        while (iter.hasNext()) {
            PackageableElement next = (PackageableElement)iter.next();
            if (!(next instanceof Package) || !ProtocolContainerUtils.isProtocolContainer((EObject)next)) continue;
            Collaboration protocol = ProtocolContainerUtils.getProtocol((Package)next);
            if (protocol == null) {
                iter.remove();
                continue;
            }
            iter.set(protocol);
        }
        return result;
    }

    public static ICommand createMoveProtocolContainerCommand(MoveRequest request, EObject protocolContainerToMove) {
        UnexecutableCommand result;
        Package targetContainer = PackageUtils.getNearestPackage(request.getTargetContainer());
        MoveRequest moveRequest = new MoveRequest((EObject)targetContainer, protocolContainerToMove);
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)targetContainer);
        if (edit == null) {
            result = UnexecutableCommand.INSTANCE;
        } else {
            result = edit.getEditCommand((IEditCommandRequest)moveRequest);
            if (result == null) {
                result = UnexecutableCommand.INSTANCE;
            }
        }
        return result;
    }

    public static Collaboration getProtocol(Package protocolContainer) {
        if (protocolContainer == null) {
            return null;
        }
        for (PackageableElement packageableElement : protocolContainer.getPackagedElements()) {
            if (!ProtocolUtils.isProtocol((EObject)packageableElement).booleanValue()) continue;
            return (Collaboration)packageableElement;
        }
        return null;
    }
}

