/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.requests.UnsetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.Activator;

public class UMLRTCommandUtils {
    private UMLRTCommandUtils() {
    }

    public static ICommand flatCompose(ICommand c1, ICommand c2) {
        ICommand result;
        if (c2 instanceof UnexecutableCommand) {
            result = c2;
        } else if (c1 instanceof UnexecutableCommand) {
            result = c1;
        } else if (c2 instanceof ICompositeCommand) {
            ICompositeCommand cc2 = (ICompositeCommand)c2;
            Iterator commands = cc2.iterator();
            result = StreamSupport.stream(Spliterators.spliteratorUnknownSize(commands, 272), false).reduce(c1, UMLRTCommandUtils::flatCompose);
        } else {
            result = c1 != null ? (c2 == null || c2 instanceof IdentityCommand ? c1 : (c1 instanceof IdentityCommand ? c2 : c1.compose((IUndoableOperation)c2))) : c2;
        }
        return result;
    }

    public static boolean isUndoRedoInProgress(Notifier notifier) {
        boolean result = false;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)notifier);
        if (domain instanceof InternalTransactionalEditingDomain) {
            InternalTransaction active = ((InternalTransactionalEditingDomain)domain).getActiveTransaction();
            result = active != null && (Boolean.TRUE.equals(active.getOptions().get("is_undo_redo_transaction")) || active.isRollingBack());
        }
        return result;
    }

    public static ICommand set(IEditCommandRequest request, EObject owner, EStructuralFeature feature, Object value) {
        SetRequest set = new SetRequest(request.getEditingDomain(), owner, feature, value);
        set.setClientContext(request.getClientContext());
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (edit == null) {
            Activator.log.error("No edit provider for element: " + owner, null);
            return UnexecutableCommand.INSTANCE;
        }
        return edit.getEditCommand((IEditCommandRequest)set);
    }

    public static ICommand unset(IEditCommandRequest request, EObject owner, EStructuralFeature feature) {
        UnsetRequest unset = new UnsetRequest(request.getEditingDomain(), owner, feature);
        unset.setClientContext(request.getClientContext());
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (edit == null) {
            Activator.log.error("No edit provider for element: " + owner, null);
            return UnexecutableCommand.INSTANCE;
        }
        return edit.getEditCommand((IEditCommandRequest)unset);
    }

    public static ICommand destroy(IEditCommandRequest request, EObject object) {
        DestroyElementRequest destroy = new DestroyElementRequest(request.getEditingDomain(), object, false);
        destroy.setClientContext(request.getClientContext());
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)destroy.getContainer());
        if (edit == null) {
            Activator.log.error("No edit provider for owner of element: " + object, null);
            return UnexecutableCommand.INSTANCE;
        }
        return edit.getEditCommand((IEditCommandRequest)destroy);
    }
}

