/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.uml2.uml.Element;

public class ExclusionHandler
extends AbstractHandler
implements IElementUpdater,
IExecutableExtension {
    private final boolean doUpdate;
    private boolean isExclude = true;

    public ExclusionHandler() {
        this(false);
    }

    public ExclusionHandler(boolean doUpdate) {
        this.doUpdate = doUpdate;
    }

    public boolean isExclude() {
        return this.isExclude;
    }

    public void setExclude(boolean exclude) {
        this.isExclude = exclude;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String isExclude;
        if (data instanceof String) {
            this.setExclude(Boolean.valueOf(((String)data).trim()));
        } else if (data instanceof Map && (isExclude = (String)((Map)data).get("isExclude")) != null) {
            this.setExclude(Boolean.valueOf(isExclude.trim()));
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain domain;
        Object result = null;
        List<Element> elements = this.getSelection(event.getApplicationContext());
        if (!elements.isEmpty() && (domain = TransactionUtil.getEditingDomain((EObject)((EObject)elements.get(0)))) != null) {
            Command command = GMFtoEMFCommandWrapper.wrap((ICommand)ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, elements, (boolean)this.isExclude()));
            domain.getCommandStack().execute(command);
            result = command.getResult().isEmpty() ? null : command.getResult().iterator().next();
        }
        return result;
    }

    protected List<Element> getSelection(Object evaluationContext) {
        IStructuredSelection sel = (IStructuredSelection)TypeUtils.as((Object)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection"), (Object)StructuredSelection.EMPTY);
        List<Element> result = sel.toList().stream().map(e -> (EObject)PlatformHelper.getAdapter((Object)e, EObject.class)).filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
        return result;
    }

    public void setEnabled(Object evaluationContext) {
        List<Element> elements = this.getSelection(evaluationContext);
        Predicate<Element> condition = this.isExclude() ? UMLRTProfileUtils::canExclude : UMLRTProfileUtils::canReinherit;
        this.setBaseEnabled(elements.stream().allMatch(condition));
    }

    public void updateElement(UIElement element, Map parameters) {
        if (this.doUpdate) {
            element.setText("Exclude Element");
            element.setTooltip("Undefine the inherited element in the inheriting namespace");
        }
    }
}

