/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.providers;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.RTStereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.UMLRTExtModelElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TogglePortState
extends State
implements IExecutableExtension {
    public static final String STATE = "state";
    private static final String COMMAND_ID = "commandID";
    public static final String UML_REAL_TIME_RT_PORT = "UMLRealTime::RTPort";
    public static final String PROPERTY_PATH = "propertyPath";
    public static final String IS_STEREOTYPE = "isStereotype";
    protected EObject selectedEObject;
    Hashtable<String, String> parameterHash;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable) {
            Command command;
            this.parameterHash = (Hashtable)data;
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            String commandId = this.parameterHash.get(COMMAND_ID);
            if (commandId != null && (command = commandService.getCommand(commandId)) != null) {
                IHandler handler = command.getHandler();
                try {
                    HashMap<String, TogglePortState> map = new HashMap<String, TogglePortState>();
                    map.put(STATE, this);
                    handler.execute(new ExecutionEvent(command, map, null, null));
                }
                catch (ExecutionException executionException) {}
            }
        }
    }

    public void updateSelectedEObject() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection != null && selection.size() == 1) {
            this.selectedEObject = EMFHelper.getEObject((Object)selection.getFirstElement());
        }
    }

    public Object getValue() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Port) {
            Port port = (Port)this.selectedEObject;
            ModelElement modelElement = this.getModelElement(port);
            IObservableValue value = (IObservableValue)modelElement.getObservable(this.getPropertyPath());
            Object result = value.getValue();
            modelElement.dispose();
            return result;
        }
        return false;
    }

    public ModelElement getModelElement(Port port) {
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)port);
        RTPort rtPort = (RTPort)UMLUtil.getStereotypeApplication((Element)port, RTPort.class);
        if (this.isStereotypeProperty()) {
            Stereotype rtPortStereotype = port.getApplicableStereotype(UML_REAL_TIME_RT_PORT);
            return new RTStereotypeModelElement((EObject)rtPort, rtPortStereotype, domain);
        }
        return new UMLRTExtModelElement((EObject)port, domain);
    }

    public String getPropertyPath() {
        return this.parameterHash.get(PROPERTY_PATH);
    }

    public boolean isStereotypeProperty() {
        return Boolean.valueOf(this.parameterHash.get(IS_STEREOTYPE));
    }
}

