/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.Collections;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MultiplicityElementAdapter;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertyReplicationObservableValue
extends PapyrusObservableValue
implements IObserving {
    public static final String STAR = "*";
    private Property propertyElement;
    private PartAdapter partAdapter;
    private Object value;

    public PropertyReplicationObservableValue(EObject property, TransactionalEditingDomain domain) {
        super(property, property.eContainingFeature(), (EditingDomain)domain);
        if (property instanceof Property) {
            this.propertyElement = (Property)property;
            ((PartAdapter)this.getPartAdapter()).adapt((Notifier)this.propertyElement);
        }
    }

    public synchronized void dispose() {
        try {
            if (this.partAdapter != null) {
                if (this.partAdapter.getTarget() != null) {
                    this.partAdapter.unadapt((Notifier)this.partAdapter.getTarget());
                }
                this.partAdapter = null;
            }
            this.value = null;
        }
        finally {
            super.dispose();
        }
    }

    protected Object doGetValue() {
        this.value = Integer.toString(this.propertyElement.getUpper());
        if (this.propertyElement.getUpperValue() != null && this.propertyElement.getLowerValue() != null) {
            this.value = this.propertyElement.getUpperValue().stringValue();
        } else if (this.propertyElement.getLowerValue() == null && this.propertyElement.getUpperValue() == null) {
            this.value = "None (1)";
        }
        return this.value;
    }

    public Command getCommand(Object value) {
        org.eclipse.emf.common.command.UnexecutableCommand result;
        if (!(value instanceof String)) {
            result = org.eclipse.emf.common.command.UnexecutableCommand.INSTANCE;
        } else if (((String)value).matches("[0-9]*|\\*")) {
            int upperValue = value.equals(STAR) ? -1 : Integer.decode((String)value);
            int lowerValue = CapsulePartUtils.isCapsulePart((Property)this.propertyElement) && this.propertyElement.getLower() == 0 ? 0 : (upperValue == -1 ? 0 : upperValue);
            result = this.getSetMultiplicityCommand((MultiplicityElement)this.propertyElement, lowerValue, upperValue);
        } else if (((String)value).equals("None (1)")) {
            result = this.getUnsetMultiplicityCommand((MultiplicityElement)this.propertyElement);
        } else {
            String upperValue = (String)value;
            Object lowerValue = null;
            if (CapsulePartUtils.isCapsulePart((Property)this.propertyElement)) {
                lowerValue = this.propertyElement.getLower() != 0 ? value : Integer.valueOf(0);
            } else if (RTPortUtils.isRTPort((EObject)this.propertyElement)) {
                lowerValue = value;
            }
            result = this.getSetMultiplicityCommand((MultiplicityElement)this.propertyElement, lowerValue, upperValue);
        }
        return result;
    }

    private String getDefaultLanguage() {
        String defaultLanguage = null;
        try {
            if (this.propertyElement != null) {
                IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)this.propertyElement);
                service.startService();
                IDefaultLanguage language = service.getActiveDefaultLanguage((Element)this.propertyElement);
                defaultLanguage = language.getName();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return defaultLanguage;
    }

    protected Command getSetMultiplicityCommand(MultiplicityElement element, Object lower, Object upper) {
        ICommand result = null;
        try {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)element);
            if (provider != null) {
                TransactionalEditingDomain ted = (TransactionalEditingDomain)this.domain;
                CompositeTransactionalCommand cc = new CompositeTransactionalCommand(ted, "Set Replication");
                ValueSpecification lowerValue = element.getLowerValue();
                if (lower instanceof Integer && lowerValue instanceof LiteralInteger) {
                    IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)lowerValue);
                    if (edit == null) {
                        cc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
                    } else {
                        cc.add((IUndoableOperation)edit.getEditCommand(this.createSetRequest(ted, (EObject)lowerValue, (EStructuralFeature)UMLPackage.Literals.LITERAL_INTEGER__VALUE, lower)));
                    }
                } else if (lower instanceof String && lowerValue instanceof OpaqueExpression) {
                    this.appendSetCommands((ICompositeCommand)cc, (OpaqueExpression)lowerValue, (String)lower, this.getDefaultLanguage());
                } else {
                    if (lowerValue != null) {
                        cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)new DestroyElementRequest(ted, (EObject)lowerValue, false)));
                    }
                    if (lower instanceof Integer) {
                        this.appendCreateLiteralIntegerCommand((ICompositeCommand)cc, element, UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE, lower);
                    } else if (lower instanceof String) {
                        this.appendCreateExpressionCommand((ICompositeCommand)cc, element, (String)lower, this.getDefaultLanguage(), UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE);
                    }
                }
                ValueSpecification upperValue = element.getUpperValue();
                if (upper instanceof Integer && upperValue instanceof LiteralUnlimitedNatural) {
                    IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)upperValue);
                    if (edit == null) {
                        cc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
                    } else {
                        cc.add((IUndoableOperation)edit.getEditCommand(this.createSetRequest(ted, (EObject)upperValue, (EStructuralFeature)UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE, upper)));
                    }
                } else if (upper instanceof String && upperValue instanceof OpaqueExpression) {
                    this.appendSetCommands((ICompositeCommand)cc, (OpaqueExpression)upperValue, (String)upper, this.getDefaultLanguage());
                } else {
                    if (upperValue != null) {
                        cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)new DestroyElementRequest(ted, (EObject)upperValue, false)));
                    }
                    if (upper instanceof Integer) {
                        this.appendCreateLiteralUnlimitedNaturalCommand((ICompositeCommand)cc, element, UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE, upper);
                    } else if (upper instanceof String) {
                        this.appendCreateExpressionCommand((ICompositeCommand)cc, element, (String)upper, this.getDefaultLanguage(), UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE);
                    }
                }
                result = cc.canExecute() ? cc.reduce() : null;
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
        return result == null ? org.eclipse.emf.common.command.UnexecutableCommand.INSTANCE : GMFtoEMFCommandWrapper.wrap(result);
    }

    private ICommand create(TransactionalEditingDomain domain, final MultiplicityElement element, final EReference containment, final EClass typeToCreate, final EStructuralFeature feature, final Object initialValue, final Object ... more) {
        return new AbstractTransactionalCommand(domain, "Create Multiplicity Bound", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ValueSpecification result;
                ValueSpecification valueSpecification = result = containment == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE ? element.createLowerValue(null, null, typeToCreate) : element.createUpperValue(null, null, typeToCreate);
                if (feature != null) {
                    result.eSet(feature, initialValue);
                    if (more.length > 0) {
                        int i = 0;
                        while (i < more.length) {
                            result.eSet((EStructuralFeature)more[i], more[i + 1]);
                            i += 2;
                        }
                    }
                }
                return CommandResult.newOKCommandResult((Object)result);
            }
        };
    }

    private void appendCreateLiteralIntegerCommand(ICompositeCommand cc, MultiplicityElement element, EReference containment, Object value) {
        cc.add((IUndoableOperation)this.create((TransactionalEditingDomain)this.domain, element, containment, UMLPackage.Literals.LITERAL_INTEGER, (EStructuralFeature)UMLPackage.Literals.LITERAL_INTEGER__VALUE, value, new Object[0]));
    }

    private void appendCreateLiteralUnlimitedNaturalCommand(ICompositeCommand cc, MultiplicityElement element, EReference containment, Object value) {
        cc.add((IUndoableOperation)this.create((TransactionalEditingDomain)this.domain, element, containment, UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL, (EStructuralFeature)UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE, value, new Object[0]));
    }

    private void appendSetCommands(ICompositeCommand cc, OpaqueExpression expr, String body, String language) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)expr);
        TransactionalEditingDomain ted = (TransactionalEditingDomain)this.domain;
        if (expr.getBodies().isEmpty() || !body.equals(expr.getBodies().get(0))) {
            cc.add((IUndoableOperation)provider.getEditCommand(this.createSetRequest(ted, (EObject)expr, (EStructuralFeature)UMLPackage.Literals.OPAQUE_EXPRESSION__BODY, Collections.singletonList(body))));
        }
        if (expr.getLanguages().isEmpty() || !Objects.equals(expr.getLanguages().get(0), language)) {
            cc.add((IUndoableOperation)provider.getEditCommand(this.createSetRequest(ted, (EObject)expr, (EStructuralFeature)UMLPackage.Literals.OPAQUE_EXPRESSION__LANGUAGE, Collections.singletonList(language))));
        }
    }

    private void appendCreateExpressionCommand(ICompositeCommand cc, MultiplicityElement element, String body, String language, EReference bound) {
        cc.add((IUndoableOperation)this.create((TransactionalEditingDomain)this.domain, element, bound, UMLPackage.Literals.OPAQUE_EXPRESSION, (EStructuralFeature)UMLPackage.Literals.OPAQUE_EXPRESSION__BODY, Collections.singletonList(body), UMLPackage.Literals.OPAQUE_EXPRESSION__LANGUAGE, Collections.singletonList(language)));
    }

    protected Command getUnsetMultiplicityCommand(MultiplicityElement element) {
        ICommand result = null;
        try {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)element);
            if (provider != null) {
                ValueSpecification upperValue;
                TransactionalEditingDomain ted = (TransactionalEditingDomain)this.domain;
                CompositeTransactionalCommand cc = new CompositeTransactionalCommand(ted, "Set Replication");
                ValueSpecification lowerValue = element.getLowerValue();
                if (lowerValue != null) {
                    cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)new DestroyElementRequest(ted, (EObject)lowerValue, false)));
                }
                if ((upperValue = element.getUpperValue()) != null) {
                    cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)new DestroyElementRequest(ted, (EObject)upperValue, false)));
                }
                result = cc.canExecute() ? cc.reduce() : null;
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
        return result == null ? org.eclipse.emf.common.command.UnexecutableCommand.INSTANCE : GMFtoEMFCommandWrapper.wrap(result);
    }

    protected IEditCommandRequest createSetRequest(TransactionalEditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        return new SetRequest(domain, owner, feature, value);
    }

    public Object getObserved() {
        return this.propertyElement;
    }

    public Object getValueType() {
        return String.class;
    }

    protected Adapter getMultiplicityListener() {
        return this.getPartAdapter();
    }

    private Adapter getPartAdapter() {
        if (this.partAdapter == null) {
            this.partAdapter = new PartAdapter();
        }
        return this.partAdapter;
    }

    private class PartAdapter
    extends MultiplicityElementAdapter {
        PartAdapter() {
        }

        protected void handleMultiplicityChanged(Notification notification) {
            Object oldValue = PropertyReplicationObservableValue.this.value;
            Object newValue = PropertyReplicationObservableValue.this.doGetValue();
            final ValueDiff diff = Diffs.createValueDiff((Object)oldValue, (Object)newValue);
            PropertyReplicationObservableValue.this.getRealm().exec(new Runnable(){

                @Override
                public void run() {
                    PropertyReplicationObservableValue.this.fireValueChange(diff);
                }
            });
        }
    }
}

