/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UMLRTPortKind implements Enumerator
{
    EXTERNAL_BEHAVIOR(0, "externalBehavior", "externalBehavior"),
    INTERNAL_BEHAVIOR(1, "internalBehavior", "internalBehavior"),
    RELAY(2, "relay", "relay"),
    SAP(3, "SAP", "SAP"),
    SPP(4, "SPP", "SPP"),
    NULL(5, "null", "null");

    public static final int EXTERNAL_BEHAVIOR_VALUE = 0;
    public static final int INTERNAL_BEHAVIOR_VALUE = 1;
    public static final int RELAY_VALUE = 2;
    public static final int SAP_VALUE = 3;
    public static final int SPP_VALUE = 4;
    public static final int NULL_VALUE = 5;
    private static final UMLRTPortKind[] VALUES_ARRAY;
    public static final List<UMLRTPortKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UMLRTPortKind[]{EXTERNAL_BEHAVIOR, INTERNAL_BEHAVIOR, RELAY, SAP, SPP, NULL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UMLRTPortKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UMLRTPortKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UMLRTPortKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UMLRTPortKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UMLRTPortKind get(int value) {
        switch (value) {
            case 0: {
                return EXTERNAL_BEHAVIOR;
            }
            case 1: {
                return INTERNAL_BEHAVIOR;
            }
            case 2: {
                return RELAY;
            }
            case 3: {
                return SAP;
            }
            case 4: {
                return SPP;
            }
            case 5: {
                return NULL;
            }
        }
        return null;
    }

    private UMLRTPortKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isExternal() {
        return this == EXTERNAL_BEHAVIOR || this == RELAY || this == SPP;
    }

    public boolean isInternal() {
        return this == INTERNAL_BEHAVIOR || this == SAP;
    }

    public boolean isService() {
        return this == EXTERNAL_BEHAVIOR || this == RELAY || this == SPP;
    }

    public boolean isWired() {
        return this == EXTERNAL_BEHAVIOR || this == INTERNAL_BEHAVIOR || this == RELAY;
    }

    public boolean isUnwired() {
        return this == SPP || this == SAP;
    }

    public boolean isBehavior() {
        return this == EXTERNAL_BEHAVIOR || this == INTERNAL_BEHAVIOR || this == SPP || this == SAP;
    }

    public boolean isPublish() {
        return this == SPP;
    }

    public UMLRTPortKind setService(boolean service) {
        if (service == this.isService()) {
            return this;
        }
        switch (this) {
            case EXTERNAL_BEHAVIOR: {
                return INTERNAL_BEHAVIOR;
            }
            case INTERNAL_BEHAVIOR: {
                return EXTERNAL_BEHAVIOR;
            }
            case SPP: {
                return SAP;
            }
            case SAP: {
                return SPP;
            }
        }
        return NULL;
    }

    public UMLRTPortKind setBehavior(boolean behavior) {
        if (behavior == this.isBehavior()) {
            return this;
        }
        switch (this) {
            case EXTERNAL_BEHAVIOR: {
                return RELAY;
            }
            case RELAY: {
                return EXTERNAL_BEHAVIOR;
            }
        }
        return NULL;
    }

    public UMLRTPortKind setWired(boolean wired) {
        if (wired == this.isWired()) {
            return this;
        }
        switch (this) {
            case EXTERNAL_BEHAVIOR: {
                return SPP;
            }
            case SPP: {
                return EXTERNAL_BEHAVIOR;
            }
            case INTERNAL_BEHAVIOR: {
                return SAP;
            }
            case SAP: {
                return INTERNAL_BEHAVIOR;
            }
        }
        return NULL;
    }

    public UMLRTPortKind setPublish(boolean publish) {
        if (publish == this.isPublish()) {
            return this;
        }
        switch (this) {
            case SPP: {
                return SAP;
            }
            case SAP: {
                return SPP;
            }
        }
        return NULL;
    }

    public static UMLRTPortKind get(boolean service, boolean behavior, boolean wired, boolean publish) {
        UMLRTPortKind result = NULL;
        if (service && wired && behavior && !publish) {
            result = EXTERNAL_BEHAVIOR;
        } else if (behavior && publish && !wired) {
            result = SPP;
        } else if (wired && behavior && !service && !publish) {
            result = INTERNAL_BEHAVIOR;
        } else if (service && wired && !behavior && !publish) {
            result = RELAY;
        } else if (behavior && !wired && !publish) {
            result = SAP;
        }
        return result;
    }

    public String toString() {
        return this.literal;
    }
}

