/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTGuard;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.InternalFacadeEMap;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTGuardImpl
extends UMLRTNamedElementImpl
implements UMLRTGuard {
    static final FacadeType<Constraint, EObject, UMLRTGuardImpl> TYPE = new FacadeType(UMLRTGuardImpl.class, UMLPackage.Literals.CONSTRAINT, null, UMLRTGuardImpl::getInstance, guard -> (UMLRTGuardImpl)guard.getRedefinedElement(), UMLRTGuardImpl::maybeCreate);
    protected InternalFacadeEMap<String, String> bodies;

    protected UMLRTGuardImpl() {
    }

    private static UMLRTGuardImpl maybeCreate(Constraint constraint) {
        Transition transition;
        UMLRTGuardImpl result = null;
        Namespace context = constraint.getContext();
        if (context instanceof Transition && ((transition = (Transition)context).getGuard() == constraint || UMLUtil.getStereotypeApplication((Element)constraint, RTGuard.class) != null)) {
            result = new UMLRTGuardImpl();
        }
        return result;
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.GUARD;
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTTransition transition = this.getTransition();
        if (transition != null) {
            return transition;
        }
        UMLRTTrigger trigger = this.getTrigger();
        if (trigger != null) {
            return trigger;
        }
        return super.getRedefinitionContext();
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        UMLRTGuard redefinedGuard = this.getRedefinedGuard();
        if (redefinedGuard != null) {
            return redefinedGuard;
        }
        return super.getRedefinedElement();
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTGuardImpl> createFacadeAdapter() {
        return new GuardAdapter<UMLRTGuardImpl>(this);
    }

    public static UMLRTGuardImpl getInstance(Constraint guard) {
        Namespace context;
        UMLRTGuardImpl result = null;
        Namespace namespace = context = guard == null ? null : guard.getContext();
        if (context instanceof Transition) {
            Trigger trigger;
            EList constrained;
            Transition transition = (Transition)context;
            if (guard == transition.getGuard()) {
                result = UMLRTGuardImpl.getFacade(guard, TYPE);
            } else if (UMLUtil.getStereotypeApplication((Element)guard, RTGuard.class) != null && !(constrained = guard.getConstrainedElements()).isEmpty() && (trigger = (Trigger)EcoreUtil.getObjectByType((Collection)constrained, (EClassifier)UMLPackage.Literals.TRIGGER)) != null) {
                UMLRTTrigger triggerFacade = UMLRTTrigger.getInstance(trigger);
                UMLRTTransition transitionFacade = UMLRTTransition.getInstance(transition);
                if (triggerFacade != null && transitionFacade != null && transitionFacade.getRedefinitionOf(triggerFacade) != null) {
                    result = UMLRTGuardImpl.getFacade(guard, TYPE);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getBodies() {
        this.getBodyEntries();
        return this.bodies.map();
    }

    public List<Map.Entry<String, String>> getBodyEntries() {
        if (this.bodies == null) {
            this.bodies = new UMLRTNamedElementImpl.Code(this, 15){
                private static final long serialVersionUID = 1L;

                @Override
                protected EObject getCodeOwner() {
                    Constraint constraint = (Constraint)super.getCodeOwner();
                    ValueSpecification spec = constraint.getSpecification();
                    return spec instanceof OpaqueExpression ? spec : null;
                }
            };
        }
        return this.bodies;
    }

    @Override
    public UMLRTTransition getTransition() {
        Transition transition;
        UMLRTTransition result = null;
        Namespace context = this.toUML().getContext();
        if (context instanceof Transition && (transition = (Transition)context).getGuard() == this.toUML()) {
            result = UMLRTTransition.getInstance(transition);
        }
        return result;
    }

    @Override
    public void setTransition(UMLRTTransition newTransition) {
        if (newTransition != this.getTransition()) {
            Constraint uml = this.toUML();
            UMLRTTrigger trigger = this.getTrigger();
            if (trigger != null) {
                uml.getConstrainedElements().remove((Object)trigger.toUML());
                RTGuard stereo = (RTGuard)UMLUtil.getStereotypeApplication((Element)uml, RTGuard.class);
                if (stereo != null) {
                    uml.unapplyStereotype(UMLUtil.getStereotype((EObject)stereo));
                }
            }
            if (newTransition == null) {
                uml.setContext(null);
            } else {
                newTransition.toUML().setGuard(uml);
            }
        }
    }

    @Override
    public UMLRTGuard getRedefinedGuard() {
        UMLRTGuard result = null;
        if (this.toUML() instanceof InternalUMLRTElement) {
            Constraint superGuard = (Constraint)((InternalUMLRTElement)this.toUML()).rtGetRedefinedElement();
            result = UMLRTGuard.getInstance(superGuard);
        }
        return result;
    }

    @Override
    public UMLRTTrigger getTrigger() {
        UMLRTTrigger result = null;
        Constraint uml = this.toUML();
        RTGuard stereo = (RTGuard)UMLUtil.getStereotypeApplication((Element)uml, RTGuard.class);
        if (stereo != null) {
            result = this.toUML().getConstrainedElements().stream().filter(Trigger.class::isInstance).map(Trigger.class::cast).findFirst().map(UMLRTTrigger::getInstance).orElse(null);
        }
        return result;
    }

    @Override
    public void setTrigger(UMLRTTrigger newTrigger) {
        if (newTrigger != this.getTrigger()) {
            UMLRTTrigger oldTrigger;
            UMLRTTransition newContext;
            Constraint uml = this.toUML();
            UMLRTTransition oldContext = this.getTransition();
            UMLRTTransition uMLRTTransition = newContext = newTrigger == null ? null : newTrigger.getTransition();
            if (newContext != oldContext) {
                if (newContext != null) {
                    uml.setContext((Namespace)newContext.toUML());
                } else {
                    UMLRTExtensionUtil.remove((EObject)oldContext.toUML(), (EStructuralFeature)UMLPackage.Literals.NAMESPACE__OWNED_RULE, uml);
                }
            }
            if ((oldTrigger = this.getTrigger()) != null) {
                uml.getConstrainedElements().remove((Object)oldTrigger.toUML());
            }
            if (newTrigger != null) {
                RTGuard stereo = (RTGuard)UMLUtil.getStereotypeApplication((Element)uml, RTGuard.class);
                if (stereo == null) {
                    UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)uml).applyStereotype((Element)uml, UMLRTStateMachinesPackage.Literals.RT_GUARD);
                }
                uml.getConstrainedElements().add(0, (Object)newTrigger.toUML());
            }
        }
    }

    @Override
    public Constraint toUML() {
        return (Constraint)super.toUML();
    }

    @Override
    public Stream<? extends UMLRTGuard> allRedefinitions() {
        Predicate<UMLRTNamedElement> excluded = UMLRTNamedElement::isExcluded;
        UMLRTNamedElement context = this.getRedefinitionContext();
        return context == null ? Stream.of(this) : context.allRedefinitions().map(c -> c.getRedefinitionOf(this)).filter(Objects::nonNull).filter(excluded.negate());
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getBodies();
            }
            case 15: {
                return this.getBodyEntries();
            }
            case 16: {
                return this.getTransition();
            }
            case 17: {
                return this.getRedefinedGuard();
            }
            case 18: {
                return this.getTrigger();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 15: {
                this.getBodyEntries().clear();
                this.getBodyEntries().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setTransition((UMLRTTransition)newValue);
                return;
            }
            case 18: {
                this.setTrigger((UMLRTTrigger)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 15: {
                this.getBodyEntries().clear();
                return;
            }
            case 16: {
                this.setTransition(null);
                return;
            }
            case 18: {
                this.setTrigger(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 14: {
                return this.getBodies() != null;
            }
            case 15: {
                return !this.getBodyEntries().isEmpty();
            }
            case 16: {
                return this.getTransition() != null;
            }
            case 17: {
                return this.getRedefinedGuard() != null;
            }
            case 18: {
                return this.getTrigger() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(16) || this.eIsSet(18);
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.eIsSet(17);
    }

    protected static class GuardAdapter<F extends UMLRTGuardImpl>
    extends UMLRTNamedElementImpl.NamedElementAdapter.WithCode<F> {
        GuardAdapter(F facade) {
            super(facade);
        }

        @Override
        protected InternalFacadeEMap<String, String> getCode() {
            return ((UMLRTGuardImpl)this.get()).bodies;
        }

        @Override
        public void setTarget(Notifier newTarget) {
            Constraint constraint;
            ValueSpecification specification;
            super.setTarget(newTarget);
            if (newTarget instanceof Constraint && (specification = (constraint = (Constraint)newTarget).getSpecification()) instanceof OpaqueExpression) {
                this.adaptAdditional((Notifier)specification);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof Constraint) {
                this.unadaptAdditional();
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, EObject oldObject, EObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.CONSTRAINT__SPECIFICATION) {
                if (oldObject instanceof OpaqueExpression) {
                    this.unadaptAdditional((Notifier)oldObject);
                }
                if (newObject instanceof OpaqueExpression) {
                    this.adaptAdditional((Notifier)newObject);
                }
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }
    }
}

