/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsulePartEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        return super.getBeforeCreateRelationshipCommand(request);
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature feature = setRequest.getFeature();
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
                Object newValue = ((SetRequest)request).getValue();
                if (newValue instanceof Classifier) {
                    return CapsuleUtils.isCapsule((Classifier)newValue);
                }
                return false;
            }
            return super.approveRequest((IEditCommandRequest)setRequest);
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final Property capsulePart = (Property)request.getElementToConfigure();
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                capsulePart.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                capsulePart.setLower(1);
                capsulePart.setUpper(1);
                capsulePart.setName(null);
                return CommandResult.newOKCommandResult((Object)capsulePart);
            }
        };
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        EStructuralFeature feature = request.getFeature();
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
            String name;
            Object newValue = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            if (newValue instanceof Type && elementToEdit instanceof Property && ((Property)elementToEdit).getName() == null && (name = ((Type)newValue).getName()) != null && !name.isEmpty()) {
                String newName = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
                return new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName));
            }
        }
        return super.getAfterSetCommand(request);
    }
}

