/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class RTPortEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature feature = setRequest.getFeature();
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
                Object newValue = ((SetRequest)request).getValue();
                if (newValue instanceof EObject) {
                    return ProtocolUtils.isProtocol((EObject)newValue) != false;
                }
                return false;
            }
            return super.approveRequest((IEditCommandRequest)setRequest);
        }
        if (request instanceof CreateRelationshipRequest) {
            IElementType type = ((CreateRelationshipRequest)request).getElementType();
            if (type != null && ElementTypeUtils.isTypeCompatible(type, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTConnector"))) {
                return this.checkSourceAndTarget((CreateRelationshipRequest)request);
            }
            return super.approveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected boolean checkSourceAndTarget(CreateRelationshipRequest createRelationshipRequest) {
        EObject source = createRelationshipRequest.getSource();
        EObject target = createRelationshipRequest.getTarget();
        if (source != null) {
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        if (target != null) {
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        EStructuralFeature feature = request.getFeature();
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
            String name;
            Object newValue = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            if (newValue instanceof Type && elementToEdit instanceof Port && ((Port)elementToEdit).getName() == null && (name = ((Type)newValue).getName()) != null && !name.isEmpty()) {
                String newName = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
                return new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName));
            }
        }
        return super.getAfterSetCommand(request);
    }
}

