/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProtocolContainerUtils {
    public static List<Operation> getRTMessages(Package protocolContainer, RTMessageKind direction, boolean showInherited) {
        Interface messageSet = ProtocolContainerUtils.getMessageSet(protocolContainer, direction);
        if (messageSet != null) {
            if (showInherited) {
                return messageSet.getAllOperations();
            }
            return messageSet.getOwnedOperations();
        }
        return Collections.emptyList();
    }

    public static List<Operation> getAllRTMessages(Package protocolContainer, RTMessageKind direction) {
        return ProtocolContainerUtils.getRTMessages(protocolContainer, direction, true);
    }

    public static List<Operation> getAllInRTMessages(Package protocolContainer) {
        return ProtocolContainerUtils.getAllRTMessages(protocolContainer, RTMessageKind.IN);
    }

    public static Collection<Operation> getAllOutRTMessages(Package protocolContainer) {
        return ProtocolContainerUtils.getAllRTMessages(protocolContainer, RTMessageKind.OUT);
    }

    public static Collection<Operation> getAllInOutRTMessages(Package protocolContainer) {
        return ProtocolContainerUtils.getAllRTMessages(protocolContainer, RTMessageKind.IN_OUT);
    }

    public static List<Operation> getRTMessages(Package protocolContainer, RTMessageKind direction) {
        return ProtocolContainerUtils.getRTMessages(protocolContainer, direction, false);
    }

    public static List<Operation> getInRTMessages(Package protocolContainer) {
        return ProtocolContainerUtils.getRTMessages(protocolContainer, RTMessageKind.IN);
    }

    public static Collection<Operation> geOutRTMessages(Package protocolContainer) {
        return ProtocolContainerUtils.getRTMessages(protocolContainer, RTMessageKind.OUT);
    }

    public static Collection<Operation> getInOutRTMessages(Package protocolContainer) {
        return ProtocolContainerUtils.getRTMessages(protocolContainer, RTMessageKind.IN_OUT);
    }

    public static Interface getMessageSet(Package protocolContainer, RTMessageKind messageKind) {
        for (PackageableElement packageableElement : protocolContainer.getPackagedElements()) {
            RTMessageSet messageSet;
            if (!(packageableElement instanceof Interface) || (messageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)packageableElement, RTMessageSet.class)) == null || messageKind == null || !messageKind.equals((Object)messageSet.getRtMsgKind())) continue;
            return (Interface)packageableElement;
        }
        return null;
    }

    public static Interface getMessageSetIn(Package protocolContainer) {
        return ProtocolContainerUtils.getMessageSet(protocolContainer, RTMessageKind.IN);
    }

    public static Interface getMessageSetOut(Package protocolContainer) {
        return ProtocolContainerUtils.getMessageSet(protocolContainer, RTMessageKind.OUT);
    }

    public static Interface getMessageSetInOut(Package protocolContainer) {
        return ProtocolContainerUtils.getMessageSet(protocolContainer, RTMessageKind.IN_OUT);
    }

    public static Collaboration getCollaboration(Package protocolContainer) {
        for (PackageableElement packageableElement : protocolContainer.getPackagedElements()) {
            if (!(packageableElement instanceof Collaboration)) continue;
            return (Collaboration)packageableElement;
        }
        return null;
    }

    public static boolean containsProtocolContainer(Package container) {
        Collection packages = EcoreUtil.getObjectsByType((Collection)container.getPackagedElements(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        if (packages != null && !packages.isEmpty()) {
            IElementType type = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer");
            if (!(type instanceof ISpecializationType)) {
                return false;
            }
            for (Package pkg : packages) {
                if (!((ISpecializationType)type).getMatcher().matches((EObject)pkg)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Package> getContainedProtocolContainers(Package container) {
        Collection packages = EcoreUtil.getObjectsByType((Collection)container.getPackagedElements(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        if (packages != null && !packages.isEmpty()) {
            IElementType type = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer");
            if (!(type instanceof ISpecializationType)) {
                return Collections.emptyList();
            }
            ArrayList<Package> protocolContainers = null;
            for (Package pkg : packages) {
                if (!((ISpecializationType)type).getMatcher().matches((EObject)pkg)) continue;
                if (protocolContainers == null) {
                    protocolContainers = new ArrayList<Package>();
                }
                protocolContainers.add(pkg);
            }
        }
        return Collections.emptyList();
    }

    public static boolean isProtocolContainer(EObject package_) {
        IElementType type = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer");
        if (!(type instanceof ISpecializationType)) {
            return false;
        }
        return ((ISpecializationType)type).getMatcher().matches(package_);
    }

    public static List<PackageableElement> getFilteredPackagedElements(Element source) {
        if (!(source instanceof Package)) {
            return Collections.emptyList();
        }
        if (!ProtocolContainerUtils.containsProtocolContainer((Package)source)) {
            return ((Package)source).getPackagedElements();
        }
        ArrayList<PackageableElement> returnList = new ArrayList<PackageableElement>((Collection<PackageableElement>)((Package)source).getPackagedElements());
        for (PackageableElement packageableElement : ((Package)source).getPackagedElements()) {
            if (!(packageableElement instanceof Package) || !ProtocolContainerUtils.isProtocolContainer((EObject)packageableElement)) continue;
            int i = returnList.indexOf(packageableElement);
            returnList.remove(packageableElement);
            returnList.add(i, (PackageableElement)ProtocolContainerUtils.getCollaboration((Package)packageableElement));
        }
        return returnList;
    }

    public static Package getProtocolContainer(PackageableElement element) {
        return element.getNearestPackage();
    }

    public static EObject getProtocolContainer(EObject eObject) {
        EObject result = null;
        result = eObject instanceof Package ? eObject : ProtocolContainerUtils.getProtocolContainer(eObject.eContainer());
        return result;
    }

    public static MoveElementsCommand createMoveProtocolContainerCommand(MoveRequest request, EObject protocolContainerToMove) {
        EObject targetContainer = ProtocolContainerUtils.getProtocolContainer(request.getTargetContainer());
        MoveRequest moveRequest = new MoveRequest(targetContainer, protocolContainerToMove);
        MoveElementsCommand command = new MoveElementsCommand(moveRequest);
        return command;
    }

    public static Collaboration getProtocol(Package protocolContainer) {
        if (protocolContainer == null) {
            return null;
        }
        for (PackageableElement packageableElement : protocolContainer.getPackagedElements()) {
            if (!ProtocolUtils.isProtocol((EObject)packageableElement).booleanValue()) continue;
            return (Collaboration)packageableElement;
        }
        return null;
    }
}

