/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class ProtocolUtils {
    public static Package getProtocolContainer(Collaboration protocol) {
        return protocol.getNearestPackage();
    }

    public static Boolean isProtocol(EObject context) {
        return ElementTypeUtils.matches(context, "org.eclipse.papyrusrt.umlrt.core.Protocol");
    }

    public static List<Operation> getRTMessages(Collaboration protocol, RTMessageKind direction, boolean showInherited) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(protocol);
        if (protocolContainer == null) {
            Activator.log.error("Impossible to get the root protocol container", null);
            return Collections.emptyList();
        }
        return ProtocolContainerUtils.getRTMessages(protocolContainer, direction, showInherited);
    }

    public static Interface getMessageSet(Collaboration editContext, RTMessageKind direction) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(editContext);
        if (protocolContainer != null) {
            return ProtocolContainerUtils.getMessageSet(protocolContainer, direction);
        }
        return null;
    }

    public static Interface getMessageSetIn(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN);
    }

    public static Interface getMessageSetOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.OUT);
    }

    public static Interface getMessageSetInOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN_OUT);
    }
}

