/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.copy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageUtils;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class UmlRTPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new UmlRTPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "Uml RT Paste Strategy";
    }

    public String getID() {
        return "org.eclipse.papyrusrt.umlrt.tooling.diagram.common.UMLRTPasteStrategy";
    }

    public String getDescription() {
        return "Copy Call event in model explorer";
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("UML-RT : Duplicate Call event when copy/paste an operationl");
        Map additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
        if (additionalDataMap != null) {
            Object additionalData = null;
            for (Object object : papyrusClipboard) {
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (target == null || !(target instanceof Operation)) continue;
                Package nearestPackage = ((Element)targetOwner).getNearestPackage();
                additionalData = additionalDataMap.get(object);
                if (!(additionalData instanceof UmlRTClipboardAdditionalData)) continue;
                UmlRTClipboardAdditionalData umlRTClipboardAdditionalData = additionalData;
                CallEvent callEvent = umlRTClipboardAdditionalData.getDuplicateCallEvent();
                Command command = this.buildSemanticCommand(domain, callEvent, nearestPackage, (Operation)target);
                compoundCommand.append(command);
            }
        }
        if (compoundCommand.getCommandList().isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    protected Command buildSemanticCommand(EditingDomain domain, CallEvent targetCallEvent, Package nearestPackage, Operation operation) {
        targetCallEvent.setOperation(operation);
        Command command = AddCommand.create((EditingDomain)domain, (Object)nearestPackage, null, (Object)targetCallEvent);
        return command;
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, UmlRTClipboardAdditionalData> mapCopyToClipboardAdditionalData = new HashMap<Object, UmlRTClipboardAdditionalData>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            CallEvent callEvent;
            EObject eObjectSource = (EObject)iterator.next();
            if (!(eObjectSource instanceof Operation) || (callEvent = MessageUtils.getCallEvent((Operation)((Operation)eObjectSource))) == null) continue;
            UmlRTClipboardAdditionalData umlRTClipboardAdditionalData = new UmlRTClipboardAdditionalData(callEvent);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToClipboardAdditionalData.put(copy, umlRTClipboardAdditionalData);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToClipboardAdditionalData);
    }

    protected class UmlRTClipboardAdditionalData
    implements IClipboardAdditionalData {
        protected CallEvent callEvent;

        public UmlRTClipboardAdditionalData(CallEvent callEvent) {
            this.callEvent = this.duplicateCallEvent(callEvent);
        }

        public CallEvent getDuplicateCallEvent() {
            return this.duplicateCallEvent(this.callEvent);
        }

        protected CallEvent duplicateCallEvent(CallEvent callEvent) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.copy((EObject)callEvent);
            copier.copyReferences();
            EObject copy = (EObject)copier.get((Object)callEvent);
            if (copy instanceof CallEvent) {
                return (CallEvent)copy;
            }
            return null;
        }
    }
}

