/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.statemachine;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.UMLRTDiagramEdgesSyncFeature;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.UMLRTSyncRegistry;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.statemachine.CSMDTransitionSyncBucket;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.statemachine.CSMDTransitionSyncRegistry;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class CSMDStateMachineTransitionsSyncFeature
extends UMLRTDiagramEdgesSyncFeature<StateMachine, Transition> {
    public CSMDStateMachineTransitionsSyncFeature(SyncBucket<StateMachine, EditPart, Notification> bucket) {
        super(bucket);
    }

    @Override
    protected Class<? extends UMLRTSyncRegistry<Transition>> getNestedSyncRegistryType() {
        return CSMDTransitionSyncRegistry.class;
    }

    @Override
    protected SyncBucket<Transition, EditPart, Notification> createNestedSyncBucket(Transition model, EditPart editPart) {
        return new CSMDTransitionSyncBucket(model, editPart);
    }

    protected EditPart getTargetEditPart(EditPart parentEditPart, DropObjectsRequest dropObjectsRequest) {
        Transition transition = (Transition)dropObjectsRequest.getObjects().get(0);
        Vertex source = transition.getSource();
        EditPart sourceEditPart = this.findEditPart(parentEditPart, (EObject)source);
        return sourceEditPart.getParent();
    }

    @Override
    protected Iterable<? extends Transition> getModelContents(final StateMachine model) {
        return new Iterable<Transition>(){

            @Override
            public Iterator<Transition> iterator() {
                return new AbstractIterator<Transition>(model){
                    Queue<Region> regions;
                    Iterator<Transition> current;
                    {
                        this.regions = Lists.newLinkedList((Iterable)stateMachine.getRegions());
                    }

                    protected Transition computeNext() {
                        Transition result = null;
                        while (result == null) {
                            if (this.current == null || !this.current.hasNext()) {
                                this.current = null;
                                Region nextRegion = this.regions.poll();
                                if (nextRegion != null) {
                                    for (State next : Iterables.filter((Iterable)nextRegion.getSubvertices(), State.class)) {
                                        if (!next.isComposite()) continue;
                                        this.regions.addAll((Collection<Region>)next.getRegions());
                                    }
                                    this.current = nextRegion.getTransitions().iterator();
                                }
                            }
                            if (this.current == null) break;
                            if (!this.current.hasNext()) continue;
                            result = this.current.next();
                        }
                        return result == null ? (Transition)this.endOfData() : result;
                    }
                };
            }
        };
    }

    EditPart findEditPart(EditPart diagram, EObject object) {
        EditPart result = null;
        TreeIterator iter = DiagramEditPartsUtil.getAllContents((EditPart)diagram, (boolean)false);
        while (result == null && iter.hasNext()) {
            EditPart next = (EditPart)iter.next();
            Object view = next.getModel();
            if (!(view instanceof View)) {
                iter.prune();
                continue;
            }
            EObject model = ((View)view).getElement();
            if (model == null || !EcoreUtil.isAncestor((EObject)model, (EObject)object)) {
                iter.prune();
                continue;
            }
            if (model != object) continue;
            result = next;
        }
        return result;
    }
}

