/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.utils;

import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.InterfaceRealizationUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UsageUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Usage;

/**
 * Utilitiy class to compute labels according to the '@noname' directive
 */
public class LabelUtils {

	public static String getProtocolContainerLabel(Package protocolContainer, IItemLabelProvider referenceLabelProvider) {
		Collaboration collaboration = ProtocolContainerUtils.getProtocol(protocolContainer);
		if (collaboration != null && collaboration.getName() != null) {
			return referenceLabelProvider.getText(protocolContainer) + " " + collaboration.getName();
		}
		return referenceLabelProvider.getText(protocolContainer);
	}

	public static String getCallEventForProtocolMessageLabel(CallEvent callEvent, IItemLabelProvider referenceLabelProvider) {
		Operation operation = callEvent.getOperation();
		if (operation != null && operation.getName() != null) {
			RTMessageKind kind = RTMessageUtils.getMessageKind(operation);
			String direction = (kind != null) ? kind.getName() : "";
			return direction + " " + operation.getName();
		}
		return referenceLabelProvider.getText(callEvent);
	}

	public static String getMessageSetLabel(Interface messageSet, IItemLabelProvider referenceLabelProvider) {
		RTMessageKind kind = MessageSetUtils.getMessageKind(messageSet);
		if (kind != null) {
			// retrieve associated Capsule
			Collaboration protocol = MessageSetUtils.getProtocol(messageSet);
			if (protocol != null) {
				switch (kind) {
				case IN:
					return MessageSetUtils.computeInterfaceInName(protocol.getName());
				case OUT:
					return MessageSetUtils.computeInterfaceOutName(protocol.getName());
				case IN_OUT:
					return MessageSetUtils.computeInterfaceInOutName(protocol.getName());
				default:
					return protocol.getName();
				}
			}
		}
		return referenceLabelProvider.getText(messageSet);
	}

	public static String getInterfaceRealizationLabel(InterfaceRealization interfaceRealization, IItemLabelProvider referenceLabelProvider) {
		// name of the interfaceRealization = name of the target MessageSet
		Interface messageSet = InterfaceRealizationUtils.getMessageSet(interfaceRealization);
		if (messageSet != null) {
			return getMessageSetLabel(messageSet, referenceLabelProvider);
		}
		return referenceLabelProvider.getText(interfaceRealization);
	}

	public static String getUsageLabel(Usage usage, IItemLabelProvider referenceLabelProvider) {
		// name of the interfaceRealization = name of the target MessageSet
		Interface messageSet = UsageUtils.getMessageSet(usage);
		if (messageSet != null) {
			return getMessageSetLabel(messageSet, referenceLabelProvider);
		}
		return referenceLabelProvider.getText(usage);
	}


}
