/*****************************************************************************
 * Copyright (c) 2010, 2015 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 		Celine JANSSENS (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.util.Constants;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindEnum;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindObservableValue;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTStereotypeModelElement extends StereotypeModelElement {


	private EObject stereoApplication;

	public RTStereotypeModelElement(final EObject stereoApplication, final Stereotype stereotype, final EditingDomain domain) {
		super(stereoApplication, stereotype, domain);
		this.stereoApplication = stereoApplication;
	}

	@Override
	protected boolean isFeatureEditable(final String propertyPath) {
		boolean editable = true;
		Object source = UMLUtil.getBaseElement(stereoApplication);

		if (source instanceof Port) {
			Port port = (Port) source;
			if (Constants.KIND.equals(propertyPath)) {
				editable = true;
			} else if (Constants.NOTIFICATION.equals(propertyPath)) {
				editable = true; // TODO: This method is not updated when values are changed (good value would be when portHelper.isBehavior(port);)
			} else if (Constants.WIRED.equals(propertyPath)) {
				editable = true; // TODO: This method is not updated when values are changed (good value would be when portHelper.isBehavior(port) || portHelper.isConnected(port);)
			} else if (Constants.PUBLISH.equals(propertyPath)) {
				editable = false;
			}
		} else {

			editable = super.isFeatureEditable(propertyPath);
		}
		return editable;
	}


	@Override
	public IObservable doGetObservable(final String propertyPath) {
		IObservable observe = null;

		// Case of Kind value in the Port RT Property View
		if (Constants.KIND.equals(propertyPath)) {
			observe = new PortRTKindObservableValue(UMLUtil.getBaseElement(stereoApplication), (TransactionalEditingDomain) domain);
		} else {
			observe = super.doGetObservable(propertyPath);
		}
		return observe;

	}


	/**
	 * The ContentProvider provide the Map of the Enum value, and there Label to the EnumRadio Editor.
	 * 
	 * @see org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement#getContentProvider(java.lang.String)
	 *
	 * @param propertyPath
	 * @return
	 */
	@Override
	public IStaticContentProvider getContentProvider(String propertyPath) {
		IStaticContentProvider provider = null;
		if (Constants.KIND.equals(propertyPath)) {
			Map<Object, String> map = new HashMap<Object, String>();

			map.put(PortRTKindEnum.EXTERNAL, PortRTKindEnum.EXTERNAL.getLabel());
			map.put(PortRTKindEnum.INTERNAL, PortRTKindEnum.INTERNAL.getLabel());
			map.put(PortRTKindEnum.RELAY, PortRTKindEnum.RELAY.getLabel());
			map.put(PortRTKindEnum.SAP, PortRTKindEnum.SAP.getLabel());
			map.put(PortRTKindEnum.SPP, PortRTKindEnum.SPP.getLabel());

			provider = new StaticContentProvider(map.keySet().toArray());

		} else {
			provider = super.getContentProvider(propertyPath);
		}
		return provider;
	}

}
