package org.eclipse.papyrusrt.umlrt.tooling.ui.util;

import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;

public class RTPortHelper {
	/**
	 * singleton instance
	 */
	private static RTPortHelper helper;

	/** Singleton constructor */
	private RTPortHelper() {
	}

	/**
	 * Returns the singleton instance of this class
	 *
	 * @return the singleton instance.
	 */
	public static RTPortHelper getInstance() {
		if (helper == null) {
			helper = new RTPortHelper();
		}
		return helper;
	}

	public boolean isConnected(Port port) {
		// TODO To Implements
		return true;
	}

	public Stereotype getStereotype(Port port) {
		return port.getAppliedStereotype(Constants.UML_RT_STEREOTYPE_QN);
	}


	public boolean isWired(Port port) {
		return (Boolean) port.getValue(getStereotype(port), Constants.WIRED);
	}

	public boolean isPublish(Port port) {
		return (Boolean) port.getValue(getStereotype(port), Constants.PUBLISH);
	}

	public boolean isNotification(Port port) {
		return (Boolean) port.getValue(getStereotype(port), Constants.NOTIFICATION);
	}

	public boolean isBehavior(Port port) {
		return port.isBehavior();
	}

	public boolean isService(Port port) {
		return port.isService();
	}

	public boolean isConjugated(Port port) {
		return port.isConjugated();
	}


}
