/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.util.RTPortHelper;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindEnum;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;

public class PortRTKindObservableValue
extends PapyrusObservableValue
implements IObserving,
IValueChangeListener {
    private Port port;
    private Stereotype stereo;
    private EObject stereotypeApplication;
    private boolean service;
    private boolean wired;
    private boolean behavior;
    private boolean publish;
    private boolean conjugated;
    private boolean notification;

    public PortRTKindObservableValue(Element sourceElement, TransactionalEditingDomain domain) {
        super((EObject)sourceElement, sourceElement.eContainingFeature(), (EditingDomain)domain);
        if (sourceElement instanceof Port) {
            this.port = (Port)sourceElement;
            this.stereo = this.port.getAppliedStereotype("UMLRealTime::RTPort");
            this.stereotypeApplication = this.port.getStereotypeApplication(this.stereo);
            this.stereotypeApplication.eAdapters().add((Object)this.getListener());
            this.port.eAdapters().add((Object)this.getListener());
            this.setUMLPropertiesValue();
            this.setUMLRTPropertiesValue();
        }
    }

    private AdapterImpl getListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                Object feature = notification.getFeature();
                EList realTimeFeatureList = PortRTKindObservableValue.this.stereotypeApplication.eClass().getEStructuralFeatures();
                EList umlFeatureList = PortRTKindObservableValue.this.port.eClass().getEStructuralFeatures();
                if (notifier == PortRTKindObservableValue.this.stereotypeApplication && type == 1) {
                    if (realTimeFeatureList.contains(feature)) {
                        this.fireDiff(notification);
                    }
                } else if (notifier == PortRTKindObservableValue.this.port && type == 1 && umlFeatureList.contains(feature)) {
                    this.fireDiff(notification);
                }
            }

            private void fireDiff(Notification notification) {
                final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
                PortRTKindObservableValue.this.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        PortRTKindObservableValue.this.fireValueChange(diff);
                    }
                });
            }
        };
    }

    private void setUMLRTPropertiesValue() {
        this.wired = RTPortHelper.getInstance().isWired(this.port);
        this.notification = RTPortHelper.getInstance().isNotification(this.port);
        this.publish = RTPortHelper.getInstance().isPublish(this.port);
    }

    private void setUMLPropertiesValue() {
        this.service = RTPortHelper.getInstance().isService(this.port);
        this.behavior = RTPortHelper.getInstance().isBehavior(this.port);
        this.conjugated = RTPortHelper.getInstance().isConjugated(this.port);
    }

    public Object getValueType() {
        return PortRTKindEnum.class;
    }

    public Object getObserved() {
        return this.port;
    }

    protected Object doGetValue() {
        PortRTKindEnum kind = PortRTKindEnum.RELAY;
        this.setUMLPropertiesValue();
        this.setUMLRTPropertiesValue();
        if (this.service && this.wired && this.behavior && !this.publish) {
            kind = PortRTKindEnum.EXTERNAL;
        } else if (this.service && this.behavior && this.publish && !this.wired) {
            kind = PortRTKindEnum.SPP;
        } else if (this.wired && this.behavior && !this.service && !this.publish) {
            kind = PortRTKindEnum.INTERNAL;
        } else if (this.service && this.wired && !this.behavior && !this.publish) {
            kind = PortRTKindEnum.RELAY;
        } else if (this.behavior && !this.wired && !this.publish && !this.service) {
            kind = PortRTKindEnum.SAP;
        }
        return kind;
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
    }

    public Command getCommand(Object value) {
        Command command = null;
        if (value instanceof PortRTKindEnum) {
            switch ((PortRTKindEnum)value) {
                case EXTERNAL: {
                    command = this.getCommandForRTPort(true, false, true, true);
                    break;
                }
                case INTERNAL: {
                    command = this.getCommandForRTPort(true, false, false, true);
                    break;
                }
                case RELAY: {
                    command = this.getCommandForRTPort(false, false, true, true);
                    break;
                }
                case SAP: {
                    command = this.getCommandForRTPort(true, false, false, false);
                    break;
                }
                case SPP: {
                    command = this.getCommandForRTPort(true, true, true, false);
                    break;
                }
                default: {
                    command = this.getCommandForRTPort(false, false, true, true);
                }
            }
        }
        return command;
    }

    private Command getCommandForRTPort(boolean behavior, boolean publish, boolean service, boolean wired) {
        CompoundCommand command = new CompoundCommand();
        command.append(this.getSetBehaviorCommand(behavior));
        command.append(this.getSetPublishCommand(publish));
        command.append(this.getSetServiceCommand(service));
        command.append(this.getSetWiredCommand(wired));
        return command;
    }

    private Command getSetPublishCommand(final boolean publish) {
        RecordingCommand publishCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                PortRTKindObservableValue.this.port.setValue(PortRTKindObservableValue.this.stereo, "isPublish", (Object)publish);
            }

            public boolean canExecute() {
                return true;
            }
        };
        return publishCommand;
    }

    private Command getSetWiredCommand(final boolean wired) {
        RecordingCommand wiredCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                PortRTKindObservableValue.this.port.setValue(PortRTKindObservableValue.this.stereo, "isWired", (Object)wired);
            }

            public boolean canExecute() {
                return true;
            }
        };
        return wiredCommand;
    }

    private Command getSetServiceCommand(final boolean service) {
        RecordingCommand serviceCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                PortRTKindObservableValue.this.port.setIsService(service);
            }

            public boolean canExecute() {
                return true;
            }
        };
        return serviceCommand;
    }

    private Command getSetBehaviorCommand(final boolean behavior) {
        RecordingCommand behaviorCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                PortRTKindObservableValue.this.port.setIsBehavior(behavior);
            }

            public boolean canExecute() {
                return true;
            }
        };
        return behaviorCommand;
    }

    public void handleValueChange(ValueChangeEvent event) {
        this.fireChange();
    }
}

