/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.ChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.GeneratorManager;
import org.eclipse.papyrusrt.codegen.cpp.UML2ChangeTracker;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.RTCppGenerationProperties;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypeDefinition;
import org.eclipse.papyrusrt.xtumlrt.common.util.CommonSwitch;
import org.eclipse.uml2.uml.Class;

public class CppCodeGenerator {
    private final CppCodePattern cpp;
    private final List<EObject> targets = new ArrayList<EObject>();
    private Class top;
    private ChangeTracker changeTracker;

    public CppCodeGenerator(CppCodePattern cpp) {
        this.cpp = cpp;
        this.changeTracker = new UML2ChangeTracker(cpp.getTranslator());
        UML2ChangeTracker.setActiveInstance((UML2ChangeTracker)this.changeTracker);
    }

    public CppCodeGenerator(CppCodePattern cpp, Class top) {
        this(cpp);
        this.top = top;
        this.changeTracker.setTop(top);
    }

    public CppCodeGenerator(CppCodePattern cpp, Class top, EObject target) {
        this(cpp, top);
        this.targets.add(target);
    }

    public CppCodeGenerator(CppCodePattern cpp, Class top, List<EObject> targets) {
        this(cpp, top);
        this.targets.addAll(targets);
    }

    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    public void setTop(Class top) {
        this.top = top;
        this.changeTracker.setTop(top);
    }

    public void setTarget(EObject target) {
        this.targets.add(target);
    }

    public void setTargets(List<EObject> targets) {
        this.targets.addAll(targets);
    }

    public IStatus generate() {
        long start = System.currentTimeMillis();
        MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 0, "UML-RT Code Generation", null);
        LinkedHashMap<GeneratorKey, AbstractCppGenerator> generators = new LinkedHashMap<GeneratorKey, AbstractCppGenerator>();
        Collector collector = new Collector(generators);
        for (EObject target : this.targets) {
            if (!this.toBeGenerated(target) || ((Boolean)collector.doSwitch(target)).booleanValue()) continue;
            status.add(CodeGenPlugin.error((String)"Error while examining model changes"));
        }
        status.add(CodeGenPlugin.info((String)("Examined model changes " + (System.currentTimeMillis() - start) + "ms")));
        HashSet<String> srcFileNames = new HashSet<String>();
        for (GeneratorKey key : generators.keySet()) {
            if (!(key.object instanceof StructuredType) && !(key.object instanceof Protocol)) continue;
            srcFileNames.add(((NamedElement)key.object).getName());
        }
        this.cpp.setSourceFiles(srcFileNames);
        start = System.currentTimeMillis();
        this.changeTracker.prune(generators);
        status.add(CodeGenPlugin.info((String)("Prune unchanged elements " + (System.currentTimeMillis() - start) + "ms")));
        for (GeneratorKey key : generators.keySet()) {
            AbstractCppGenerator generator = (AbstractCppGenerator)generators.get(key);
            try {
                start = System.currentTimeMillis();
                if (generator.generate()) {
                    status.add(CodeGenPlugin.info((String)(String.valueOf(generator.getLabel()) + ' ' + (System.currentTimeMillis() - start) + "ms")));
                    this.changeTracker.addAlreadyGenerated(key.kind, (NamedElement)key.object);
                    continue;
                }
                status.add(CodeGenPlugin.error((String)("Error while generating " + generator.getLabel())));
            }
            catch (Exception e) {
                status.add(CodeGenPlugin.error((Throwable)e));
            }
        }
        start = System.currentTimeMillis();
        this.changeTracker.consumeChanges(generators);
        status.add(CodeGenPlugin.info((String)("Consume changes to elements " + (System.currentTimeMillis() - start) + "ms")));
        return status;
    }

    private boolean toBeGenerated(EObject target) {
        if (!(target instanceof NamedElement)) {
            return false;
        }
        NamedElement element = (NamedElement)target;
        if (XTUMLRTUtil.isSystemElement((CommonElement)element)) {
            return false;
        }
        Boolean generateBool = RTCppGenerationProperties.getGenerationPropGenerate((CommonElement)element);
        if (generateBool == null) {
            return true;
        }
        return generateBool;
    }

    private class Collector
    extends CommonSwitch<Boolean> {
        private final GeneratorManager genManager = GeneratorManager.getInstance();
        public final Map<GeneratorKey, AbstractCppGenerator> generators;

        public Collector(Map<GeneratorKey, AbstractCppGenerator> generators) {
            this.generators = generators;
        }

        private <T extends NamedElement> boolean createGenerator(Kind kind, T object, T context) {
            GeneratorKey key = new GeneratorKey(kind, (EObject)object, (EObject)context);
            if (this.generators.get(key) != null) {
                return false;
            }
            AbstractCppGenerator generator = this.genManager.getGenerator(kind, CppCodeGenerator.this.cpp, object, context);
            if (generator == null) {
                return false;
            }
            this.generators.put(key, generator);
            return true;
        }

        public Boolean defaultCase(EObject object) {
            return true;
        }

        public Boolean caseModel(Model model) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)model)) {
                return true;
            }
            for (Entity element : model.getEntities()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : model.getProtocols()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : model.getTypeDefinitions()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : model.getPackages()) {
                this.doSwitch((EObject)element);
            }
            return true;
        }

        public Boolean casePackage(Package packge) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)packge)) {
                return true;
            }
            for (Entity element : packge.getEntities()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : packge.getProtocols()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : packge.getTypeDefinitions()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : packge.getPackages()) {
                this.doSwitch((EObject)element);
            }
            return true;
        }

        public Boolean caseProtocol(Protocol protocol) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)protocol)) {
                return true;
            }
            if (!XTUMLRTUtil.isSystemElement((CommonElement)protocol) && this.createGenerator(Kind.Protocol, (T)protocol, (T)null)) {
                for (Signal signal : XTUMLRTUtil.getSignals((Protocol)protocol)) {
                    for (Parameter p : signal.getParameters()) {
                        if (p.getType() == null) continue;
                        this.doSwitch((EObject)p.getType());
                    }
                }
                Model model = XTUMLRTUtil.getModel((CommonElement)protocol);
                if (model == null) {
                    return true;
                }
                for (Capsule capsule : XTUMLRTUtil.getAllCapsules((EObject)model)) {
                    for (Port port : XTUMLRTUtil.getAllRTPorts((Capsule)capsule)) {
                        if (port.getType() != protocol) continue;
                        this.doSwitch((EObject)capsule);
                    }
                }
            }
            return true;
        }

        public Boolean caseTypeDefinition(TypeDefinition typedef) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)typedef)) {
                return true;
            }
            return (Boolean)this.doSwitch((EObject)typedef.getType());
        }

        public Boolean caseStructuredType(StructuredType struct) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)struct)) {
                return true;
            }
            this.createGenerator(Kind.BasicClass, (T)struct, (T)null);
            return true;
        }

        public Boolean caseCapsule(Capsule capsule) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)capsule)) {
                return true;
            }
            this.createGenerator(Kind.Capsule, (T)capsule, (T)null);
            StateMachine behaviour = XTUMLRTUtil.getActualBehaviour((Capsule)capsule);
            if (behaviour != null && CppCodeGenerator.this.toBeGenerated((EObject)behaviour)) {
                this.createGenerator(Kind.StateMachine, (NamedElement)behaviour, (NamedElement)capsule);
            } else {
                this.createGenerator(Kind.EmptyStateMachine, (T)capsule, (T)null);
            }
            if (CppCodeGenerator.this.top.getName().equals(capsule.getName())) {
                this.createGenerator(Kind.Structural, (T)capsule, (T)null);
            }
            return true;
        }

        public Boolean caseEntity(Entity object) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)object)) {
                return true;
            }
            this.createGenerator(Kind.BasicClass, (T)object, (T)null);
            return true;
        }

        public Boolean caseEnumeration(Enumeration object) {
            if (!CppCodeGenerator.this.toBeGenerated((EObject)object)) {
                return true;
            }
            this.createGenerator(Kind.Enum, (T)object, (T)null);
            return true;
        }
    }

    protected static class GeneratorKey {
        public final Kind kind;
        public final EObject object;
        public final EObject context;

        public GeneratorKey(Kind kind, EObject object, EObject context) {
            this.kind = kind;
            this.object = object;
            this.context = context;
        }

        public int hashCode() {
            return this.kind.hashCode() ^ this.object.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GeneratorKey)) {
                return false;
            }
            GeneratorKey other = (GeneratorKey)obj;
            if (this.context == null) {
                return this.kind == other.kind && this.object.equals(other.object) && other.context == null;
            }
            return this.kind == other.kind && this.object.equals(other.object) && this.context.equals(other.context);
        }
    }

    public static enum Kind {
        BasicClass("ClassGenerator"),
        Enum("EnumGenerator"),
        Protocol("ProtocolGenerator"),
        Capsule("CapsuleGenerator "),
        StateMachine("StateMachineGenerator"),
        EmptyStateMachine("EmptyStateMachineGenerator"),
        Structural("StructuralGenerator");

        public final String id;

        private Kind(String id) {
            this.id = id;
        }
    }
}

