/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.FunctionPointer;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.CodeBlock;

public abstract class AbstractFunction
extends NamedElement
implements IUserElement {
    private final Type returnType;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final CodeBlock body;
    protected boolean isInline = false;
    protected boolean onlyDecl = false;

    public AbstractFunction(Type returnType, String ident) {
        super(ident);
        this.returnType = returnType;
        this.body = CodeBlock.forceBraces();
    }

    public AbstractFunction(HeaderFile header, Type returnType, Name name) {
        super(header, name);
        this.returnType = returnType;
        this.body = CodeBlock.forceBraces();
    }

    public void add(Statement ... stmts) {
        this.body.add(stmts);
    }

    public void add(Expression expr) {
        this.body.add(expr);
    }

    public void add(Variable var) {
        this.body.add(var);
    }

    public void add(Parameter param) {
        this.parameters.add(param);
    }

    public ElementAccess param(int index) {
        return new ElementAccess(this.parameters.get(index));
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type createType() {
        FunctionPointer funcPtr = new FunctionPointer(this.returnType);
        for (Parameter param : this.parameters) {
            funcPtr.add(param.getType());
        }
        return funcPtr.getType();
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        return this.addSignatureDependencies(deps.decl()) && this.addBodyDependencies(deps.defn());
    }

    protected boolean addSignatureDependencies(DependencyList deps) {
        if (!this.returnType.addDependencies(deps)) {
            return false;
        }
        for (Parameter param : this.parameters) {
            if (param.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    protected boolean addBodyDependencies(DependencyList deps) {
        return this.body.addDependencies(deps);
    }

    public void setInline() {
        this.isInline = true;
    }

    public void setOnlyDecl() {
        this.onlyDecl = true;
    }

    protected boolean writeSignature(CppFormatter fmt) {
        if (!(this.returnType.write(fmt, null) && fmt.space() && fmt.write(this.getName()) && fmt.write("("))) {
            return false;
        }
        boolean first = true;
        for (Parameter param : this.parameters) {
            if (first) {
                first = false;
                if (!fmt.space()) {
                    return false;
                }
            } else if (!fmt.write(", ")) {
                return false;
            }
            if (param.write(fmt)) continue;
            return false;
        }
        return fmt.spaceUnless('(') && fmt.write(')');
    }

    protected boolean writeBody(CppFormatter fmt) {
        return this.body.write(fmt);
    }
}

