/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.internal;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleManager;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrusrt.codegen.cpp.UML2ChangeTracker;

public class ModelCloseService
implements IService {
    private ServicesRegistry registry;

    public void disposeService() throws ServiceException {
    }

    public void init(ServicesRegistry registry) throws ServiceException {
        this.registry = registry;
    }

    public void startService() throws ServiceException {
        ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
        EditorLifecycleManager lifecycleManager = (EditorLifecycleManager)this.registry.getService(EditorLifecycleManager.class);
        lifecycleManager.addEditorLifecycleEventsListener((EditorLifecycleEventListener)new EditorCycleListener(editingDomain));
    }

    protected static class EditorCycleListener
    implements EditorLifecycleEventListener {
        TransactionalEditingDomain domain;

        EditorCycleListener(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        public void postInit(IMultiDiagramEditor editor) {
        }

        public void postDisplay(IMultiDiagramEditor editor) {
        }

        public void beforeClose(IMultiDiagramEditor editor) {
            for (Resource res : this.domain.getResourceSet().getResources()) {
                UML2ChangeTracker activeInstance = UML2ChangeTracker.getActiveInstance();
                if (activeInstance == null) continue;
                activeInstance.closeResource(res);
            }
        }
    }
}

