/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratableElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.UserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AbstractFunctionCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.IReferencable;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.CodeBlock;

public class Constructor
extends UserElement
implements IReferencable,
IGeneratableElement {
    private CppClass cls;
    private Name name;
    private final List<AbstractFunctionCall> baseInitializers = new ArrayList<AbstractFunctionCall>();
    private final List<Initializer> fieldInitializers = new ArrayList<Initializer>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final CodeBlock body = CodeBlock.forceBraces();

    public CppClass getCppClass() {
        return this.cls;
    }

    public void setCppClass(CppClass parent) {
        this.cls = parent;
        this.name = new Name(parent.getName().getIdentifier());
        this.name.setParent(parent);
    }

    public void addBaseInitializer(AbstractFunctionCall baseCtor) {
        this.baseInitializers.add(baseCtor);
    }

    public void addFieldInitializer(MemberField field, Expression ... inits) {
        this.fieldInitializers.add(new Initializer(field, inits));
    }

    public void add(Statement ... stmts) {
        this.body.add(stmts);
    }

    public void add(Expression expr) {
        this.body.add(expr);
    }

    public void add(Variable var) {
        this.body.add(var);
    }

    public void add(Parameter param) {
        this.parameters.add(param);
    }

    protected boolean writeSignature(CppFormatter fmt) {
        if (!fmt.write(this.name) || !fmt.write('(')) {
            return false;
        }
        boolean first = true;
        for (Parameter param : this.parameters) {
            if (first) {
                first = false;
                if (!fmt.space()) {
                    return false;
                }
            } else if (!fmt.write(", ")) {
                return false;
            }
            if (param.write(fmt)) continue;
            return false;
        }
        return fmt.spaceUnless('(') && fmt.write(')');
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        for (Parameter param : this.parameters) {
            if (param.addDependencies(deps.decl())) continue;
            return false;
        }
        for (AbstractFunctionCall baseInit : this.baseInitializers) {
            if (baseInit.addDependencies(deps.defn())) continue;
            return false;
        }
        for (Initializer init : this.fieldInitializers) {
            if (init.addDependencies(deps.defn())) continue;
            return false;
        }
        return this.body.addDependencies(deps.defn());
    }

    @Override
    public boolean write(CppWriter out) {
        if (!this.writeSignature(out.decl()) || !out.decl().terminate()) {
            return false;
        }
        if (!this.writeSignature(out.defn())) {
            return false;
        }
        out.defn().enter(this.name.getParent());
        int separator = 58;
        for (AbstractFunctionCall ctor : this.baseInitializers) {
            if (!(out.defn().newline() && out.defn().write((char)separator) && out.defn().space() && ctor.write(out.defn()))) {
                return false;
            }
            separator = 44;
        }
        for (Initializer init : this.fieldInitializers) {
            if (!(out.defn().newline() && out.defn().write((char)separator) && out.defn().space() && init.write(out.defn()))) {
                return false;
            }
            separator = 44;
        }
        boolean ret = this.body.write(out.defn());
        out.defn().exit();
        return ret;
    }

    @Override
    public boolean write(CppFormatter fmt, Name name, List<Type.Pointer> pointerSpec, List<Expression> arrayBounds) {
        if (!fmt.write(name) || !fmt.pendingSpace()) {
            return false;
        }
        boolean first = true;
        for (Type.Pointer ptr : pointerSpec) {
            if (first) {
                first = false;
            } else if (!fmt.space()) {
                return false;
            }
            if (ptr.write(fmt)) continue;
            return false;
        }
        if (!fmt.pendingSpace() || !fmt.write(name)) {
            return false;
        }
        int i = arrayBounds.size();
        while (i > 0) {
            if (!fmt.write("[]")) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static class Initializer
    implements IGeneratable {
        private final MemberField field;
        private final List<Expression> exprs;

        public Initializer(MemberField field, Expression[] inits) {
            this.field = field;
            this.exprs = new ArrayList<Expression>(Arrays.asList(inits));
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            for (Expression expr : this.exprs) {
                if (expr.addDependencies(deps)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean write(CppFormatter fmt) {
            if (!(fmt.write(this.field.getName()) && fmt.write('(') && fmt.pendingSpace())) {
                return false;
            }
            boolean first = true;
            for (Expression expr : this.exprs) {
                if (first) {
                    first = false;
                } else if (!fmt.write(',') || !fmt.space()) {
                    return false;
                }
                if (expr.write(fmt)) continue;
                return false;
            }
            return fmt.spaceUnless(' ') && fmt.write(')');
        }
    }
}

