/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.IReferencable;

public class PrimitiveType
extends Type {
    public static final PrimitiveType VOID = new PrimitiveType(new BuiltInElement(BuiltInType.VOID));
    public static final PrimitiveType CHAR = new PrimitiveType(new BuiltInElement(BuiltInType.CHAR));
    public static final PrimitiveType SHORT = new PrimitiveType(new BuiltInElement(BuiltInType.SHORT));
    public static final PrimitiveType INT = new PrimitiveType(new BuiltInElement(BuiltInType.INT));
    public static final PrimitiveType LONG = new PrimitiveType(new BuiltInElement(BuiltInType.LONG));
    public static final PrimitiveType LONGLONG = new PrimitiveType(new BuiltInElement(BuiltInType.LONGLONG));
    public static final PrimitiveType UCHAR = new PrimitiveType(new BuiltInElement(BuiltInType.UCHAR));
    public static final PrimitiveType USHORT = new PrimitiveType(new BuiltInElement(BuiltInType.USHORT));
    public static final PrimitiveType UINT = new PrimitiveType(new BuiltInElement(BuiltInType.UINT));
    public static final PrimitiveType ULONG = new PrimitiveType(new BuiltInElement(BuiltInType.ULONG));
    public static final PrimitiveType ULONGLONG = new PrimitiveType(new BuiltInElement(BuiltInType.ULONGLONG));
    public static final PrimitiveType BOOL = new PrimitiveType(new BuiltInElement(BuiltInType.BOOL));
    public static final PrimitiveType FLOAT = new PrimitiveType(new BuiltInElement(BuiltInType.FLOAT));
    public static final PrimitiveType DOUBLE = new PrimitiveType(new BuiltInElement(BuiltInType.DOUBLE));
    public static final PrimitiveType LONGDOUBLE = new PrimitiveType(new BuiltInElement(BuiltInType.LONGDOUBLE));

    private PrimitiveType(BuiltInElement builtIn) {
        super(builtIn);
    }

    private BuiltInType getBuiltInType() {
        Element element = this.getElement();
        if (!(element instanceof BuiltInElement)) {
            throw new RuntimeException("invalid instance of PrimitiveType");
        }
        return ((BuiltInElement)element).type;
    }

    public boolean isIntegral() {
        return this.getBuiltInType().integral;
    }

    public boolean isUnsigned() {
        return this.getBuiltInType().unsigned;
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    private static class BuiltInElement
    extends Element
    implements IReferencable {
        public final BuiltInType type;

        public BuiltInElement(BuiltInType type) {
            this.type = type;
        }

        @Override
        public Type getType() {
            return new Type(this);
        }

        public String toString() {
            return this.type.literal;
        }

        public boolean write(CppFormatter fmt) {
            return this.type.write(fmt);
        }

        @Override
        public boolean write(CppFormatter fmt, Name name, List<Type.Pointer> pointerSpec, List<Expression> arrayBounds) {
            if (!this.write(fmt) || !fmt.pendingSpace()) {
                return false;
            }
            boolean first = true;
            for (Type.Pointer ptr : pointerSpec) {
                if (first) {
                    first = false;
                } else if (!fmt.space()) {
                    return false;
                }
                if (ptr.write(fmt)) continue;
                return false;
            }
            if (!fmt.pendingSpace() || !fmt.write(name)) {
                return false;
            }
            for (Expression bound : arrayBounds) {
                if (fmt.write('[') && (bound == null || bound.write(fmt)) && fmt.write(']')) continue;
                return false;
            }
            return true;
        }
    }

    private static enum BuiltInType {
        VOID("void", false, false),
        CHAR("char", false, true),
        SHORT("short", false, true),
        INT("int", false, true),
        LONG("long", false, true),
        LONGLONG("long long", false, true),
        UCHAR("unsigned char", true, true),
        USHORT("unsigned short", true, true),
        UINT("unsigned int", true, true),
        ULONG("unsigned long", true, true),
        ULONGLONG("unsigned long long", true, true),
        BOOL("bool", false, false),
        FLOAT("float", false, false),
        DOUBLE("double", false, false),
        LONGDOUBLE("long double", false, false);

        public final String literal;
        public final boolean unsigned;
        public final boolean integral;

        private BuiltInType(String literal, boolean unsigned, boolean integral) {
            this.literal = literal;
            this.unsigned = unsigned;
            this.integral = integral;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.literal);
        }
    }
}

