/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.TypesUtil;
import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.Dependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.TypeDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.AbstractFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.DeclarationBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Function;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.UserCode;
import org.eclipse.papyrusrt.codegen.utils.QualifiedNames;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.RTCppGenerationProperties;
import org.eclipse.papyrusrt.xtumlrt.common.AbstractAction;
import org.eclipse.papyrusrt.xtumlrt.common.ActionCode;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonPackage;
import org.eclipse.papyrusrt.xtumlrt.common.Generalization;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypedMultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.VisibilityKind;

public class BasicClassGenerator
extends AbstractCppGenerator {
    private final org.eclipse.papyrusrt.xtumlrt.common.Type element;

    public BasicClassGenerator(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.Type element) {
        super(cpp);
        this.element = element;
    }

    @Override
    public String getLabel() {
        return String.valueOf(super.getLabel()) + ' ' + this.element.getName();
    }

    private CppClass.Visibility getVisibility(VisibilityKind visibility) {
        switch (visibility) {
            case PUBLIC: {
                return CppClass.Visibility.PUBLIC;
            }
            case PROTECTED: {
                return CppClass.Visibility.PROTECTED;
            }
            case PRIVATE: {
                return CppClass.Visibility.PRIVATE;
            }
        }
        return null;
    }

    private Type getReturnType(Operation operation) {
        TypedMultiplicityElement returnTypedElement = operation.getReturnType();
        if (returnTypedElement == null) {
            return PrimitiveType.VOID;
        }
        org.eclipse.papyrusrt.xtumlrt.common.Type returnType = returnTypedElement.getType();
        if (returnType == null) {
            return PrimitiveType.VOID;
        }
        Type type = TypesUtil.createCppType(this.cpp, (NamedElement)operation, returnType);
        return type;
    }

    @Override
    public boolean generate() {
        if (!(this.element instanceof StructuredType)) {
            throw new RuntimeException("Element '" + QualifiedNames.cachedFullName((NamedElement)this.element) + "' is not a StructuredType (Class or Capsule)");
        }
        CppClass cls = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (NamedElement)this.element);
        this.generateBases(cls);
        return this.generate(cls);
    }

    protected boolean generate(CppClass cls) {
        if (this.element.eClass() == CommonPackage.eINSTANCE.getStructuredType()) {
            cls.setKind(CppClass.Kind.STRUCT);
        }
        this.generateAttributes(cls);
        this.generateOperations(cls);
        this.generateExtraDeclarations(cls);
        this.generateExtraDependencies();
        return true;
    }

    private boolean generateOperations(CppClass cls) {
        for (Operation operation : ((StructuredType)this.element).getOperations()) {
            this.generate(cls, operation);
        }
        return true;
    }

    private AbstractFunction generate(CppClass cls, Operation operation) {
        CppClass.Visibility cppVisibility = this.getVisibility(operation.getVisibility());
        if (cppVisibility == null) {
            return null;
        }
        Type returnType = this.getReturnType(operation);
        if (returnType == null) {
            throw new RuntimeException("could not determine return type for " + operation.toString());
        }
        MemberFunction function = null;
        RTCppGenerationProperties.OperationKind opKind = RTCppGenerationProperties.getOperationPropKind((CommonElement)operation);
        if (opKind == null) {
            function = this.generateMemberFunction(cls, operation, cppVisibility, returnType);
        } else {
            switch (opKind) {
                case MEMBER: {
                    function = this.generateMemberFunction(cls, operation, cppVisibility, returnType);
                    break;
                }
                case FRIEND: {
                    function = this.generateFriendFunction(cls, operation, returnType);
                    break;
                }
                case GLOBAL: {
                    function = this.generateGlobalFunction(operation, returnType);
                    break;
                }
                default: {
                    throw new RuntimeException("Operation '" + QualifiedNames.cachedFullName((NamedElement)operation) + "' has an unrecognized kind: '" + opKind.toString() + "'");
                }
            }
        }
        Boolean genDefBool = RTCppGenerationProperties.getOperationPropGenDef((CommonElement)operation);
        if (genDefBool != null && !genDefBool.booleanValue()) {
            function.setOnlyDecl();
        }
        return function;
    }

    private MemberFunction generateMemberFunction(CppClass cls, Operation operation, CppClass.Visibility cppVisibility, Type returnType) {
        boolean isVirtual;
        MemberFunction function = new MemberFunction(returnType, operation.getName());
        this.generateParameters(operation, (AbstractFunction)function);
        this.generateBody(operation, (AbstractFunction)function);
        Boolean isInlineBool = RTCppGenerationProperties.getOperationPropInline((CommonElement)operation);
        Boolean isVirtualBool = RTCppGenerationProperties.getOperationPropPolymorphic((CommonElement)operation);
        boolean isInline = isInlineBool != null && isInlineBool != false;
        boolean bl = isVirtual = isVirtualBool != null && isVirtualBool != false;
        if (isInline) {
            function.setInline();
        }
        if (operation.isStatic()) {
            cls.addStaticMember(cppVisibility, function);
        } else {
            if (isVirtual) {
                function.setVirtual();
            }
            cls.addMember(cppVisibility, function);
        }
        return function;
    }

    private Function generateFriendFunction(CppClass cls, Operation operation, Type returnType) {
        Function function = this.generateTopLevelFunction(operation, returnType);
        cls.addFriendFunction(function);
        return function;
    }

    private Function generateGlobalFunction(Operation operation, Type returnType) {
        Function function = this.generateTopLevelFunction(operation, returnType);
        ElementList elementList = this.getElementListOfElement((NamedElement)operation);
        if (elementList == null) {
            return function;
        }
        elementList.addElement(new IUserElement[]{function});
        return function;
    }

    private Function generateTopLevelFunction(Operation operation, Type returnType) {
        boolean isInline;
        LinkageSpec linkageSpec = operation.isStatic() ? LinkageSpec.STATIC : LinkageSpec.UNSPECIFIED;
        Function function = new Function(linkageSpec, returnType, operation.getName());
        this.generateParameters(operation, (AbstractFunction)function);
        this.generateBody(operation, (AbstractFunction)function);
        Boolean isInlineBool = RTCppGenerationProperties.getOperationPropInline((CommonElement)operation);
        boolean bl = isInline = isInlineBool != null && isInlineBool != false;
        if (isInline) {
            function.setInline();
        }
        return function;
    }

    private void generateParameters(Operation operation, AbstractFunction function) {
        for (Parameter param : operation.getParameters()) {
            switch (param.getDirection()) {
                case OUT: {
                    break;
                }
                case IN: {
                    Type type = TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType());
                    function.add(new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(type, param.getName()));
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled paramater direction for " + param.toString());
                }
            }
        }
    }

    private void generateBody(Operation operation, AbstractFunction function) {
        String source;
        ActionCode code;
        AbstractAction act = operation.getBody();
        ActionCode actionCode = code = act instanceof ActionCode ? (ActionCode)act : null;
        if (code != null && (source = code.getSource()) != null) {
            function.add(new Statement[]{new UserCode(source)});
        }
    }

    private boolean generateAttributes(CppClass cls) {
        for (Attribute attr : ((StructuredType)this.element).getAttributes()) {
            this.generate(cls, attr);
        }
        return true;
    }

    protected MemberField generate(CppClass cls, Attribute attr) {
        CppClass.Visibility cppVisibility = this.getVisibility(attr.getVisibility());
        if (cppVisibility == null) {
            return null;
        }
        Type type = null;
        org.eclipse.papyrusrt.xtumlrt.common.Type attrType = attr.getType();
        type = TypesUtil.createCppType(this.cpp, (NamedElement)attr, attrType);
        MemberField field = null;
        RTCppGenerationProperties.AttributeKind attrKind = RTCppGenerationProperties.getAttributePropKind((CommonElement)attr);
        if (attrKind == null) {
            field = this.generateMemberAttribute(cls, attr, cppVisibility, type, null);
        } else {
            switch (attrKind) {
                case MEMBER: 
                case MUTABLE_MEMBER: {
                    field = this.generateMemberAttribute(cls, attr, cppVisibility, type, attrKind);
                    break;
                }
                case GLOBAL: {
                    this.generateGlobalVariable(cls, attr, type);
                    break;
                }
                case DEFINE: {
                    CodeGenPlugin.warning((String)("Attribute '" + QualifiedNames.cachedFullName((NamedElement)attr) + "' has been declared with unsupported kind DEFINE"));
                    break;
                }
                default: {
                    throw new RuntimeException("Attribute '" + QualifiedNames.cachedFullName((NamedElement)attr) + "' has an unrecognized kind: '" + attrKind.toString() + "'");
                }
            }
        }
        return field;
    }

    private void generateGlobalVariable(CppClass cls, Attribute attr, Type type) {
        ElementList elementList = this.getElementListOfElement((NamedElement)attr);
        if (elementList == null) {
            return;
        }
        LinkageSpec linkageSpec = attr.isStatic() ? LinkageSpec.STATIC : LinkageSpec.UNSPECIFIED;
        Variable var = new Variable(linkageSpec, type, attr.getName());
        elementList.addElement(new IUserElement[]{var});
    }

    private MemberField generateMemberAttribute(CppClass cls, Attribute attr, CppClass.Visibility cppVisibility, Type type, RTCppGenerationProperties.AttributeKind attrKind) {
        MemberField field = null;
        field = attr.getDefault() == null || attr.getDefault().isEmpty() ? new MemberField(type, attr.getName()) : new MemberField(type, attr.getName(), (Expression)new ExpressionBlob(attr.getDefault()));
        if (attr.isStatic()) {
            cls.addStaticMember(cppVisibility, field);
        } else {
            if (!attr.isReadOnly() && attrKind == RTCppGenerationProperties.AttributeKind.MUTABLE_MEMBER) {
                field.setMutable();
            }
            cls.addMember(cppVisibility, field);
        }
        return field;
    }

    private void generateBases(CppClass cls) {
        StructuredType type = (StructuredType)this.element;
        EList generalizations = type.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                boolean isVirtual;
                StructuredType superType = generalization.getSuper();
                if (superType == null) continue;
                CppClass base = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (NamedElement)superType);
                Boolean isVirtualBool = RTCppGenerationProperties.getGeneralizationPropVirtual((CommonElement)generalization);
                boolean bl = isVirtual = isVirtualBool != null && isVirtualBool != false;
                if (isVirtual) {
                    cls.addVirtualBase(CppClass.Access.PUBLIC, (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)base);
                    continue;
                }
                cls.addBase(CppClass.Access.PUBLIC, (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)base);
            }
        }
    }

    private void generateExtraDependencies() {
        ElementList elementList = this.getElementList((StructuredType)this.element);
        EList dependencies = this.element.getDependencies();
        if (dependencies != null) {
            for (org.eclipse.papyrusrt.xtumlrt.common.Dependency dependency : dependencies) {
                RTCppGenerationProperties.DependencyKind depKindInHead = RTCppGenerationProperties.getDependencyPropKindInHeader((CommonElement)dependency);
                RTCppGenerationProperties.DependencyKind depKindInImpl = RTCppGenerationProperties.getDependencyPropKindInImplementation((CommonElement)dependency);
                NamedElement supplier = dependency.getSupplier();
                if (supplier == null) continue;
                Dependency cppDependencyInHead = null;
                Dependency cppDependencyInImpl = null;
                Element cppElement = this.cpp.getCppElement(supplier);
                if (cppElement == null) continue;
                cppDependencyInHead = this.getDependency(cppElement, supplier, depKindInHead);
                cppDependencyInImpl = this.getDependency(cppElement, supplier, depKindInImpl);
                if (cppDependencyInHead != null) {
                    elementList.addDeclDependency(cppDependencyInHead);
                }
                if (cppDependencyInImpl == null) continue;
                elementList.addDefnDependency(cppDependencyInImpl);
            }
        }
    }

    private Dependency getDependency(Element cppElement, NamedElement supplier, RTCppGenerationProperties.DependencyKind kind) {
        if (kind == null) {
            return null;
        }
        Object cppDependency = null;
        cppDependency = supplier instanceof org.eclipse.papyrusrt.xtumlrt.common.Type ? new TypeDependency(cppElement.getType()) : new ElementDependency(cppElement);
        switch (kind) {
            case FORWARD_REFERENCE: {
                cppDependency.setKind(Dependency.Kind.Reference);
                break;
            }
            case INCLUSION: {
                cppDependency.setKind(Dependency.Kind.Use);
                break;
            }
            default: {
                cppDependency.setKind(Dependency.Kind.None);
            }
        }
        return cppDependency;
    }

    private void generateExtraDeclarations(CppClass cls) {
        String privDecl = RTCppGenerationProperties.getClassPropPrivateDeclarations((CommonElement)this.element);
        String protDecl = RTCppGenerationProperties.getClassPropProtectedDeclarations((CommonElement)this.element);
        String publDecl = RTCppGenerationProperties.getClassPropPublicDeclarations((CommonElement)this.element);
        if (privDecl != null && !privDecl.trim().isEmpty()) {
            cls.addDeclarationBlob(CppClass.Visibility.PRIVATE, new DeclarationBlob(privDecl));
        }
        if (protDecl != null && !protDecl.trim().isEmpty()) {
            cls.addDeclarationBlob(CppClass.Visibility.PROTECTED, new DeclarationBlob(protDecl));
        }
        if (publDecl != null && !publDecl.trim().isEmpty()) {
            cls.addDeclarationBlob(CppClass.Visibility.PUBLIC, new DeclarationBlob(publDecl));
        }
    }

    private ElementList getElementListOfElement(NamedElement element) {
        NamedElement owner = XTUMLRTUtil.getOwner((CommonElement)element);
        if (owner == null || !(owner instanceof StructuredType)) {
            return null;
        }
        StructuredType structuredType = (StructuredType)owner;
        return this.getElementList(structuredType);
    }

    protected ElementList getElementList(StructuredType structuredType) {
        return this.cpp.getElementList(CppCodePattern.Output.BasicClass, (NamedElement)structuredType);
    }
}

