/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.umlrt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PortRegistration implements Enumerator
{
    AUTOMATIC(0, "AUTOMATIC", "AUTOMATIC"),
    APPLICATION(1, "APPLICATION", "APPLICATION"),
    APPLICATIONLOCKED(2, "APPLICATIONLOCKED", "APPLICATIONLOCKED");

    public static final int AUTOMATIC_VALUE = 0;
    public static final int APPLICATION_VALUE = 1;
    public static final int APPLICATIONLOCKED_VALUE = 2;
    private static final PortRegistration[] VALUES_ARRAY;
    public static final List<PortRegistration> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortRegistration[]{AUTOMATIC, APPLICATION, APPLICATIONLOCKED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortRegistration get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortRegistration result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortRegistration getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortRegistration result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortRegistration get(int value) {
        switch (value) {
            case 0: {
                return AUTOMATIC;
            }
            case 1: {
                return APPLICATION;
            }
            case 2: {
                return APPLICATIONLOCKED;
            }
        }
        return null;
    }

    private PortRegistration(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

