
#include "PingPongProtocol.hh"

#include "DataType1.hh"
#include "umlrtoutsignal.hh"
#include <string.h>
struct UMLRTCommsPort;

PingPongProtocol::Conj::Conj( const UMLRTCommsPort * & srcPort )
: UMLRTProtocol( srcPort )
{
}

UMLRTOutSignal PingPongProtocol::Conj::pong( const DataType1 (& param)[2] ) const
{
    UMLRTOutSignal signal;
    signal.initialize( signal_pong, srcPort, RTType_DataType1->sizeDecoded*2 );
    signal.encode( RTType_DataType1, &param, 2 );
    return signal;
}

PingPongProtocol::Base::Base( const UMLRTCommsPort * & srcPort )
: UMLRTProtocol( srcPort )
{
}

UMLRTOutSignal PingPongProtocol::Base::ping( const DataType1 (& param)[2]) const
{
    UMLRTOutSignal signal;
    signal.initialize( signal_ping, srcPort, RTType_DataType1->sizeDecoded*2 );
    signal.encode( RTType_DataType1, &param, 2 );
    return signal;
}


