/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratableElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class MemberField
extends NamedElement
implements IGeneratable,
IGeneratableElement {
    private final Type type;
    private final Expression initializer;
    private boolean isMutable = false;

    public MemberField(Type type, String ident) {
        this(type, ident, null);
    }

    public MemberField(Type type, String ident, Expression initializer) {
        super(ident);
        this.type = type;
        this.initializer = initializer;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.type.addDependencies(deps);
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        return this.addDependencies(deps.decl());
    }

    public void setMutable() {
        this.isMutable = true;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!(!this.isMutable || fmt.write("mutable") && fmt.space())) {
            return false;
        }
        return this.type.write(fmt, this.getName()) && fmt.terminate();
    }

    @Override
    public boolean write(CppWriter out) {
        return this.write(out.decl());
    }
}

