/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.internal;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.codegen.papyrus.UMLRTGenerator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;

public class UMLRTCppCodeGen
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        ArrayList<EObject> targets = new ArrayList<EObject>();
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection.isEmpty()) {
            return null;
        }
        EObject eobj = EMFHelper.getEObject((Object)selection.getFirstElement());
        if (eobj == null || !(eobj instanceof Element)) {
            return null;
        }
        Element element = (Element)eobj;
        String topCapsuleName = this.getTopCapsuleName(element.getModel());
        targets.add((EObject)element.getModel());
        final IStatus status = UMLRTGenerator.generate(targets, topCapsuleName);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"UML-RT Code Generator", null, (IStatus)status);
            }
        });
        return null;
    }

    private String getTopCapsuleName(Model model) {
        String retVal = null;
        EAnnotation anno = model.getEAnnotation("UMLRT_Default_top");
        if (anno != null) {
            retVal = (String)anno.getDetails().get((Object)"top_name");
        }
        return retVal != null ? retVal : "Top";
    }
}

