/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.xtumlrt.common.ActionChain;
import org.eclipse.papyrusrt.xtumlrt.common.ActionCode;
import org.eclipse.papyrusrt.xtumlrt.common.ChoicePoint;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CompositeState;
import org.eclipse.papyrusrt.xtumlrt.common.DeepHistory;
import org.eclipse.papyrusrt.xtumlrt.common.EntryPoint;
import org.eclipse.papyrusrt.xtumlrt.common.ExitPoint;
import org.eclipse.papyrusrt.xtumlrt.common.Guard;
import org.eclipse.papyrusrt.xtumlrt.common.InitialPoint;
import org.eclipse.papyrusrt.xtumlrt.common.JunctionPoint;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Pseudostate;
import org.eclipse.papyrusrt.xtumlrt.common.State;
import org.eclipse.papyrusrt.xtumlrt.common.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.common.Transition;
import org.eclipse.papyrusrt.xtumlrt.common.Trigger;
import org.eclipse.papyrusrt.xtumlrt.common.Vertex;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pair;

public class XTUMLRTStateMachineUtil {
    private static final XTUMLRTStateMachineUtil INSTANCE = new XTUMLRTStateMachineUtil();
    private final HashMap<ArrayList<?>, Integer> _createCache_getCachedDepthOf = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public static void addChoicePoint(CompositeState state, ChoicePoint point) {
        EList _choicePoints = state.getChoicePoints();
        _choicePoints.add((Object)point);
    }

    public static void addEntryPoint(State state, EntryPoint point) {
        EList _entryPoints = state.getEntryPoints();
        _entryPoints.add((Object)point);
    }

    public static void addExitPoint(State state, ExitPoint point) {
        EList _exitPoints = state.getExitPoints();
        _exitPoints.add((Object)point);
    }

    public static void addFirstAction(ActionChain chain, ActionCode action) {
        EList _actions = chain.getActions();
        _actions.add(0, (Object)action);
    }

    public static void addJunctionPoint(CompositeState state, JunctionPoint point) {
        EList _junctionPoints = state.getJunctionPoints();
        _junctionPoints.add((Object)point);
    }

    public static void addLastAction(ActionChain chain, ActionCode action) {
        EList _actions = chain.getActions();
        _actions.add((Object)action);
    }

    public static void addSubstate(CompositeState state, State s) {
        EList _substates = state.getSubstates();
        _substates.add((Object)s);
    }

    public static void addTransition(CompositeState state, Transition t) {
        EList _transitions = state.getTransitions();
        _transitions.add((Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCachedDepthOf(NamedElement element) {
        int _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new NamedElement[]{element});
        HashMap<ArrayList<?>, Integer> hashMap = this._createCache_getCachedDepthOf;
        synchronized (hashMap) {
            if (this._createCache_getCachedDepthOf.containsKey(_cacheKey)) {
                return this._createCache_getCachedDepthOf.get(_cacheKey);
            }
            int _xifexpression = 0;
            if (element == null) {
                _xifexpression = 0;
            } else {
                boolean _not;
                int _xifexpression_1 = 0;
                boolean _isStateMachineElement = XTUMLRTStateMachineUtil.isStateMachineElement(element);
                boolean bl = _not = !_isStateMachineElement;
                if (_not) {
                    _xifexpression_1 = -1;
                } else {
                    State _ownerState = XTUMLRTStateMachineUtil.getOwnerState(element);
                    int _cachedDepthOf = this.getCachedDepthOf((NamedElement)_ownerState);
                    _xifexpression_1 = _cachedDepthOf + 1;
                }
                _xifexpression = _xifexpression_1;
            }
            _result = _xifexpression;
            this._createCache_getCachedDepthOf.put(_cacheKey, _result);
        }
        this._init_getCachedDepthOf(_result, element);
        return _result;
    }

    private void _init_getCachedDepthOf(int it, NamedElement element) {
    }

    public static int getCachedDepth(NamedElement element) {
        return INSTANCE.getCachedDepthOf(element);
    }

    public static Iterable<Pseudostate> getConnectionPoints(State state) {
        ArrayList _xblockexpression = null;
        ArrayList connectionPoints = CollectionLiterals.newArrayList((Object[])new Pseudostate[0]);
        EList _entryPoints = state.getEntryPoints();
        connectionPoints.addAll(_entryPoints);
        EList _exitPoints = state.getExitPoints();
        connectionPoints.addAll(_exitPoints);
        _xblockexpression = connectionPoints;
        return _xblockexpression;
    }

    public static int getDepth(NamedElement element) {
        boolean _isStateMachineElement;
        boolean _not;
        int _xifexpression = 0;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)element, null);
        _or = _equals ? true : (_not = !(_isStateMachineElement = XTUMLRTStateMachineUtil.isStateMachineElement(element)));
        if (_or) {
            _xifexpression = 0;
        } else {
            State _ownerState = XTUMLRTStateMachineUtil.getOwnerState(element);
            int _depth = XTUMLRTStateMachineUtil.getDepth((NamedElement)_ownerState);
            _xifexpression = _depth + 1;
        }
        return _xifexpression;
    }

    protected static Iterable<Transition> _getDirectIncomingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State _ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)state);
        CompositeState owner = (CompositeState)_ownerState;
        if (owner != null) {
            EList _transitions = owner.getTransitions();
            for (Transition t : _transitions) {
                Vertex _targetVertex = t.getTargetVertex();
                boolean _equals = Objects.equal((Object)_targetVertex, (Object)state);
                if (!_equals) continue;
                transitions.add(t);
            }
        }
        if (state instanceof CompositeState) {
            EList _transitions_1 = ((CompositeState)state).getTransitions();
            for (Transition t_1 : _transitions_1) {
                Vertex _targetVertex_1 = t_1.getTargetVertex();
                boolean _equals_1 = Objects.equal((Object)_targetVertex_1, (Object)state);
                if (!_equals_1) continue;
                transitions.add(t_1);
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    protected static Iterable<Transition> _getDirectIncomingTransitions(Pseudostate pseudostate) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State _ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)pseudostate);
        CompositeState owner = (CompositeState)_ownerState;
        if (owner != null) {
            State _ownerState_1;
            CompositeState ownersOwner;
            if (owner instanceof CompositeState) {
                EList _transitions = owner.getTransitions();
                for (Transition t : _transitions) {
                    Vertex _targetVertex = t.getTargetVertex();
                    boolean _equals = Objects.equal((Object)_targetVertex, (Object)pseudostate);
                    if (!_equals) continue;
                    transitions.add(t);
                }
            }
            boolean _or = false;
            boolean _isConnectionPoint = XTUMLRTStateMachineUtil.isConnectionPoint((NamedElement)pseudostate);
            _or = _isConnectionPoint ? true : pseudostate instanceof DeepHistory;
            if (_or && (ownersOwner = (CompositeState)(_ownerState_1 = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)owner))) != null) {
                EList _transitions_1 = ownersOwner.getTransitions();
                for (Transition t_1 : _transitions_1) {
                    Vertex _targetVertex_1 = t_1.getTargetVertex();
                    boolean _equals_1 = Objects.equal((Object)_targetVertex_1, (Object)pseudostate);
                    if (!_equals_1) continue;
                    transitions.add(t_1);
                }
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    protected static Iterable<Transition> _getDirectOutgoingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State _ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)state);
        CompositeState owner = (CompositeState)_ownerState;
        if (owner != null) {
            EList _transitions = owner.getTransitions();
            for (Transition t : _transitions) {
                Vertex _sourceVertex = t.getSourceVertex();
                boolean _equals = Objects.equal((Object)_sourceVertex, (Object)state);
                if (!_equals) continue;
                transitions.add(t);
            }
        }
        if (state instanceof CompositeState) {
            EList _transitions_1 = ((CompositeState)state).getTransitions();
            for (Transition t_1 : _transitions_1) {
                Vertex _sourceVertex_1 = t_1.getSourceVertex();
                boolean _equals_1 = Objects.equal((Object)_sourceVertex_1, (Object)state);
                if (!_equals_1) continue;
                transitions.add(t_1);
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    protected static Iterable<Transition> _getDirectOutgoingTransitions(Pseudostate pseudostate) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State _ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)pseudostate);
        CompositeState owner = (CompositeState)_ownerState;
        if (owner != null) {
            State _ownerState_1;
            CompositeState ownersOwner;
            boolean _isConnectionPoint;
            if (owner instanceof CompositeState) {
                EList _transitions = owner.getTransitions();
                for (Transition t : _transitions) {
                    Vertex _sourceVertex = t.getSourceVertex();
                    boolean _equals = Objects.equal((Object)_sourceVertex, (Object)pseudostate);
                    if (!_equals) continue;
                    transitions.add(t);
                }
            }
            if ((_isConnectionPoint = XTUMLRTStateMachineUtil.isConnectionPoint((NamedElement)pseudostate)) && (ownersOwner = (CompositeState)(_ownerState_1 = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)owner))) != null) {
                EList _transitions_1 = ownersOwner.getTransitions();
                for (Transition t_1 : _transitions_1) {
                    Vertex _sourceVertex_1 = t_1.getSourceVertex();
                    boolean _equals_1 = Objects.equal((Object)_sourceVertex_1, (Object)pseudostate);
                    if (!_equals_1) continue;
                    transitions.add(t_1);
                }
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Iterable<Transition> getIndirectIncomingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        Iterable<Pseudostate> _connectionPoints = XTUMLRTStateMachineUtil.getConnectionPoints(state);
        for (Pseudostate p : _connectionPoints) {
            Iterable<Transition> _directIncomingTransitions = XTUMLRTStateMachineUtil.getDirectIncomingTransitions((Vertex)p);
            Iterables.addAll((Collection)transitions, _directIncomingTransitions);
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Iterable<Transition> getIndirectOutgoingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        Iterable<Pseudostate> _connectionPoints = XTUMLRTStateMachineUtil.getConnectionPoints(state);
        for (Pseudostate p : _connectionPoints) {
            Iterable<Transition> _directOutgoingTransitions = XTUMLRTStateMachineUtil.getDirectOutgoingTransitions((Vertex)p);
            Iterables.addAll((Collection)transitions, _directOutgoingTransitions);
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Iterable<Pseudostate> getInnerPseudostates(CompositeState state) {
        ArrayList _xblockexpression = null;
        ArrayList pseudostates = CollectionLiterals.newArrayList((Object[])new Pseudostate[0]);
        if (state != null) {
            InitialPoint _initial = state.getInitial();
            pseudostates.add(_initial);
            DeepHistory _deepHistory = state.getDeepHistory();
            pseudostates.add(_deepHistory);
            EList _choicePoints = state.getChoicePoints();
            pseudostates.addAll(_choicePoints);
            EList _junctionPoints = state.getJunctionPoints();
            pseudostates.addAll(_junctionPoints);
        }
        _xblockexpression = pseudostates;
        return _xblockexpression;
    }

    protected static State _getOwnerState(Trigger trigger) {
        NamedElement _owner_1;
        NamedElement _owner_2;
        boolean _notEquals;
        NamedElement _owner;
        boolean _tripleNotEquals;
        State _xifexpression = null;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = trigger == null ? false : (_tripleNotEquals = (_owner = XTUMLRTUtil.getOwner((CommonElement)trigger)) != null);
        _and_1 = !_and_2 ? false : (_notEquals = !Objects.equal((Object)(_owner_2 = XTUMLRTUtil.getOwner((CommonElement)(_owner_1 = XTUMLRTUtil.getOwner((CommonElement)trigger)))), null));
        if (!_and_1) {
            _and = false;
        } else {
            NamedElement _owner_3 = XTUMLRTUtil.getOwner((CommonElement)trigger);
            NamedElement _owner_4 = XTUMLRTUtil.getOwner((CommonElement)_owner_3);
            _and = _owner_4 instanceof State;
        }
        if (_and) {
            NamedElement _owner_5 = XTUMLRTUtil.getOwner((CommonElement)trigger);
            NamedElement _owner_6 = XTUMLRTUtil.getOwner((CommonElement)_owner_5);
            _xifexpression = (State)_owner_6;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(Guard guard) {
        NamedElement _owner_1;
        NamedElement _owner_2;
        boolean _notEquals;
        NamedElement _owner;
        boolean _tripleNotEquals;
        State _xifexpression = null;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = guard == null ? false : (_tripleNotEquals = (_owner = XTUMLRTUtil.getOwner((CommonElement)guard)) != null);
        _and_1 = !_and_2 ? false : (_notEquals = !Objects.equal((Object)(_owner_2 = XTUMLRTUtil.getOwner((CommonElement)(_owner_1 = XTUMLRTUtil.getOwner((CommonElement)guard)))), null));
        if (!_and_1) {
            _and = false;
        } else {
            NamedElement _owner_3 = XTUMLRTUtil.getOwner((CommonElement)guard);
            NamedElement _owner_4 = XTUMLRTUtil.getOwner((CommonElement)_owner_3);
            _and = _owner_4 instanceof State;
        }
        if (_and) {
            NamedElement _owner_5 = XTUMLRTUtil.getOwner((CommonElement)guard);
            NamedElement _owner_6 = XTUMLRTUtil.getOwner((CommonElement)_owner_5);
            _xifexpression = (State)_owner_6;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(ActionChain actionChain) {
        NamedElement _owner_1;
        NamedElement _owner_2;
        boolean _notEquals;
        NamedElement _owner;
        boolean _tripleNotEquals;
        State _xifexpression = null;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = actionChain == null ? false : (_tripleNotEquals = (_owner = XTUMLRTUtil.getOwner((CommonElement)actionChain)) != null);
        _and_1 = !_and_2 ? false : (_notEquals = !Objects.equal((Object)(_owner_2 = XTUMLRTUtil.getOwner((CommonElement)(_owner_1 = XTUMLRTUtil.getOwner((CommonElement)actionChain)))), null));
        if (!_and_1) {
            _and = false;
        } else {
            NamedElement _owner_3 = XTUMLRTUtil.getOwner((CommonElement)actionChain);
            NamedElement _owner_4 = XTUMLRTUtil.getOwner((CommonElement)_owner_3);
            _and = _owner_4 instanceof State;
        }
        if (_and) {
            NamedElement _owner_5 = XTUMLRTUtil.getOwner((CommonElement)actionChain);
            NamedElement _owner_6 = XTUMLRTUtil.getOwner((CommonElement)_owner_5);
            _xifexpression = (State)_owner_6;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(Vertex v) {
        NamedElement _owner;
        boolean _tripleNotEquals;
        State _xifexpression = null;
        boolean _and = false;
        boolean _and_1 = false;
        _and_1 = v == null ? false : (_tripleNotEquals = (_owner = XTUMLRTUtil.getOwner((CommonElement)v)) != null);
        if (!_and_1) {
            _and = false;
        } else {
            NamedElement _owner_1 = XTUMLRTUtil.getOwner((CommonElement)v);
            _and = _owner_1 instanceof State;
        }
        if (_and) {
            NamedElement _owner_2 = XTUMLRTUtil.getOwner((CommonElement)v);
            _xifexpression = (State)_owner_2;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static CompositeState _getOwnerState(Transition t) {
        NamedElement _owner;
        boolean _tripleNotEquals;
        CompositeState _xifexpression = null;
        boolean _and = false;
        boolean _and_1 = false;
        _and_1 = t == null ? false : (_tripleNotEquals = (_owner = XTUMLRTUtil.getOwner((CommonElement)t)) != null);
        if (!_and_1) {
            _and = false;
        } else {
            NamedElement _owner_1 = XTUMLRTUtil.getOwner((CommonElement)t);
            _and = _owner_1 instanceof CompositeState;
        }
        if (_and) {
            NamedElement _owner_2 = XTUMLRTUtil.getOwner((CommonElement)t);
            _xifexpression = (CompositeState)_owner_2;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public static Iterable<Pseudostate> getPseudostates(CompositeState state) {
        ArrayList _xblockexpression = null;
        ArrayList pseudostates = CollectionLiterals.newArrayList((Object[])new Pseudostate[0]);
        if (state != null) {
            Iterable<Pseudostate> _innerPseudostates = XTUMLRTStateMachineUtil.getInnerPseudostates(state);
            Iterables.addAll((Collection)pseudostates, _innerPseudostates);
            Iterable<Pseudostate> _connectionPoints = XTUMLRTStateMachineUtil.getConnectionPoints((State)state);
            Iterables.addAll((Collection)pseudostates, _connectionPoints);
        }
        _xblockexpression = pseudostates;
        return _xblockexpression;
    }

    public static State getSourceState(Transition transition) {
        State _xblockexpression = null;
        Vertex v = transition.getSourceVertex();
        State _xifexpression = null;
        if (v == null) {
            _xifexpression = null;
        } else {
            State _xifexpression_1 = null;
            _xifexpression_1 = v instanceof State ? (State)v : XTUMLRTStateMachineUtil.getOwnerState((NamedElement)v);
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static State getTargetState(Transition transition) {
        State _xblockexpression = null;
        Vertex v = transition.getTargetVertex();
        State _xifexpression = null;
        if (v == null) {
            _xifexpression = null;
        } else {
            State _xifexpression_1 = null;
            _xifexpression_1 = v instanceof State ? (State)v : XTUMLRTStateMachineUtil.getOwnerState((NamedElement)v);
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static boolean hasDeepHistory(CompositeState state) {
        DeepHistory _deepHistory;
        boolean _tripleNotEquals;
        boolean _and = false;
        _and = state == null ? false : (_tripleNotEquals = (_deepHistory = state.getDeepHistory()) != null);
        return _and;
    }

    public static boolean hasInitial(CompositeState state) {
        InitialPoint _initial;
        boolean _tripleNotEquals;
        boolean _and = false;
        _and = state == null ? false : (_tripleNotEquals = (_initial = state.getInitial()) != null);
        return _and;
    }

    public static boolean isConnectionPoint(NamedElement element) {
        boolean _or = false;
        _or = element instanceof EntryPoint ? true : element instanceof ExitPoint;
        return _or;
    }

    public static boolean isStateMachineElement(NamedElement element) {
        boolean _or = false;
        _or = element instanceof Vertex || element instanceof Transition || element instanceof ActionChain || element instanceof ActionCode || element instanceof Trigger ? true : element instanceof Guard;
        return _or;
    }

    public static void removeChoicePoint(CompositeState state, ChoicePoint choicePoint) {
        EList _choicePoints = state.getChoicePoints();
        _choicePoints.remove((Object)choicePoint);
    }

    protected static void _removeConnectionPoint(State state, EntryPoint connectionPoint) {
        EList _entryPoints = state.getEntryPoints();
        _entryPoints.remove((Object)connectionPoint);
    }

    protected static void _removeConnectionPoint(State state, ExitPoint connectionPoint) {
        EList _exitPoints = state.getExitPoints();
        _exitPoints.remove((Object)connectionPoint);
    }

    public static void removeDeepHistory(CompositeState state) {
        state.setDeepHistory(null);
    }

    public static void removeEntryPoint(State state, EntryPoint point) {
        EList _entryPoints = state.getEntryPoints();
        _entryPoints.remove((Object)point);
    }

    public static void removeExitPoint(State state, ExitPoint point) {
        EList _exitPoints = state.getExitPoints();
        _exitPoints.remove((Object)point);
    }

    public static void removeGuard(Transition transition) {
        transition.setGuard(null);
    }

    public static void removeInitial(CompositeState state) {
        state.setInitial(null);
    }

    public static void removeJunctionPoint(CompositeState state, JunctionPoint junctionPoint) {
        EList _junctionPoints = state.getJunctionPoints();
        _junctionPoints.remove((Object)junctionPoint);
    }

    public static void removeTransition(CompositeState state, Transition transition) {
        EList _transitions = state.getTransitions();
        _transitions.remove((Object)transition);
    }

    public static void removeTriggers(Transition transition) {
        Trigger[] _clone;
        EList _triggers = transition.getTriggers();
        Trigger[] triggerArray = _clone = (Trigger[])((Trigger[])Conversions.unwrapArray((Object)_triggers, Trigger.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            EList _triggers_1 = transition.getTriggers();
            _triggers_1.remove((Object)trigger);
            ++n2;
        }
    }

    public static void removeSubstate(CompositeState state, State subState) {
        EList _substates = state.getSubstates();
        _substates.remove((Object)subState);
    }

    public static void removeState(StateMachine stateMachine, State subState) {
        CompositeState _top = stateMachine.getTop();
        XTUMLRTStateMachineUtil.removeSubstate(_top, subState);
    }

    protected static void _removePseudostate(CompositeState state, ChoicePoint pseudostate) {
        XTUMLRTStateMachineUtil.removeChoicePoint(state, pseudostate);
    }

    protected static void _removePseudostate(CompositeState state, DeepHistory pseudostate) {
        XTUMLRTStateMachineUtil.removeDeepHistory(state);
    }

    protected static void _removePseudostate(CompositeState state, EntryPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeEntryPoint((State)state, pseudostate);
    }

    protected static void _removePseudostate(CompositeState state, ExitPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeExitPoint((State)state, pseudostate);
    }

    protected static void _removePseudostate(CompositeState state, InitialPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeInitial(state);
    }

    protected static void _removePseudostate(CompositeState state, JunctionPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeJunctionPoint(state, pseudostate);
    }

    public static Iterable<Transition> getDirectIncomingTransitions(Vertex pseudostate) {
        if (pseudostate instanceof Pseudostate) {
            return XTUMLRTStateMachineUtil._getDirectIncomingTransitions((Pseudostate)pseudostate);
        }
        if (pseudostate instanceof State) {
            return XTUMLRTStateMachineUtil._getDirectIncomingTransitions((State)pseudostate);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pseudostate).toString());
    }

    public static Iterable<Transition> getDirectOutgoingTransitions(Vertex pseudostate) {
        if (pseudostate instanceof Pseudostate) {
            return XTUMLRTStateMachineUtil._getDirectOutgoingTransitions((Pseudostate)pseudostate);
        }
        if (pseudostate instanceof State) {
            return XTUMLRTStateMachineUtil._getDirectOutgoingTransitions((State)pseudostate);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pseudostate).toString());
    }

    public static State getOwnerState(NamedElement t) {
        if (t instanceof Transition) {
            return XTUMLRTStateMachineUtil._getOwnerState((Transition)t);
        }
        if (t instanceof ActionChain) {
            return XTUMLRTStateMachineUtil._getOwnerState((ActionChain)t);
        }
        if (t instanceof Guard) {
            return XTUMLRTStateMachineUtil._getOwnerState((Guard)t);
        }
        if (t instanceof Trigger) {
            return XTUMLRTStateMachineUtil._getOwnerState((Trigger)t);
        }
        if (t instanceof Vertex) {
            return XTUMLRTStateMachineUtil._getOwnerState((Vertex)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    public static void removeConnectionPoint(State state, Pseudostate connectionPoint) {
        if (connectionPoint instanceof EntryPoint) {
            XTUMLRTStateMachineUtil._removeConnectionPoint(state, (EntryPoint)connectionPoint);
            return;
        }
        if (connectionPoint instanceof ExitPoint) {
            XTUMLRTStateMachineUtil._removeConnectionPoint(state, (ExitPoint)connectionPoint);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(state, connectionPoint).toString());
    }

    public static void removePseudostate(CompositeState state, Pseudostate pseudostate) {
        if (pseudostate instanceof ChoicePoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (ChoicePoint)pseudostate);
            return;
        }
        if (pseudostate instanceof DeepHistory) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (DeepHistory)pseudostate);
            return;
        }
        if (pseudostate instanceof EntryPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (EntryPoint)pseudostate);
            return;
        }
        if (pseudostate instanceof ExitPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (ExitPoint)pseudostate);
            return;
        }
        if (pseudostate instanceof InitialPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (InitialPoint)pseudostate);
            return;
        }
        if (pseudostate instanceof JunctionPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (JunctionPoint)pseudostate);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(state, pseudostate).toString());
    }
}

