/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;

public class PluginFinder {
    private final Map<PluginData, Boolean> requiredMappings;
    private final Map<PluginData, String> resolvedMappings = new HashMap<PluginData, String>();
    private static List<String> searchPaths = new ArrayList<String>();

    public PluginFinder(String ... requiredProjects) {
        this.requiredMappings = new HashMap<PluginData, Boolean>();
        String[] stringArray = requiredProjects;
        int n = requiredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredProject = stringArray[n2];
            this.addRequiredProject(requiredProject);
            ++n2;
        }
    }

    public void addRequiredPlugin(String name) {
        this.addRequiredPlugin(name, null);
    }

    public void addRequiredPlugin(String name, String version) {
        if (!this.resolvedMappings.isEmpty()) {
            throw new IllegalStateException("Cannot addRequiredProject to PluginFinder after resolve()");
        }
        if (name != null) {
            this.requiredMappings.put(new PluginData(name, version), Boolean.FALSE);
        }
    }

    public void addRequiredProject(String name) {
        this.addRequiredPlugin(name, null);
    }

    public static void addSearchPath(Path path) {
        if (path == null) {
            return;
        }
        String pathStr = path.toAbsolutePath().toString();
        if (!searchPaths.contains(pathStr)) {
            searchPaths.add(pathStr);
        }
    }

    public static void addSearchPaths(String paths) {
        String[] entries;
        String separator = System.getProperty("path.separator");
        String[] stringArray = entries = paths.split(separator);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            PluginFinder.addSearchPath(Paths.get(entry, new String[0]));
            ++n2;
        }
    }

    public boolean allFound() {
        for (Boolean b : this.requiredMappings.values()) {
            if (b.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String get(String pluginId) {
        String latestVersion = null;
        String resolvedPath = null;
        for (Map.Entry<PluginData, String> mapping : this.resolvedMappings.entrySet()) {
            PluginData found = mapping.getKey();
            String path = mapping.getValue();
            if (!found.name.equals(pluginId)) continue;
            if (found.version == null) {
                return path;
            }
            if (latestVersion != null && found.version.compareTo(latestVersion) <= 0) continue;
            latestVersion = found.version;
            resolvedPath = path;
        }
        return resolvedPath;
    }

    public String get(String pluginId, String version) {
        PluginData plugin = new PluginData(pluginId, version);
        return this.resolvedMappings.get(plugin);
    }

    private Path getManifestPath(File file) {
        Path path = file.toPath();
        if (path == null || path.toString().endsWith(".jar")) {
            return null;
        }
        Path mfpath = path.resolve("META-INF").resolve("MANIFEST.MF");
        return mfpath;
    }

    private String getSymbolicName(Manifest manifest) {
        int indexOf;
        String name;
        if (manifest != null && (name = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null && (indexOf = name.indexOf(59)) > 0) {
            return name.substring(0, indexOf);
        }
        return null;
    }

    private String getVersion(Manifest manifest) {
        if (manifest != null) {
            return manifest.getMainAttributes().getValue("Bundle-Version");
        }
        return null;
    }

    private boolean isJarBundle(File file) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        Path path = file.toPath();
        return path != null && path.toString().endsWith(".jar");
    }

    private boolean isNonJarBundle(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        Path path = this.getManifestPath(file);
        return path != null && Files.exists(path, new LinkOption[0]);
    }

    private boolean isRequired(PluginData plugin) {
        for (PluginData required : this.requiredMappings.keySet()) {
            if (!required.name.equals(plugin.name) || required.version != null && !required.version.equals(plugin.version)) continue;
            return true;
        }
        return false;
    }

    private boolean registerFromManifest(File f, Manifest manifest, String type) {
        if (manifest != null) {
            String name = this.getSymbolicName(manifest);
            if (name == null) {
                return false;
            }
            String version = this.getVersion(manifest);
            PluginData plugin = new PluginData(name, version);
            if (this.isRequired(plugin)) {
                String uri = String.valueOf(type) + (!type.equals("") ? ":" : "") + f.toURI() + (type.equals("jar") ? "!/" : "");
                this.resolvedMappings.put(plugin, uri);
                this.requiredMappings.put(plugin, Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    private boolean registerJarBundle(File f) throws IOException {
        try (JarFile jarFile = new JarFile(f);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = this.registerFromManifest(f, manifest, "jar");
            return bl;
        }
    }

    private boolean registerNonJarBundle(File file) throws IOException {
        Path path = this.getManifestPath(file);
        if (path != null) {
            try (FileInputStream fis = null;){
                fis = new FileInputStream(path.toAbsolutePath().toString());
                Manifest manifest = new Manifest(fis);
                boolean bl = this.registerFromManifest(file, manifest, "");
                return bl;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean registerProject(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void resolve() {
        String property = System.getProperty("java.class.path");
        if (property == null) {
            return;
        }
        String separator = System.getProperty("path.separator");
        String[] cpEntries = property.split(separator);
        ArrayList<String> entries = new ArrayList<String>();
        entries.addAll(searchPaths);
        entries.addAll(Arrays.asList(cpEntries));
        for (String entry : entries) {
            File fileEntry = new File(entry);
            try {
                File f = fileEntry.getCanonicalFile();
                if (!f.exists()) continue;
                if (this.isJarBundle(f)) {
                    this.registerJarBundle(f);
                } else if (this.isNonJarBundle(f)) {
                    this.registerNonJarBundle(f);
                } else if (f.isDirectory()) {
                    this.scanFolder(f, new HashSet<String>(), 0);
                } else {
                    File parentFile = f.getParentFile();
                    File dotProject = new File(parentFile, ".project");
                    if (dotProject.exists()) {
                        this.registerProject(dotProject);
                    }
                }
                if (!this.allFound()) continue;
                break;
            }
            catch (Exception exception) {}
        }
    }

    private boolean scanFolder(File f, Set<String> alreadyVisited, int depth) throws IOException {
        if (!alreadyVisited.add(f.getCanonicalPath())) {
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists()) {
                    if (this.isJarBundle(file)) {
                        this.registerJarBundle(file);
                    } else if (this.isNonJarBundle(file)) {
                        this.registerNonJarBundle(file);
                    } else if (".project".equals(file.getName())) {
                        dotProject = file;
                    } else if (file.isDirectory() && depth < 2 && !file.getName().startsWith(".")) {
                        containsProject |= this.scanFolder(file, alreadyVisited, depth + 1);
                    }
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }

    public void logResolvedMappings() {
        CodeGenPlugin.info((String)"resolved mapping start");
        for (Map.Entry<PluginData, String> entry : this.resolvedMappings.entrySet()) {
            CodeGenPlugin.info((String)(entry.getKey() + " |-> " + entry.getValue()));
        }
        CodeGenPlugin.info((String)"resolved mapping end");
    }

    static String indent(int n) {
        StringBuilder r = new StringBuilder();
        int i = 0;
        while (i < n) {
            r.append(' ');
            ++i;
        }
        return r.toString();
    }

    private static class PluginData {
        public String name;
        public String version;

        public PluginData(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof PluginData)) {
                return false;
            }
            return ((PluginData)other).name.equals(this.name) && (this.version == null || ((PluginData)other).version == null || ((PluginData)other).version.equals(this.version));
        }

        public String toString() {
            return "( " + this.name + ", " + this.version + ")";
        }
    }
}

