/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.Dependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;

public class ElementList
extends HeaderFile {
    private final ElementDependencies extraDeps = new ElementDependencies(this);
    private final List<IUserElement> elements = new ArrayList<IUserElement>();
    private final List<String> declPrefaceTextList = new ArrayList<String>();
    private final List<String> declEndingTextList = new ArrayList<String>();
    private final List<String> defnPrefaceTextList = new ArrayList<String>();
    private final List<String> defnEndingTextList = new ArrayList<String>();
    private boolean interElementSpace = true;
    private boolean writeDecl = true;
    private boolean writeDefn = true;

    public ElementList(FileName name) {
        super(name);
    }

    public void addElement(IUserElement ... elements) {
        IUserElement[] iUserElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IUserElement element = iUserElementArray[n2];
            element.setDefinedIn(this);
            this.elements.add(element);
            ++n2;
        }
    }

    public void addDeclDependency(Dependency dep) {
        this.extraDeps.decl().add(dep);
    }

    public void addDefnDependency(Dependency dep) {
        this.extraDeps.defn().add(dep);
    }

    public void addDeclPrefaceText(String text) {
        this.addTrimmedText(this.declPrefaceTextList, text);
    }

    public void addDeclEndingText(String text) {
        this.addTrimmedText(this.declEndingTextList, text);
    }

    public void addDefnPrefaceText(String text) {
        this.addTrimmedText(this.defnPrefaceTextList, text);
    }

    public void addDefnEndingText(String text) {
        this.addTrimmedText(this.defnEndingTextList, text);
    }

    private void addTrimmedText(List<String> textList, String text) {
        if (text == null) {
            return;
        }
        String trimmed = text.trim();
        if (!trimmed.isEmpty()) {
            textList.add(trimmed);
        }
    }

    public void setInterElementSpace(boolean val) {
        this.interElementSpace = val;
    }

    public void setWriteDecl(boolean val) {
        this.writeDecl = val;
    }

    public void setWriteDefn(boolean val) {
        this.writeDefn = val;
    }

    private boolean writeTextList(CppFormatter fmt, List<String> textList) {
        for (String text : textList) {
            if (!fmt.writeLn(text)) {
                return false;
            }
            if (!this.interElementSpace || fmt.newline()) continue;
            return false;
        }
        return true;
    }

    public boolean write(CppWriter out) {
        String protectionMacro = String.valueOf(this.getName().getAbsolutePath().replace('/', '_').toUpperCase()) + "_HH";
        if (!(out.decl().newline() && out.decl().writeLn("#ifndef " + protectionMacro) && out.decl().writeLn("#define " + protectionMacro) && out.decl().newline() && out.defn().newline() && this.writeInclude(out.defn()) && out.defn().newline())) {
            return false;
        }
        if (this.writeDecl) {
            out.decl().enableWrites();
        }
        if (this.writeDefn) {
            out.defn().enableWrites();
        }
        ElementDependencies deps = new ElementDependencies(this);
        for (IUserElement element : this.elements) {
            element.addDependencies(deps);
        }
        if (!deps.write(out)) {
            return false;
        }
        if (!this.extraDeps.write(out)) {
            return false;
        }
        if (this.writeDecl && !this.writeTextList(out.decl(), this.declPrefaceTextList) || this.writeDefn && !this.writeTextList(out.defn(), this.defnPrefaceTextList)) {
            return false;
        }
        for (IUserElement element : this.elements) {
            if (!element.write(out)) {
                return false;
            }
            if (!this.interElementSpace || !this.writeDefn || out.defn().newline()) continue;
            return false;
        }
        if (this.writeDecl && !this.writeTextList(out.decl(), this.declEndingTextList) || this.writeDefn && !this.writeTextList(out.defn(), this.defnEndingTextList)) {
            return false;
        }
        if (out.decl().isProvisional()) {
            return true;
        }
        return this.writeDecl && out.decl().newline() && out.decl().writeLn("#endif") && out.decl().newline();
    }
}

