/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.standalone;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.GeneratorManager;
import org.eclipse.papyrusrt.codegen.standalone.AnsiCLibraryMetadata;
import org.eclipse.papyrusrt.codegen.standalone.PapyrusCppProfileMetadata;
import org.eclipse.papyrusrt.codegen.standalone.RTCppPropertiesProfileMetadata;
import org.eclipse.papyrusrt.codegen.standalone.RTSModelLibraryMetadata;
import org.eclipse.papyrusrt.codegen.standalone.RegisteredPackageMetadata;
import org.eclipse.papyrusrt.codegen.standalone.UMLRTGenerator;
import org.eclipse.papyrusrt.codegen.standalone.UMLRTProfileMetadata;
import org.eclipse.papyrusrt.codegen.standalone.internal.StandaloneGeneratorManager;
import org.eclipse.papyrusrt.codegen.utils.PluginFinder;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

public class StandaloneUMLRTCodeGenerator {
    public static final String OUTPUT_PATH_PROPERTY = "org.eclipse.papyrusrt.output-path";
    public static final String PLUGINS_PATHS_PROPERTY = "org.eclipse.papyrusrt.plugins-paths";
    public static final String TOP_CAPSULE_PROPERTY = "org.eclipse.papyrusrt.top-capsule";
    public static final String DEFAULT_LOG_LEVEL = "OFF";
    public static final String DEFAULT_TOP = "Top";
    private static CommandLine clargs;
    private static final Options options;
    private static final HelpFormatter helpFormatter;
    private static final String CMDLINE_SYNTAX = "umlrtgen [-h] <path>";
    private static final String OPT_HELP = "h";
    private static final String OPT_QUIET = "q";
    private static final String OPT_LOG_LEVEL = "l";
    private static final String OPT_OUTPUT_PATH = "o";
    private static final String OPT_PLUGINS_PATHS = "p";
    private static final String OPT_TOP = "t";
    private static final String OPT_TO_XTUMLRT = "x";
    private static final String OPT_PRINT_STACK_TRACE = "s";
    private static final String OPT_DEV = "d";
    private static ResourceSet resourceSet;
    private static Path modelPath;
    private static Path outputPath;
    private static String pluginsPaths;
    private static String top;
    private static boolean printStackTrace;

    static {
        options = new Options();
        helpFormatter = new HelpFormatter();
        modelPath = null;
        outputPath = null;
        pluginsPaths = null;
        top = null;
        printStackTrace = false;
    }

    public static void main(String[] args) {
        try {
            StandaloneUMLRTCodeGenerator.parseCmdLineArgs(args);
            if (!StandaloneUMLRTCodeGenerator.processCmdLineArgs()) {
                System.exit(1);
            }
            StandaloneUMLRTCodeGenerator.init();
            URI fullURI = URI.createFileURI((String)modelPath.toString());
            Model model = StandaloneUMLRTCodeGenerator.loadModel(fullURI);
            IStatus result = StandaloneUMLRTCodeGenerator.generate(model);
            if (!clargs.hasOption(OPT_QUIET)) {
                StandaloneUMLRTCodeGenerator.displayStatus(result);
            }
            System.exit(result.getSeverity() < 4 ? 0 : 1);
        }
        catch (ParseException parseException) {
            System.out.println("Invalid command-line arguments.");
            helpFormatter.printHelp(CMDLINE_SYNTAX, options);
        }
        catch (InvalidPathException invalidPathException) {
            System.out.println("Invalid path");
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static Path getModelPath() {
        return modelPath;
    }

    public static Path getOutputPath() {
        return outputPath;
    }

    public static String getPluginsPaths() {
        return pluginsPaths;
    }

    public static String getTop() {
        return top;
    }

    private static void parseCmdLineArgs(String[] args) throws ParseException {
        options.addOption(OPT_HELP, "help", false, "Prints this message.");
        options.addOption(OPT_QUIET, "quiet", false, "Inhibits printing messages during generation.");
        options.addOption(OPT_LOG_LEVEL, "loglevel", true, "Set the level of logging (OFF, SEVERE, INFO, WARNING, CONFIG, FINE, FINER, FINEST). The default is OFF");
        options.addOption(OPT_PRINT_STACK_TRACE, "prtrace", false, "Print the stack trace for exceptions");
        options.addOption(OPT_OUTPUT_PATH, "outdir", true, "Specifies the output folder. By default it is 'gen' in the same folder as the input model.");
        options.addOption(OPT_PLUGINS_PATHS, "plugins", true, "Specifies the plugins folders of the PapyrusRT installation.");
        options.addOption(OPT_TOP, "top", true, "Specify the name of the top capsule. By default it is \"Top\"");
        options.addOption(OPT_TO_XTUMLRT, "toxr", false, "Translate an input UML2 model into an xtUMLrt model instead of generating code.");
        options.addOption(OPT_DEV, "dev", false, "Development mode: this is to be used only when invoking the generator from a development environment.");
        BasicParser parser = new BasicParser();
        clargs = parser.parse(options, args);
        if (clargs.getArgList().isEmpty() && !clargs.hasOption(OPT_HELP)) {
            throw new ParseException("There must be at least one argument.");
        }
    }

    private static boolean processCmdLineArgs() throws InvalidPathException, FileNotFoundException {
        if (clargs.hasOption(OPT_HELP)) {
            helpFormatter.printHelp(CMDLINE_SYNTAX, options);
            return false;
        }
        printStackTrace = clargs.hasOption(OPT_PRINT_STACK_TRACE);
        StandaloneUMLRTCodeGenerator.configureLogging();
        outputPath = StandaloneUMLRTCodeGenerator.validateOutputPath(clargs.getOptionValue(OPT_OUTPUT_PATH, System.getProperty(OUTPUT_PATH_PROPERTY)));
        modelPath = StandaloneUMLRTCodeGenerator.validateModelPath(clargs.getArgs()[0]);
        StandaloneUMLRTCodeGenerator.setPluginsPathPropertyDefault();
        pluginsPaths = StandaloneUMLRTCodeGenerator.validatePluginsPaths(clargs.getOptionValue(OPT_PLUGINS_PATHS, System.getProperty(PLUGINS_PATHS_PROPERTY)));
        if (pluginsPaths != null) {
            PluginFinder.addSearchPaths((String)pluginsPaths);
        }
        top = clargs.getOptionValue(OPT_TOP, System.getProperty(TOP_CAPSULE_PROPERTY, DEFAULT_TOP));
        return true;
    }

    private static Path validateOutputPath(String outputPath) throws InvalidPathException {
        if (outputPath != null) {
            return Paths.get(outputPath, new String[0]);
        }
        return null;
    }

    private static Path validateModelPath(String modelPathString) throws InvalidPathException, FileNotFoundException {
        Path modelPath = Paths.get(modelPathString, new String[0]);
        if (!Files.exists(modelPath, new LinkOption[0])) {
            throw new FileNotFoundException("Model file '" + modelPathString + "' not found");
        }
        return modelPath;
    }

    private static String validatePluginsPaths(String pluginsPathString) throws InvalidPathException, FileNotFoundException {
        if (pluginsPathString == null) {
            return null;
        }
        String separator = System.getProperty("path.separator");
        String[] entries = pluginsPathString.split(separator);
        String result = "";
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            Path pluginsPath = Paths.get(entry, new String[0]);
            if (!Files.exists(pluginsPath, new LinkOption[0])) {
                throw new FileNotFoundException("Plugins folder '" + pluginsPathString + "' not found");
            }
            result = String.valueOf(result) + pluginsPath.toAbsolutePath().toString() + separator;
            ++n2;
        }
        return result;
    }

    private static void configureLogging() {
        Level level = Level.parse(clargs.getOptionValue(OPT_LOG_LEVEL, DEFAULT_LOG_LEVEL).toUpperCase());
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(level);
        CodeGenPlugin.getLogger().addHandler(consoleHandler);
        CodeGenPlugin.getLogger().setLevel(level);
        new CodeGenPlugin();
        CodeGenPlugin.setStandalone((boolean)printStackTrace);
    }

    private static void setPluginsPathPropertyDefault() {
        if (clargs.hasOption(OPT_PLUGINS_PATHS)) {
            return;
        }
        if (System.getProperty(PLUGINS_PATHS_PROPERTY) == null) {
            Path thisClassPath;
            Class<StandaloneUMLRTCodeGenerator> thisClass = StandaloneUMLRTCodeGenerator.class;
            URL url = thisClass.getResource("StandaloneUMLRTCodeGenerator.class");
            Path base = thisClassPath = Paths.get(url.getPath(), new String[0]);
            String toLookFor = "plugins";
            if (clargs.hasOption(OPT_DEV)) {
                toLookFor = "org.eclipse.papyrus-rt";
            }
            while (base != null && !base.endsWith(toLookFor)) {
                base = base.getParent();
            }
            if (base != null) {
                System.setProperty(PLUGINS_PATHS_PROPERTY, base.toString());
            } else {
                CodeGenPlugin.warning((String)"plugins folder not found. The code generator might fail to find the RTS model library. If the model contains references to model library elements, generation can fail with errors. To avoid this warning, please provide the path to the plugins folder using the -p option.");
            }
        }
    }

    private static void updateClassPath() {
        String classpath = System.getProperty("java.class.path");
        System.getProperty("path.separator");
        if (pluginsPaths != null && !pluginsPaths.equals("")) {
            classpath = String.valueOf(pluginsPaths) + classpath;
            System.setProperty("java.class.path", classpath);
        }
    }

    private static void init() {
        StandaloneUMLRTCodeGenerator.logPaths();
        resourceSet = new ResourceSetImpl();
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        RegisteredPackageMetadata.searchPlugins(UMLRTProfileMetadata.INSTANCE.getPackageId(), RTCppPropertiesProfileMetadata.INSTANCE.getPackageId(), AnsiCLibraryMetadata.INSTANCE.getPackageId(), PapyrusCppProfileMetadata.INSTANCE.getPackageId(), RTSModelLibraryMetadata.INSTANCE.getPackageId());
        UMLRTProfileMetadata.INSTANCE.registerProfile(resourceSet);
        PapyrusCppProfileMetadata.INSTANCE.registerProfile(resourceSet);
        if (pluginsPaths != null) {
            StandaloneUMLRTCodeGenerator.loadAnsiCLibrary();
            AnsiCLibraryMetadata.INSTANCE.registerPackage(resourceSet);
            StandaloneUMLRTCodeGenerator.loadModelLibrary();
            RTSModelLibraryMetadata.INSTANCE.registerPackage(resourceSet);
            StandaloneUMLRTCodeGenerator.loadRTCppPropertiesProfile();
            RTCppPropertiesProfileMetadata.INSTANCE.registerProfile(resourceSet);
        }
    }

    private static Package loadPackage(URI fullURI) {
        Resource resource = resourceSet.getResource(fullURI, true);
        EList contents = resource.getContents();
        Package pkg = (Package)EcoreUtil.getObjectByType((Collection)contents, (EClassifier)UMLPackage.Literals.PACKAGE);
        return pkg;
    }

    private static Model loadModel(URI fullURI) {
        return (Model)StandaloneUMLRTCodeGenerator.loadPackage(fullURI);
    }

    private static Profile loadProfile(URI fullURI) {
        return (Profile)StandaloneUMLRTCodeGenerator.loadPackage(fullURI);
    }

    private static Model loadModelLibrary() {
        URI modelLibLocationURI = RTSModelLibraryMetadata.INSTANCE.getPackageLocationURI();
        Model lib = StandaloneUMLRTCodeGenerator.loadModel(modelLibLocationURI);
        return lib;
    }

    private static Profile loadRTCppPropertiesProfile() {
        URI profileLocationURI = RTCppPropertiesProfileMetadata.INSTANCE.getPackageLocationURI();
        Profile lib = StandaloneUMLRTCodeGenerator.loadProfile(profileLocationURI);
        return lib;
    }

    private static Model loadAnsiCLibrary() {
        URI ansiCLibLocationURI = AnsiCLibraryMetadata.INSTANCE.getPackageLocationURI();
        Model lib = StandaloneUMLRTCodeGenerator.loadModel(ansiCLibLocationURI);
        return lib;
    }

    private static IStatus generate(Model model) {
        IStatus status = null;
        if (clargs.hasOption(OPT_TO_XTUMLRT)) {
            status = UMLRTGenerator.generateXTUMLRT(model);
        } else {
            ArrayList<EObject> targets = new ArrayList<EObject>();
            targets.add((EObject)model);
            GeneratorManager.setInstance((GeneratorManager)new StandaloneGeneratorManager());
            status = UMLRTGenerator.generate(targets, top);
        }
        return status;
    }

    private static void displayStatus(IStatus status) {
        String result = "";
        switch (status.getSeverity()) {
            case 8: {
                result = "Generation cancelled";
                break;
            }
            case 4: {
                result = "Generation failed with an error";
                break;
            }
            case 0: 
            case 1: {
                result = "Generation successful";
                break;
            }
            case 2: {
                result = "Generation successful but with warnings";
            }
        }
        System.out.println(result);
        if (!clargs.hasOption(OPT_QUIET)) {
            StandaloneUMLRTCodeGenerator.displayAll(System.out, "", status);
        }
    }

    private static void displayAll(PrintStream out, String indent, IStatus status) {
        out.print(indent);
        out.println(status.getMessage());
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            StandaloneUMLRTCodeGenerator.displayAll(out, String.valueOf(indent) + "    ", child);
            ++n2;
        }
    }

    private static void displayAllStereotypes(EObject eobj, int depth) {
        if (eobj instanceof Element) {
            EList sas;
            Element el = (Element)eobj;
            CodeGenPlugin.info((String)(String.valueOf(StandaloneUMLRTCodeGenerator.indent(depth)) + "* " + el));
            EList as = el.getAppliedStereotypes();
            if (as.size() > 0) {
                CodeGenPlugin.info((String)(String.valueOf(StandaloneUMLRTCodeGenerator.indent(depth)) + "  - Applied stereotypes:"));
                for (Stereotype s : as) {
                    CodeGenPlugin.info((String)(String.valueOf(StandaloneUMLRTCodeGenerator.indent(depth)) + "      " + s));
                }
            }
            if ((sas = el.getStereotypeApplications()).size() > 0) {
                CodeGenPlugin.info((String)(String.valueOf(StandaloneUMLRTCodeGenerator.indent(depth)) + "  - Stereotype applications:"));
                for (EObject sa : sas) {
                    CodeGenPlugin.info((String)(String.valueOf(StandaloneUMLRTCodeGenerator.indent(depth)) + "      " + sa));
                }
            }
            EList contents = el.getOwnedElements();
            for (Element sub : contents) {
                StandaloneUMLRTCodeGenerator.displayAllStereotypes((EObject)sub, depth + 4);
            }
        }
    }

    static String indent(int n) {
        String r = "";
        int i = 0;
        while (i < n) {
            r = String.valueOf(r) + " ";
            ++i;
        }
        return r;
    }

    static void logPaths() {
        String mp = modelPath.toString();
        String op = outputPath.toString();
        String pp = pluginsPaths;
        CodeGenPlugin.info((String)("model path:   '" + mp + "'"));
        CodeGenPlugin.info((String)("output path:  '" + op + "'"));
        CodeGenPlugin.info((String)("plugins path: '" + pp + "'"));
    }
}

