/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.structure;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.cpp.structure.CppMainGenerator;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.Controller;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.ControllerAllocations;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.Deployment;
import org.eclipse.papyrusrt.codegen.instance.model.ICapsuleInstance;
import org.eclipse.papyrusrt.codegen.instance.model.IPortInstance;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppEnum;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Enumerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AddressOfExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BlockInitializer;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BooleanLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ConstructorCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.CppEnumOrderedInitializer;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IndexExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.StringLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.external.StandardLibrary;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Port;

public class CompositionGenerator
extends AbstractCppGenerator {
    private final Capsule topCapsule;
    private final ControllerAllocations controllerAllocations;
    private Variable slotsVar;
    private final Map<ICapsuleInstance, Enumerator> capsuleEnums = new HashMap<ICapsuleInstance, Enumerator>();
    private final Map<ICapsuleInstance, Variable> capsuleTypeInstances = new HashMap<ICapsuleInstance, Variable>();
    private final Map<ICapsuleInstance, Variable[]> capsulePortArrays = new HashMap<ICapsuleInstance, Variable[]>();
    private final Map<ICapsuleInstance, VarWrapper[]> portArrays = new HashMap<ICapsuleInstance, VarWrapper[]>();
    private Deployment deployment;

    private CompositionGenerator(CppCodePattern cpp, Capsule topCapsule, ControllerAllocations controllerAllocations) {
        super(cpp);
        this.topCapsule = topCapsule;
        this.controllerAllocations = controllerAllocations;
    }

    public String getLabel() {
        return String.valueOf(super.getLabel()) + ' ' + this.topCapsule.getName();
    }

    public boolean generate() {
        this.deployment = Deployment.build(this.cpp, this.topCapsule, this.controllerAllocations);
        if (this.deployment == null) {
            return false;
        }
        ElementList elements = this.cpp.getElementList(CppCodePattern.Output.Deployment, (NamedElement)this.topCapsule);
        if (elements == null || !this.cpp.markWritable(elements)) {
            return false;
        }
        CppEnum capsuleIdEnum = new CppEnum("CapsuleInstanceId");
        elements.addElement(new IUserElement[]{capsuleIdEnum});
        for (Controller controller : this.deployment.getControllers()) {
            for (ICapsuleInstance capsule : controller.getCapsules()) {
                Enumerator enumerator = new Enumerator("InstId_" + capsule.getQualifiedName('_'));
                capsuleIdEnum.add(enumerator);
                this.capsuleEnums.put(capsule, enumerator);
            }
        }
        BlockInitializer arrayInit = new BlockInitializer(UMLRTRuntime.UMLRTSlot.getType().arrayOf(null));
        for (Controller controller : this.deployment.getControllers()) {
            Variable controllerVar = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTController.getType(), controller.getName(), (Expression)UMLRTRuntime.UMLRTController.Ctor((Expression)new StringLiteral(controller.getName())));
            elements.addElement(new IUserElement[]{controllerVar});
            for (ICapsuleInstance capsule : controller.getCapsules()) {
                Variable partArray;
                Variable borderPortArray = this.getPortArray(elements, capsule, true);
                if (!capsule.isDynamic()) {
                    Variable borderPortPtrArray = null;
                    if (borderPortArray != null && (borderPortPtrArray = this.createCapsulePortPointerArray(borderPortArray)) != null) {
                        elements.addElement(new IUserElement[]{borderPortPtrArray});
                    }
                    Variable internalPortArray = this.getPortArray(elements, capsule, false);
                    ConstructorCall ctorCall = new ConstructorCall(this.cpp.getConstructor(CppCodePattern.Output.CapsuleClass, (NamedElement)capsule.getType()));
                    ctorCall.addArgument((Expression)new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.cpp.getVariable(CppCodePattern.Output.UMLRTCapsuleClass, (NamedElement)capsule.getType()))));
                    ctorCall.addArgument((Expression)new AddressOfExpr(this.getSlotAccess(capsule)));
                    ctorCall.addArgument((Expression)(borderPortPtrArray == null ? StandardLibrary.NULL() : new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)borderPortPtrArray)));
                    ctorCall.addArgument((Expression)(internalPortArray == null ? StandardLibrary.NULL() : new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)internalPortArray)));
                    ctorCall.addArgument((Expression)new BooleanLiteral(!capsule.isDynamic()));
                    char[] instNameChars = capsule.getQualifiedName('_').toCharArray();
                    String instName = null;
                    if (instNameChars.length <= 0) {
                        throw new RuntimeException("invalid attempt to generate code for unnamed Capsule");
                    }
                    if (Character.isLowerCase(instNameChars[0])) {
                        instName = String.valueOf(new String(instNameChars)) + '_';
                    } else {
                        instNameChars[0] = Character.toLowerCase(instNameChars[0]);
                        instName = new String(instNameChars);
                    }
                    Variable instVar = new Variable(LinkageSpec.STATIC, this.cpp.getCppClass(CppCodePattern.Output.CapsuleClass, (NamedElement)capsule.getType()).getType(), instName, (Expression)ctorCall);
                    elements.addElement(new IUserElement[]{instVar});
                    this.capsuleTypeInstances.put(capsule, instVar);
                }
                if ((partArray = this.createCapsulePartArray(elements, capsule)) != null) {
                    elements.addElement(new IUserElement[]{partArray});
                }
                Variable userClassVar = this.capsuleTypeInstances.get(capsule);
                Expression[] expressionArray = new Expression[14];
                expressionArray[0] = new StringLiteral(capsule.getQualifiedName('.'));
                expressionArray[1] = new IntegralLiteral(capsule.getIndex());
                expressionArray[2] = new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.cpp.getVariable(CppCodePattern.Output.UMLRTCapsuleClass, (NamedElement)capsule.getType())));
                Object object = expressionArray[3] = capsule.getContainer() == null ? StandardLibrary.NULL() : new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.cpp.getVariable(CppCodePattern.Output.UMLRTCapsuleClass, (NamedElement)capsule.getContainer().getType())));
                expressionArray[4] = capsule.getCapsulePart() == null ? new IntegralLiteral(0) : this.cpp.getEnumeratorAccess(CppCodePattern.Output.PartId, (NamedElement)capsule.getCapsulePart(), capsule.getContainer() == null ? null : capsule.getContainer().getType());
                expressionArray[5] = userClassVar == null ? StandardLibrary.NULL() : new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)userClassVar));
                expressionArray[6] = new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)controllerVar));
                expressionArray[7] = new IntegralLiteral(partArray == null ? 0 : partArray.getNumInitializedInstances());
                expressionArray[8] = partArray == null ? StandardLibrary.NULL() : new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)partArray);
                expressionArray[9] = new IntegralLiteral(borderPortArray == null ? 0 : borderPortArray.getNumInitializedInstances());
                expressionArray[10] = borderPortArray == null ? StandardLibrary.NULL() : new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)borderPortArray);
                expressionArray[11] = StandardLibrary.NULL();
                expressionArray[12] = BooleanLiteral.TRUE();
                expressionArray[13] = BooleanLiteral.FALSE();
                arrayInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTSlot.getType(), expressionArray));
            }
        }
        if (this.slotsVar != null) {
            this.slotsVar.setInitializer((Expression)arrayInit);
        } else {
            this.slotsVar = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTSlot.getType().arrayOf(null), String.valueOf(this.topCapsule.getName()) + "_slots", (Expression)arrayInit);
        }
        elements.addElement(new IUserElement[]{this.slotsVar});
        new CppMainGenerator().generate(String.valueOf(this.cpp.getOutputFolder().getAbsolutePath()) + "/main.cc", this.topCapsule.getName(), this.deployment, this.slotsVar);
        return true;
    }

    private Expression getSlotAccess(ICapsuleInstance capsule) {
        if (this.slotsVar == null) {
            this.slotsVar = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTSlot.getType().arrayOf(null), String.valueOf(this.topCapsule.getName()) + "_slots");
        }
        return new IndexExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.slotsVar), (Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.capsuleEnums.get(capsule)));
    }

    private Variable createCapsulePartArray(ElementList elements, ICapsuleInstance capsule) {
        BlockInitializer slotArrayInit = new BlockInitializer(UMLRTRuntime.UMLRTSlot.getType().ptr().arrayOf(null));
        Variable slotArrayVar = new Variable(LinkageSpec.STATIC, slotArrayInit.getType(), "slots_" + capsule.getQualifiedName('_'), (Expression)slotArrayInit);
        BlockInitializer init = new BlockInitializer(UMLRTRuntime.UMLRTCapsulePart.getType().arrayOf(null));
        Variable var = new Variable(LinkageSpec.STATIC, UMLRTRuntime.UMLRTCapsulePart.getType().arrayOf(null), "parts_" + capsule.getQualifiedName('_'), (Expression)init);
        Variable capsuleClassVar = this.cpp.getVariable(CppCodePattern.Output.UMLRTCapsuleClass, (NamedElement)capsule.getType());
        for (CapsulePart part : XTUMLRTUtil.getAllCapsuleParts((Capsule)capsule.getType())) {
            Expression slotAccess = null;
            List contained = capsule.getContained(part);
            if (contained == null || contained.size() <= 0) {
                slotAccess = StandardLibrary.NULL();
            } else {
                slotAccess = new AddressOfExpr((Expression)new IndexExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)slotArrayVar), (Expression)new IntegralLiteral(slotArrayVar.getNumInitializedInstances())));
                for (ICapsuleInstance sub : contained) {
                    slotArrayInit.addExpression((Expression)new AddressOfExpr(this.getSlotAccess(sub)));
                }
            }
            init.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTCapsulePart.getType(), new Expression[]{new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)capsuleClassVar)), this.cpp.getEnumeratorAccess(CppCodePattern.Output.PartId, (NamedElement)part, (NamedElement)capsule.getType()), new IntegralLiteral(contained == null ? 0 : contained.size()), slotAccess}));
        }
        if (slotArrayVar.getNumInitializedInstances() > 0) {
            elements.addElement(new IUserElement[]{slotArrayVar});
        }
        return var.getNumInitializedInstances() <= 0 ? null : var;
    }

    private Variable createCapsulePortArray(ICapsuleInstance capsule, boolean border) {
        Variable var;
        Variable[] vars = this.capsulePortArrays.get(capsule);
        if (vars == null) {
            vars = new Variable[2];
            this.capsulePortArrays.put(capsule, vars);
        }
        if ((var = vars[border ? 0 : 1]) == null) {
            var = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTCommsPort.getType().arrayOf(null), String.valueOf(border ? "border" : "internal") + "ports_" + capsule.getQualifiedName('_'));
            vars[border ? 0 : 1] = var;
        }
        return var;
    }

    private Variable getPortArray(ElementList elements, ICapsuleInstance capsule, boolean border) {
        VarWrapper var;
        VarWrapper[] vars = this.portArrays.get(capsule);
        if (vars == null) {
            vars = new VarWrapper[2];
            this.portArrays.put(capsule, vars);
        }
        if ((var = vars[border ? 0 : 1]) == null) {
            var = new VarWrapper(this.createPortArray(elements, capsule, border));
            vars[border ? 0 : 1] = var;
            if (var.variable != null) {
                elements.addElement(new IUserElement[]{var.variable});
            }
        }
        return var.variable;
    }

    private Variable createPortArray(ElementList elements, ICapsuleInstance capsule, boolean border) {
        CppEnumOrderedInitializer arrayInit = null;
        CppCodePattern.Output CppCodePattern_Output_portId = border ? CppCodePattern.Output.BorderPortId : CppCodePattern.Output.InternalPortId;
        BlockInitializer farEndInit = new BlockInitializer(UMLRTRuntime.UMLRTCommsPortFarEnd.getType().arrayOf(null));
        Variable farEndPorts = new Variable(LinkageSpec.STATIC, farEndInit.getType(), String.valueOf(border ? "border" : "internal") + "farEndList_" + capsule.getQualifiedName('_'), (Expression)farEndInit);
        for (IPortInstance port : capsule.getPorts()) {
            if (border == XTUMLRTUtil.isInternalPort((Port)port.getType())) continue;
            int farEndCount = 0;
            ElementAccess farEndAccess = farEndPorts.getNumInitializedInstances() == 0 ? new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)farEndPorts) : new AddressOfExpr((Expression)new IndexExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)farEndPorts), (Expression)new IntegralLiteral(farEndPorts.getNumInitializedInstances())));
            for (IPortInstance.IFarEnd farEnd : port.getFarEnds()) {
                ++farEndCount;
                ICapsuleInstance farEndCapsule = farEnd.getContainer();
                farEndInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTCommsPortFarEnd.getType(), new Expression[]{new IntegralLiteral(farEnd.getIndex()), new AddressOfExpr((Expression)new IndexExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.createCapsulePortArray(farEndCapsule, !XTUMLRTUtil.isInternalPort((Port)farEnd.getType()))), this.cpp.getEnumeratorAccess(XTUMLRTUtil.isInternalPort((Port)farEnd.getType()) ? CppCodePattern.Output.InternalPortId : CppCodePattern.Output.BorderPortId, (NamedElement)farEnd.getType(), (NamedElement)farEndCapsule.getType())))}));
            }
            while (farEndCount < XTUMLRTUtil.getLowerBound((MultiplicityElement)port.getType())) {
                farEndInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTCommsPortFarEnd.getType(), new Expression[]{new IntegralLiteral(0), StandardLibrary.NULL()}));
                ++farEndCount;
            }
            BlockInitializer portInit = new BlockInitializer(UMLRTRuntime.UMLRTCommsPort.getType());
            portInit.addExpression((Expression)new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)this.cpp.getVariable(CppCodePattern.Output.UMLRTCapsuleClass, (NamedElement)port.getContainer().getType()))));
            portInit.addExpression(this.cpp.getEnumeratorAccess(CppCodePattern_Output_portId, (NamedElement)port.getType(), (NamedElement)capsule.getType()));
            portInit.addExpression((Expression)new AddressOfExpr(this.getSlotAccess(port.getContainer())));
            portInit.addExpression((Expression)new IntegralLiteral(farEndCount));
            portInit.addExpression((Expression)(farEndCount <= 0 ? StandardLibrary.NULL() : farEndAccess));
            portInit.addExpression(StandardLibrary.NULL());
            portInit.addExpression(StandardLibrary.NULL());
            portInit.addExpression((Expression)BooleanLiteral.from((boolean)XTUMLRTUtil.isAutomatic((Port)port.getType())));
            portInit.addExpression((Expression)BooleanLiteral.from((boolean)border));
            portInit.addExpression((Expression)BooleanLiteral.TRUE());
            portInit.addExpression((Expression)BooleanLiteral.from((boolean)XTUMLRTUtil.isApplicationLocked((Port)port.getType())));
            portInit.addExpression((Expression)BooleanLiteral.from((boolean)XTUMLRTUtil.isNotification((Port)port.getType())));
            portInit.addExpression((Expression)BooleanLiteral.FALSE());
            portInit.addExpression((Expression)BooleanLiteral.from((boolean)port.isRelay()));
            portInit.addExpression((Expression)BooleanLiteral.FALSE());
            portInit.addExpression((Expression)BooleanLiteral.FALSE());
            portInit.addExpression((Expression)BooleanLiteral.FALSE());
            portInit.addExpression((Expression)BooleanLiteral.from((boolean)XTUMLRTUtil.isWired((Port)port.getType())));
            if (arrayInit == null) {
                arrayInit = new CppEnumOrderedInitializer(this.cpp.getIdEnum(CppCodePattern_Output_portId, (NamedElement)port.getContainer().getType()), UMLRTRuntime.UMLRTCommsPortFarEnd.getType().arrayOf(null));
            }
            arrayInit.putExpression(this.cpp.getEnumerator(CppCodePattern_Output_portId, (NamedElement)port.getType(), (NamedElement)capsule.getType()), (Expression)portInit);
        }
        if (arrayInit == null || arrayInit.getNumInitializers() <= 0) {
            return null;
        }
        if (farEndPorts.getNumInitializedInstances() > 0) {
            elements.addElement(new IUserElement[]{farEndPorts});
        }
        Variable portArray = this.createCapsulePortArray(capsule, border);
        portArray.setInitializer(arrayInit);
        return portArray;
    }

    private Variable createCapsulePortPointerArray(Variable var) {
        if (var == null) {
            return null;
        }
        BlockInitializer init = new BlockInitializer(UMLRTRuntime.UMLRTCommsPort.getType().const_().ptr().arrayOf(null));
        int i = 0;
        while (i < var.getNumInitializedInstances()) {
            init.addExpression((Expression)new AddressOfExpr((Expression)new IndexExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)var), (Expression)new IntegralLiteral(i))));
            ++i;
        }
        return new Variable(LinkageSpec.STATIC, init.getType(), String.valueOf(var.getName().getIdentifier()) + "_ptrs", (Expression)init);
    }

    /* synthetic */ CompositionGenerator(CppCodePattern cppCodePattern, Capsule capsule, ControllerAllocations controllerAllocations, CompositionGenerator compositionGenerator) {
        this(cppCodePattern, capsule, controllerAllocations);
    }

    public static class Factory
    implements AbstractCppGenerator.Factory<Capsule, Package> {
        public AbstractCppGenerator create(CppCodePattern cpp, Capsule topCapsule, Package context) {
            ControllerAllocations controllerAllocations = null;
            File file = cpp.getControllerAllocations((NamedElement)topCapsule);
            if (file != null) {
                controllerAllocations = ControllerAllocations.load(file);
            }
            if (controllerAllocations == null) {
                controllerAllocations = ControllerAllocations.Default;
            }
            return new CompositionGenerator(cpp, topCapsule, controllerAllocations, null);
        }
    }

    private static class VarWrapper {
        public final Variable variable;

        public VarWrapper(Variable variable) {
            this.variable = variable;
        }
    }
}

