/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrusrt.codegen.cpp.CppMakefileGenerator;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Constructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppEnum;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Enumerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.MemberAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.RTCppGenerationProperties;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;

public class CppCodePattern {
    private File outputFolder;
    private File modelFolder;
    private final Map<Key, ElementList> elementLists = new HashMap<Key, ElementList>();
    private final Map<Key, CppClass> cppClasses = new HashMap<Key, CppClass>();
    private final Map<Key, Variable> variables = new HashMap<Key, Variable>();
    private final Map<Key, CppEnum> cppEnums = new HashMap<Key, CppEnum>();
    private final Map<Key, Enumerator> enumerators = new HashMap<Key, Enumerator>();
    private final Map<Key, Constructor> constructors = new HashMap<Key, Constructor>();
    private final List<ElementList> outputs = new ArrayList<ElementList>();

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setModelFolder(File modelFolder) {
        this.modelFolder = modelFolder;
    }

    public boolean markWritable(ElementList elements) {
        if (!this.elementLists.containsValue(elements)) {
            return false;
        }
        this.outputs.add(elements);
        return true;
    }

    public File getControllerAllocations(org.eclipse.papyrusrt.xtumlrt.common.NamedElement topCapsule) {
        File allocationsFile = new File(this.modelFolder, String.valueOf(topCapsule.getName()) + ".controllers");
        return allocationsFile.exists() ? allocationsFile : null;
    }

    public ElementList getElementList(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Key k = new Key(output, element, null);
        switch (output) {
            case Deployment: {
                ElementList elementList = this.elementLists.get(k);
                if (elementList == null) {
                    elementList = new ElementList(new FileName(String.valueOf(element.getName()) + "Controllers"));
                    this.elementLists.put(k, elementList);
                }
                return elementList;
            }
        }
        return this.getElementList(k, element);
    }

    public CppClass getWritableCppClass(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        CppClass cls = this.getCppClass(output, element);
        HeaderFile header = cls.getDefinedIn();
        if (header instanceof ElementList) {
            this.markWritable((ElementList)header);
        }
        return cls;
    }

    public CppEnum getWritableCppEnum(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        CppEnum enm = this.getCppEnum(output, element);
        HeaderFile header = enm.getDefinedIn();
        if (header instanceof ElementList) {
            this.markWritable((ElementList)header);
        }
        return enm;
    }

    public CppClass getCppClass(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Key k = new Key(output, element, null);
        CppClass cls = this.cppClasses.get(k);
        if (cls == null) {
            switch (output) {
                case CapsuleClass: 
                case ProtocolClass: 
                case BasicClass: {
                    cls = new CppClass(this.getName(output, element));
                    ElementList elements = this.getElementList(k, element);
                    elements.addElement(new IUserElement[]{cls});
                    this.apply_RTCppGenerationProperties(elements, element);
                    break;
                }
                case OutSignals: {
                    cls = new CppClass("OutSignals");
                    this.getCppClass(Output.ProtocolClass, element).addMember(CppClass.Visibility.PUBLIC, cls);
                    break;
                }
                case InSignals: {
                    cls = new CppClass("InSignals");
                    this.getCppClass(Output.ProtocolClass, element).addMember(CppClass.Visibility.PUBLIC, cls);
                    break;
                }
                case ProtocolBaseRole: 
                case ProtocolConjugateRole: {
                    this.getCppClass(Output.ProtocolClass, element);
                    cls = new CppClass(this.getName(output, element));
                    this.getElementList(new Key(Output.ProtocolClass, element, null), element).addElement(new IUserElement[]{cls});
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppClass for " + output.toString());
                }
            }
            this.cppClasses.put(k, cls);
        }
        return cls;
    }

    public Constructor getConstructor(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Key k = new Key(output, element, null);
        Constructor ctor = this.constructors.get(k);
        if (ctor == null) {
            switch (output) {
                case CapsuleClass: 
                case ProtocolBaseRole: 
                case ProtocolConjugateRole: {
                    ctor = new Constructor();
                    this.getCppClass(output, element).addMember(CppClass.Visibility.PUBLIC, ctor);
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a Constructor for " + output.toString());
                }
            }
            this.constructors.put(k, ctor);
        }
        return ctor;
    }

    public Variable getVariable(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Key k = new Key(output, element, null);
        Variable var = this.variables.get(k);
        if (var == null) {
            switch (output) {
                case UMLRTCapsuleClass: {
                    var = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTCapsuleClass.getType().const_(), this.getName(output, element));
                    break;
                }
                case UMLRTTypeDescriptor: {
                    var = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTObject.getType().const_().constPtr(), this.getName(output, element));
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a Variable for " + output.toString());
                }
            }
            this.variables.put(k, var);
        }
        return var;
    }

    public CppEnum getCppEnum(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Key k = new Key(output, element, null);
        CppEnum enm = this.cppEnums.get(k);
        if (enm == null) {
            switch (output) {
                case UserEnum: {
                    enm = new CppEnum(element.getName());
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppEnum for " + output.toString());
                }
            }
            ElementList elements = this.getElementList(k, element);
            elements.addElement(new IUserElement[]{enm});
            enm.setDefinedIn((HeaderFile)elements);
            this.cppEnums.put(k, enm);
        }
        return enm;
    }

    private static Map<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> getSortedSignals(Protocol protocol) {
        RedefinableElement parent = protocol.getRedefines();
        LinkedHashMap<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> elements = parent instanceof Protocol ? CppCodePattern.getSortedSignals((Protocol)parent) : new LinkedHashMap();
        for (org.eclipse.papyrusrt.xtumlrt.common.NamedElement element : XTUMLRTUtil.getUserSignals((Protocol)protocol)) {
            elements.put(element.getName(), element);
        }
        return elements;
    }

    private static Map<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> getSortedPorts(Capsule capsule) {
        RedefinableElement parent = capsule.getRedefines();
        LinkedHashMap<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> elements = parent instanceof Capsule ? CppCodePattern.getSortedPorts((Capsule)parent) : new LinkedHashMap();
        for (Port element : XTUMLRTUtil.getRTPorts((Capsule)capsule)) {
            elements.put(element.getName(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element);
        }
        return elements;
    }

    private static Map<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> getSortedParts(Capsule capsule) {
        RedefinableElement parent = capsule.getRedefines();
        LinkedHashMap<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> elements = parent instanceof Capsule ? CppCodePattern.getSortedParts((Capsule)parent) : new LinkedHashMap();
        for (CapsulePart element : XTUMLRTUtil.getCapsuleParts((Capsule)capsule)) {
            elements.put(element.getName(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element);
        }
        return elements;
    }

    public CppEnum getIdEnum(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Key k = new Key(output, element, null);
        CppEnum enm = this.cppEnums.get(k);
        if (enm == null) {
            Map<String, org.eclipse.papyrusrt.xtumlrt.common.NamedElement> enumeratorElements = null;
            Output clsKind = null;
            String enumName = null;
            Expression firstLiteral = null;
            switch (output) {
                case SignalId: {
                    clsKind = Output.ProtocolClass;
                    enumName = "SignalId";
                    enumeratorElements = CppCodePattern.getSortedSignals((Protocol)element);
                    firstLiteral = UMLRTRuntime.UMLRTSignal.FIRST_PROTOCOL_SIGNAL_ID();
                    break;
                }
                case PortId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "PortId";
                    enumeratorElements = CppCodePattern.getSortedPorts((Capsule)element);
                    break;
                }
                case PartId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "PartId";
                    enumeratorElements = CppCodePattern.getSortedParts((Capsule)element);
                    break;
                }
                case BorderPortId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "BorderPortId";
                    break;
                }
                case InternalPortId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "InternalPortId";
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppEnum for " + output.toString());
                }
            }
            CppClass cls = this.getCppClass(clsKind, element);
            enm = new CppEnum((NamedElement)cls, enumName, firstLiteral);
            cls.addMember(CppClass.Visibility.PUBLIC, enm);
            this.cppEnums.put(k, enm);
            if (enumeratorElements != null) {
                for (org.eclipse.papyrusrt.xtumlrt.common.NamedElement enumeratorElement : enumeratorElements.values()) {
                    this.getEnumerator(output, enumeratorElement, element);
                }
            }
        }
        return enm;
    }

    public Enumerator getEnumerator(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.NamedElement context) {
        Key k = new Key(output, element, context);
        Enumerator enumerator = this.enumerators.get(k);
        if (enumerator == null) {
            switch (output) {
                case SignalId: {
                    if (!(element instanceof Signal)) {
                        throw new RuntimeException("code pattern requires Signal for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                    }
                    if (context instanceof org.eclipse.papyrusrt.xtumlrt.common.NamedElement) break;
                    throw new RuntimeException("code pattern requires NamedElement as owner for " + output.toString() + " but got " + context.getClass().getCanonicalName());
                }
                case PortId: 
                case BorderPortId: 
                case InternalPortId: 
                case PartId: {
                    if (context instanceof org.eclipse.papyrusrt.xtumlrt.common.NamedElement) break;
                    throw new RuntimeException("code pattern requires NamedElement as owner for " + output.toString() + " but got " + context.getClass().getCanonicalName());
                }
                default: {
                    throw new RuntimeException("code pattern does not contain an Enumerator for " + output.toString());
                }
            }
            CppEnum enm = this.getIdEnum(output, context);
            enumerator = this.enumerators.get(k);
            if (enumerator == null) {
                enumerator = enm.add(this.getName(output, element));
                this.enumerators.put(k, enumerator);
            }
        }
        return enumerator;
    }

    public Expression getEnumeratorAccess(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.NamedElement context) {
        CppClass cls = null;
        switch (output) {
            case SignalId: {
                if (!(element instanceof Signal)) {
                    throw new RuntimeException("code pattern requires Signal for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                }
                Signal signal = (Signal)element;
                if (context == null) {
                    org.eclipse.papyrusrt.xtumlrt.common.NamedElement owner = XTUMLRTUtil.getOwner((CommonElement)signal);
                    if (owner == null || !(owner instanceof Protocol)) {
                        throw new RuntimeException("code pattern: the owner of signal " + signal.getName() + " is not a protocol");
                    }
                    Protocol protocol = (Protocol)owner;
                    if (XTUMLRTUtil.isSystemElement((CommonElement)protocol)) {
                        return UMLRTRuntime.getSystemProtocolSignalAccess((Signal)signal);
                    }
                    context = protocol;
                }
                cls = this.getCppClass(Output.ProtocolClass, context);
                break;
            }
            case PartId: {
                if (!(element instanceof CapsulePart)) {
                    throw new RuntimeException("code pattern requires Property for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                }
                if (context == null) {
                    org.eclipse.papyrusrt.xtumlrt.common.NamedElement capsule;
                    CapsulePart part = (CapsulePart)element;
                    context = capsule = XTUMLRTUtil.getOwner((CommonElement)part);
                }
                cls = this.getCppClass(Output.CapsuleClass, context);
                break;
            }
            case PortId: 
            case BorderPortId: 
            case InternalPortId: {
                if (!(element instanceof Port)) {
                    throw new RuntimeException("code pattern requires Port for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                }
                if (context == null) {
                    org.eclipse.papyrusrt.xtumlrt.common.NamedElement capsule;
                    Port port = (Port)element;
                    context = capsule = XTUMLRTUtil.getOwner((CommonElement)port);
                }
                cls = this.getCppClass(Output.CapsuleClass, context);
                break;
            }
            default: {
                throw new RuntimeException("no enumerator access expression defined for " + (Object)((Object)output));
            }
        }
        Enumerator enumerator = this.getEnumerator(output, element, context);
        return new MemberAccess((NamedElement)cls, (NamedElement)enumerator);
    }

    private String getName(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        switch (output) {
            case CapsuleClass: {
                return "Capsule_" + element.getName();
            }
            case ProtocolBaseRole: {
                return String.valueOf(element.getName()) + "_baserole";
            }
            case ProtocolConjugateRole: {
                return String.valueOf(element.getName()) + "_conjrole";
            }
            case SignalId: {
                return "signal_" + element.getName();
            }
            case PortId: {
                return "port_" + element.getName();
            }
            case BorderPortId: {
                return "borderport_" + element.getName();
            }
            case InternalPortId: {
                return "internalport_" + element.getName();
            }
            case PartId: {
                return "part_" + element.getName();
            }
            case UMLRTTypeDescriptor: {
                return "UMLRTType_" + element.getName();
            }
        }
        return element.getName();
    }

    private ElementList getElementList(Key k, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        ElementList elementList = this.elementLists.get(k);
        if (elementList == null) {
            switch (k.output) {
                case UMLRTCapsuleClass: {
                    return this.getElementList(Output.CapsuleClass, element);
                }
            }
            elementList = new ElementList(new FileName(element.getName()));
            this.elementLists.put(k, elementList);
        }
        return elementList;
    }

    public boolean write() {
        String baseFolder = this.outputFolder.getAbsolutePath();
        boolean ret = true;
        for (ElementList output : this.outputs) {
            try (CppWriter out = CppWriter.create((String)baseFolder, (ElementList)output);){
                if (output.write(out)) continue;
                ret = false;
                System.err.println("Failure while writing '" + output.getName().getAbsolutePath() + "' to disk");
            }
        }
        new CppMakefileGenerator().generate(String.valueOf(this.outputFolder.getAbsolutePath()) + "/Makefile");
        return ret;
    }

    private void apply_RTCppGenerationProperties(ElementList elements, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        String headPreface = RTCppGenerationProperties.getCppFileHeaderPreface((CommonElement)element);
        String headEnding = RTCppGenerationProperties.getCppFileHeaderEnding((CommonElement)element);
        String implPreface = RTCppGenerationProperties.getCppFileImplementationPreface((CommonElement)element);
        String implEnding = RTCppGenerationProperties.getCppFileImplementationEnding((CommonElement)element);
        elements.addDeclPrefaceText(headPreface);
        elements.addDeclEndingText(headEnding);
        elements.addDefnPrefaceText(implPreface);
        elements.addDefnEndingText(implEnding);
    }

    private static class Key {
        public final Output output;
        public final org.eclipse.papyrusrt.xtumlrt.common.NamedElement element;
        public final org.eclipse.papyrusrt.xtumlrt.common.NamedElement context;

        public Key(Output output, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.NamedElement context) {
            this.output = output;
            this.element = element;
            this.context = context;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.context == null) {
                return this.output == other.output && this.element.equals(other.element) && other.context == null;
            }
            return this.output == other.output && this.element.equals(other.element) && this.context.equals(other.context);
        }

        public int hashCode() {
            return this.output.ordinal() ^ this.element.hashCode();
        }
    }

    public static enum Output {
        CapsuleClass,
        ProtocolClass,
        BasicClass,
        UserEnum,
        ProtocolBaseRole,
        ProtocolConjugateRole,
        SignalId,
        OutSignals,
        InSignals,
        PortId,
        BorderPortId,
        InternalPortId,
        PartId,
        Deployment,
        UMLRTCapsuleClass,
        UMLRTTypeDescriptor;

    }
}

