/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import com.google.common.base.Objects;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTSUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class CppMakefileGenerator {
    public void generate(String path) {
        try {
            File file = new File(path);
            FileWriter _fileWriter = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(_fileWriter);
            String _rTSRootPath = UMLRTSUtil.getRTSRootPath();
            CharSequence _doGenerate = this.doGenerate(_rTSRootPath);
            String _string = _doGenerate.toString();
            writer.write(_string);
            writer.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private CharSequence doGenerate(String rtsPath) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"# set default value for TARGETOS if is it not defined");
        _builder.newLine();
        _builder.append((Object)"ifeq ($(TARGETOS), )");
        _builder.newLine();
        _builder.append((Object)"$(warning warning: TARGETOS not defined. Choosing linux)");
        _builder.newLine();
        _builder.append((Object)"TARGETOS=linux");
        _builder.newLine();
        _builder.append((Object)"endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# set default value for BUILDTOOLS if is it not defined");
        _builder.newLine();
        _builder.append((Object)"ifeq ($(BUILDTOOLS), )");
        _builder.newLine();
        _builder.append((Object)"$(warning warning: BUILDTOOLS not defined. Choosing x86-gcc-4.6.3)");
        _builder.newLine();
        _builder.append((Object)"BUILDTOOLS=x86-gcc-4.6.3");
        _builder.newLine();
        _builder.append((Object)"endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Location of RTS root.");
        _builder.newLine();
        _builder.append((Object)"UMLRTS_ROOT ?= ");
        boolean _equals = Objects.equal((Object)rtsPath, (Object)"");
        if (_equals) {
            _builder.append((Object)"./umlrt.rts");
        } else {
            _builder.append((Object)rtsPath, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"CONFIG=$(TARGETOS).$(BUILDTOOLS)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Destination directory for the RTS services library.");
        _builder.newLine();
        _builder.append((Object)"LIBDEST=$(UMLRTS_ROOT)/lib/$(CONFIG)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"include $(UMLRTS_ROOT)/build/host/host.mk");
        _builder.newLine();
        _builder.append((Object)"include $(UMLRTS_ROOT)/build/buildtools/$(BUILDTOOLS)/buildtools.mk");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"LD_PATHS=$(LIBDEST)");
        _builder.newLine();
        _builder.append((Object)"CC_INCLUDES+=$(UMLRTS_ROOT)/include");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"CC_DEFINES:=$(foreach d, $(CC_DEFINES), $(CC_DEF)$d)");
        _builder.newLine();
        _builder.append((Object)"CC_INCLUDES:=$(foreach i, $(CC_INCLUDES), $(CC_INC)$i)");
        _builder.newLine();
        _builder.append((Object)"LD_LIBS:=$(foreach i, $(LD_LIBS), $(LD_LIB)$i)");
        _builder.newLine();
        _builder.append((Object)"LD_PATHS:=$(foreach i, $(LD_PATHS), $(LD_LIBPATH)$i)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"SRCS = $(wildcard *.cc)");
        _builder.newLine();
        _builder.append((Object)"OBJS = $(subst $(CC_EXT),$(OBJ_EXT),$(SRCS))");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"MAIN = main$(EXE_EXT)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"all: $(MAIN)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"$(MAIN): $(OBJS) $(UMLRTS_ROOT)/lib/$(CONFIG)/$(LIB_PRFX)rts$(LIB_EXT)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"$(LD) $(LD_FLAGS) $(OBJS) $(LD_PATHS) $(LD_LIBS) $(LD_OUT)$@");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"%$(OBJ_EXT) : %$(CC_EXT)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"$(CC) $< $(CC_FLAGS) $(CC_DEFINES) $(CC_INCLUDES) $(CC_OUT)$@");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"clean :");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@echo $(RM) main$(EXE_EXT) *$(OBJ_EXT) *$(DEP_EXT) $(DBG_FILES)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@$(RM) main$(EXE_EXT) *$(OBJ_EXT) *$(DEP_EXT) $(DBG_FILES)");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)".PHONY: all clean");
        _builder.newLine();
        return _builder;
    }
}

