/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.TypeBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.external.StandardLibrary;
import org.eclipse.papyrusrt.codegen.utils.QualifiedNames;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.RTCppGenerationProperties;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypedMultiplicityElement;

public class TypesUtil {
    private static boolean mustApplyUpperBoundary = true;

    public static Type createCppType(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.Type modelType) {
        Type type = null;
        mustApplyUpperBoundary = true;
        if (modelType != null) {
            type = TypesUtil.createType(cpp, modelType);
        }
        if (element instanceof Attribute && RTCppGenerationProperties.getAttributeProperties((CommonElement)element) != null) {
            type = TypesUtil.applyAttributeProperties(type, (Attribute)element);
        } else if (element instanceof Parameter && RTCppGenerationProperties.getParameterProperties((CommonElement)element) != null) {
            type = TypesUtil.applyParameterProperties(type, (Parameter)element);
        }
        if (type == null) {
            throw new RuntimeException("unable to create C++ type for " + QualifiedNames.fullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element));
        }
        if (mustApplyUpperBoundary) {
            type = TypesUtil.applyUpperBoundary(type, element);
        }
        return type;
    }

    public static Expression createRTTypeAccess(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.Type modelType) {
        Expression rtTypeAccess = UMLRTRuntime.UMLRTObject.UMLRTType((Type)TypesUtil.createCppType(cpp, element, modelType));
        if (rtTypeAccess != null) {
            return rtTypeAccess;
        }
        Type systemType = UMLRTRuntime.getSystemType((org.eclipse.papyrusrt.xtumlrt.common.Type)modelType);
        if (systemType != null) {
            rtTypeAccess = UMLRTRuntime.UMLRTObject.UMLRTType((Type)systemType);
            if (rtTypeAccess != null) {
                return rtTypeAccess;
            }
            throw new RuntimeException("attempt to serialize unsupported UMLRTS-defined type as part of " + element.getName());
        }
        if (element instanceof Capsule) {
            throw new RuntimeException("invalid attempt to serialize a <<Capsule>> " + element.getName());
        }
        Variable rtTypeVar = cpp.getVariable(CppCodePattern.Output.UMLRTTypeDescriptor, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)modelType);
        if (rtTypeVar == null) {
            throw new RuntimeException("invalid attempt to serialize non-serializable type " + modelType.getName());
        }
        return new ElementAccess((NamedElement)cpp.getVariable(CppCodePattern.Output.UMLRTTypeDescriptor, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)modelType));
    }

    private static Type createType(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.Type modelType) {
        Type type = UMLRTRuntime.getSystemType((org.eclipse.papyrusrt.xtumlrt.common.Type)modelType);
        if (type != null) {
            return type;
        }
        if (modelType instanceof org.eclipse.papyrusrt.xtumlrt.common.PrimitiveType) {
            return TypesUtil.createType((org.eclipse.papyrusrt.xtumlrt.common.PrimitiveType)modelType);
        }
        if (modelType instanceof Entity) {
            return TypesUtil.createType(cpp, (Entity)modelType);
        }
        if (modelType instanceof StructuredType) {
            return TypesUtil.createType(cpp, (StructuredType)modelType);
        }
        if (modelType instanceof Enumeration) {
            return TypesUtil.createType(cpp, (Enumeration)modelType);
        }
        return PrimitiveType.VOID.ptr();
    }

    private static Type createType(CppCodePattern cpp, StructuredType type) {
        CppClass cls = cpp.getCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)type);
        cls.setKind(CppClass.Kind.STRUCT);
        return cls.getType();
    }

    private static Type createType(CppCodePattern cpp, Entity cls) {
        return cpp.getCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)cls).getType();
    }

    private static Type createType(CppCodePattern cpp, Enumeration element) {
        return cpp.getCppEnum(CppCodePattern.Output.UserEnum, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element).getType();
    }

    private static Type createBuiltInType(String name) {
        if ("char".equals(name)) {
            return PrimitiveType.CHAR;
        }
        if ("double".equals(name)) {
            return PrimitiveType.DOUBLE;
        }
        if ("float".equals(name)) {
            return PrimitiveType.FLOAT;
        }
        if ("int".equals(name)) {
            return PrimitiveType.INT;
        }
        if ("void".equals(name)) {
            return PrimitiveType.VOID;
        }
        if ("long".equals(name)) {
            return PrimitiveType.LONG;
        }
        if ("long double".equals(name)) {
            return PrimitiveType.LONGDOUBLE;
        }
        if ("short".equals(name)) {
            return PrimitiveType.SHORT;
        }
        if ("unsigned int".equals(name)) {
            return PrimitiveType.UINT;
        }
        if ("unsigned short".equals(name)) {
            return PrimitiveType.USHORT;
        }
        if ("unsigned char".equals(name)) {
            return PrimitiveType.UCHAR;
        }
        if ("unsigned long".equals(name)) {
            return PrimitiveType.ULONG;
        }
        if ("bool".equals(name)) {
            return PrimitiveType.BOOL;
        }
        return null;
    }

    private static Type createUMLType(String name) {
        if ("Boolean".equals(name)) {
            return PrimitiveType.BOOL;
        }
        if ("Integer".equals(name)) {
            return PrimitiveType.INT;
        }
        if ("Real".equals(name)) {
            return PrimitiveType.DOUBLE;
        }
        if ("String".equals(name)) {
            return PrimitiveType.CHAR.ptr();
        }
        if ("UnlimitedNatural".equals(name)) {
            return PrimitiveType.ULONGLONG;
        }
        return null;
    }

    private static Type createAnsiCLibraryType(String name) {
        if ("int8_t".equals(name)) {
            return StandardLibrary.int8_t;
        }
        if ("int16_t".equals(name)) {
            return StandardLibrary.int16_t;
        }
        if ("int32_t".equals(name)) {
            return StandardLibrary.int32_t;
        }
        if ("int64_t".equals(name)) {
            return StandardLibrary.int64_t;
        }
        if ("uint8_t".equals(name)) {
            return StandardLibrary.uint8_t;
        }
        if ("uint16_t".equals(name)) {
            return StandardLibrary.uint16_t;
        }
        if ("uint32_t".equals(name)) {
            return StandardLibrary.uint32_t;
        }
        if ("uint64_t".equals(name)) {
            return StandardLibrary.uint64_t;
        }
        if ("wchar_t".equals(name)) {
            return StandardLibrary.wchar_t;
        }
        return null;
    }

    private static Type createType(org.eclipse.papyrusrt.xtumlrt.common.PrimitiveType xtumlrtType) {
        String name = xtumlrtType.getName();
        Type type = TypesUtil.createBuiltInType(name);
        if (type != null) {
            return type;
        }
        type = TypesUtil.createUMLType(name);
        if (type != null) {
            return type;
        }
        type = TypesUtil.createAnsiCLibraryType(name);
        if (type != null) {
            return type;
        }
        return PrimitiveType.VOID.ptr();
    }

    private static Type applyUpperBoundary(Type type, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        int upperBound;
        TypedMultiplicityElement typedMultElement = null;
        if (element instanceof Operation) {
            typedMultElement = ((Operation)element).getReturnType();
            if (typedMultElement.getUpperBound() > 1) {
                type = type.ptr();
            }
        } else if ((element instanceof Parameter || element instanceof Attribute) && (upperBound = (typedMultElement = (TypedMultiplicityElement)element).getUpperBound()) > 1) {
            type = type.arrayOf((Expression)new IntegralLiteral(upperBound));
        }
        return type;
    }

    private static Type applyAttributeProperties(Type type, Attribute element) {
        boolean isPointer;
        String typeStr = RTCppGenerationProperties.getAttributePropType((CommonElement)element);
        if (typeStr != null && !typeStr.trim().equals("")) {
            type = new TypeBlob(typeStr);
        } else if (type == null) {
            CodeGenPlugin.error((String)(" Parameter '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element) + "' has no type"));
        }
        Boolean isVolatileBool = RTCppGenerationProperties.getAttributePropVolatile((CommonElement)element);
        Boolean pointsToBool = RTCppGenerationProperties.getAttributePropPointsTo((CommonElement)element);
        Boolean pointsToConstBool = RTCppGenerationProperties.getAttributePropPointsToConst((CommonElement)element);
        Boolean pointsToVolatileBool = RTCppGenerationProperties.getAttributePropPointsToVolatile((CommonElement)element);
        boolean isConst = element.isReadOnly();
        boolean isVolatile = isVolatileBool != null && isVolatileBool != false;
        boolean pointsTo = pointsToBool != null && pointsToBool != false;
        boolean pointsToConst = pointsToConstBool != null && pointsToConstBool != false;
        boolean pointsToVolatile = pointsToVolatileBool != null && pointsToVolatileBool != false;
        boolean bl = isPointer = pointsTo || pointsToConst || pointsToVolatile;
        if (pointsToConst) {
            type = pointsToVolatile ? type.constVolatile() : type.const_();
        } else if (pointsToVolatile) {
            type = type.volatile_();
        }
        if (isPointer && !isConst && !isVolatile) {
            type = type.ptr();
        }
        if (isConst) {
            type = isVolatile ? (isPointer ? type.constVolatilePtr() : type.constVolatile()) : (isPointer ? type.constPtr() : type.const_());
        } else if (isVolatile) {
            type = isPointer ? type.volatilePtr() : type.volatile_();
        }
        return type;
    }

    private static Type applyParameterProperties(Type type, Parameter element) {
        boolean isPointer;
        String typeStr = RTCppGenerationProperties.getParameterPropType((CommonElement)element);
        if (typeStr != null && !typeStr.trim().equals("")) {
            type = new TypeBlob(typeStr);
        } else if (type == null) {
            CodeGenPlugin.error((String)(" Parameter '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element) + "' has no type"));
        }
        Boolean pointsToBool = RTCppGenerationProperties.getParameterPropPointsTo((CommonElement)element);
        Boolean pointsToConstBool = RTCppGenerationProperties.getParameterPropPointsToConst((CommonElement)element);
        Boolean pointsToVolatileBool = RTCppGenerationProperties.getParameterPropPointsToVolatile((CommonElement)element);
        boolean pointsTo = pointsToBool != null && pointsToBool != false;
        boolean pointsToConst = pointsToConstBool != null && pointsToConstBool != false;
        boolean pointsToVolatile = pointsToVolatileBool != null && pointsToVolatileBool != false;
        boolean bl = isPointer = pointsTo || pointsToConst || pointsToVolatile;
        if (pointsToConst) {
            type = pointsToVolatile ? type.constVolatile() : type.const_();
        } else if (pointsToVolatile) {
            type = type.volatile_();
        }
        if (isPointer) {
            type = type.ptr();
        }
        return type;
    }
}

