/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.TypesUtil;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.UserCode;
import org.eclipse.papyrusrt.codegen.utils.QualifiedNames;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.RTCppGenerationProperties;
import org.eclipse.papyrusrt.xtumlrt.common.ActionCode;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonPackage;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypedMultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.VisibilityKind;

public class BasicClassGenerator
extends AbstractCppGenerator {
    private final org.eclipse.papyrusrt.xtumlrt.common.Type element;

    public BasicClassGenerator(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.Type element) {
        super(cpp);
        this.element = element;
    }

    @Override
    public String getLabel() {
        return String.valueOf(super.getLabel()) + ' ' + this.element.getName();
    }

    private CppClass.Visibility getVisibility(VisibilityKind visibility) {
        switch (visibility) {
            case PUBLIC: {
                return CppClass.Visibility.PUBLIC;
            }
            case PROTECTED: {
                return CppClass.Visibility.PROTECTED;
            }
            case PRIVATE: {
                return CppClass.Visibility.PRIVATE;
            }
        }
        return null;
    }

    private Type getReturnType(Operation operation) {
        TypedMultiplicityElement returnTypedElement = operation.getReturnType();
        if (returnTypedElement == null) {
            return PrimitiveType.VOID;
        }
        org.eclipse.papyrusrt.xtumlrt.common.Type returnType = returnTypedElement.getType();
        if (returnType == null) {
            return PrimitiveType.VOID;
        }
        Type type = TypesUtil.createCppType(this.cpp, (NamedElement)operation, returnType);
        return type;
    }

    @Override
    public boolean generate() {
        CppClass cls = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (NamedElement)this.element);
        return this.generate(cls);
    }

    protected boolean generate(CppClass cls) {
        if (this.element.eClass() == CommonPackage.eINSTANCE.getStructuredType()) {
            cls.setKind(CppClass.Kind.STRUCT);
        }
        this.generateAttributes(cls);
        this.generateOperations(cls);
        return true;
    }

    private boolean generateOperations(CppClass cls) {
        for (Operation operation : ((StructuredType)this.element).getOperations()) {
            String source;
            CppClass.Visibility cppVisibility = this.getVisibility(operation.getVisibility());
            if (cppVisibility == null) continue;
            Type returnType = this.getReturnType(operation);
            if (returnType == null) {
                throw new RuntimeException("could not determine return type for " + operation.toString());
            }
            MemberFunction function = new MemberFunction(returnType, operation.getName());
            for (Parameter param : operation.getParameters()) {
                switch (param.getDirection()) {
                    case OUT: {
                        break;
                    }
                    case IN: {
                        Type type = TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType());
                        function.add(new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(type, param.getName()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("unhandled paramater direction for " + param.toString());
                    }
                }
            }
            ActionCode code = operation.getBody();
            if (code != null && (source = code.getSource()) != null) {
                function.add(new Statement[]{new UserCode(source)});
            }
            if (operation.isStatic()) {
                cls.addStaticMember(cppVisibility, function);
                continue;
            }
            cls.addMember(cppVisibility, function);
        }
        return true;
    }

    private boolean generateAttributes(CppClass cls) {
        for (Attribute attr : ((StructuredType)this.element).getAttributes()) {
            this.generate(cls, attr);
        }
        return true;
    }

    protected MemberField generate(CppClass cls, Attribute attr) {
        CppClass.Visibility cppVisibility = this.getVisibility(attr.getVisibility());
        if (cppVisibility == null) {
            return null;
        }
        Type type = null;
        org.eclipse.papyrusrt.xtumlrt.common.Type attrType = attr.getType();
        type = TypesUtil.createCppType(this.cpp, (NamedElement)attr, attrType);
        MemberField field = null;
        RTCppGenerationProperties.AttributeKind attrKind = RTCppGenerationProperties.getAttributePropKind((CommonElement)attr);
        if (attrKind == null) {
            field = this.generateMemberAttribute(cls, attr, cppVisibility, type, null);
        } else {
            switch (attrKind) {
                case MEMBER: 
                case MUTABLE_MEMBER: {
                    field = this.generateMemberAttribute(cls, attr, cppVisibility, type, attrKind);
                    break;
                }
                case GLOBAL: {
                    this.generateGlobalVariable(cls, attr, type);
                    break;
                }
                case DEFINE: {
                    CodeGenPlugin.warning((String)("Attribute '" + QualifiedNames.cachedFullName((NamedElement)attr) + "' has been declared with unsupported kind DEFINE"));
                    break;
                }
                default: {
                    throw new RuntimeException("Attribute '" + QualifiedNames.cachedFullName((NamedElement)attr) + "' has an unrecognized kind: '" + attrKind.toString() + "'");
                }
            }
        }
        return field;
    }

    private void generateGlobalVariable(CppClass cls, Attribute attr, Type type) {
        NamedElement owner = XTUMLRTUtil.getOwner((CommonElement)attr);
        if (owner == null || !(owner instanceof StructuredType)) {
            return;
        }
        StructuredType structuredType = (StructuredType)owner;
        ElementList elementList = this.getElementList(structuredType);
        if (elementList == null) {
            return;
        }
        LinkageSpec linkageSpec = attr.isStatic() ? LinkageSpec.STATIC : LinkageSpec.UNSPECIFIED;
        Variable var = new Variable(linkageSpec, type, attr.getName());
        elementList.addElement(new IUserElement[]{var});
    }

    protected ElementList getElementList(StructuredType structuredType) {
        return this.cpp.getElementList(CppCodePattern.Output.BasicClass, (NamedElement)structuredType);
    }

    private MemberField generateMemberAttribute(CppClass cls, Attribute attr, CppClass.Visibility cppVisibility, Type type, RTCppGenerationProperties.AttributeKind attrKind) {
        MemberField field = null;
        field = attr.getDefault() == null || attr.getDefault().isEmpty() ? new MemberField(type, attr.getName()) : new MemberField(type, attr.getName(), (Expression)new ExpressionBlob(attr.getDefault()));
        if (attr.isStatic()) {
            cls.addStaticMember(cppVisibility, field);
        } else {
            if (!attr.isReadOnly() && attrKind == RTCppGenerationProperties.AttributeKind.MUTABLE_MEMBER) {
                field.setMutable();
            }
            cls.addMember(cppVisibility, field);
        }
        return field;
    }
}

