/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;

public class ElementList
extends HeaderFile {
    private final ElementDependencies extraDeps = new ElementDependencies(this);
    private final List<IUserElement> elements = new ArrayList<IUserElement>();
    private final List<String> declPrefaceTextList = new ArrayList<String>();
    private final List<String> declEndingTextList = new ArrayList<String>();
    private final List<String> defnPrefaceTextList = new ArrayList<String>();
    private final List<String> defnEndingTextList = new ArrayList<String>();

    public ElementList(FileName name) {
        super(name);
    }

    public void addElement(IUserElement ... elements) {
        IUserElement[] iUserElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IUserElement element = iUserElementArray[n2];
            element.setDefinedIn(this);
            this.elements.add(element);
            ++n2;
        }
    }

    @Deprecated
    public void addDeclDependency(DependencyBlob blob) {
        this.extraDeps.decl().add(blob);
    }

    @Deprecated
    public void addDefnDependency(DependencyBlob blob) {
        this.extraDeps.defn().add(blob);
    }

    public void addDeclPrefaceText(String text) {
        this.addTrimmedText(this.declPrefaceTextList, text);
    }

    public void addDeclEndingText(String text) {
        this.addTrimmedText(this.declEndingTextList, text);
    }

    public void addDefnPrefaceText(String text) {
        this.addTrimmedText(this.defnPrefaceTextList, text);
    }

    public void addDefnEndingText(String text) {
        this.addTrimmedText(this.defnEndingTextList, text);
    }

    private void addTrimmedText(List<String> textList, String text) {
        if (text == null) {
            return;
        }
        String trimmed = text.trim();
        if (!trimmed.isEmpty()) {
            textList.add(trimmed);
        }
    }

    private boolean writeTextList(CppFormatter fmt, List<String> textList) {
        for (String text : textList) {
            if (fmt.writeLn(text)) continue;
            return false;
        }
        return true;
    }

    public boolean write(CppWriter out) {
        String protectionMacro = String.valueOf(this.getName().getAbsolutePath().replace('/', '_').toUpperCase()) + "_HH";
        if (!(out.decl().newline() && out.decl().writeLn("#ifndef " + protectionMacro) && out.decl().writeLn("#define " + protectionMacro) && out.decl().newline() && out.defn().newline() && this.writeInclude(out.defn()) && out.defn().newline())) {
            return false;
        }
        out.decl().enableWrites();
        out.defn().enableWrites();
        ElementDependencies deps = new ElementDependencies(this);
        for (IUserElement element : this.elements) {
            element.addDependencies(deps);
        }
        if (!deps.write(out)) {
            return false;
        }
        if (!this.extraDeps.write(out)) {
            return false;
        }
        if (!this.writeTextList(out.decl(), this.declPrefaceTextList) || !this.writeTextList(out.defn(), this.defnPrefaceTextList)) {
            return false;
        }
        for (IUserElement element : this.elements) {
            if (element.write(out)) continue;
            return false;
        }
        if (!this.writeTextList(out.decl(), this.declEndingTextList) || !this.writeTextList(out.defn(), this.defnEndingTextList)) {
            return false;
        }
        if (out.decl().isProvisional()) {
            return true;
        }
        return out.decl().newline() && out.decl().writeLn("#endif") && out.decl().newline();
    }
}

