/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrusrt.codegen.DetailedThrowable;
import org.eclipse.xtext.xbase.lib.Functions;

public class CodeGenPlugin
extends Plugin {
    public static final String ID = "org.eclipse.papyrusrt.codegen";
    private static CodeGenPlugin instance;
    private static boolean standalone;
    private static boolean printStackTrace;
    private static final Logger LOGGER;

    static {
        standalone = false;
        LOGGER = Logger.getGlobal();
    }

    public static CodeGenPlugin getDefault() {
        return instance;
    }

    public CodeGenPlugin() {
        instance = this;
    }

    public static IStatus debug(String message) {
        Status status = new Status(1, ID, "[DEBUG]" + message);
        if (standalone) {
            CodeGenPlugin.getLogger().finest(message);
        }
        return status;
    }

    public static IStatus debug(Functions.Function0<CharSequence> thunk) {
        if (!standalone || CodeGenPlugin.getLogger().getLevel().intValue() > Level.FINEST.intValue()) {
            return new Status(1, ID, "[DEBUG] " + thunk.toString());
        }
        String message = ((CharSequence)thunk.apply()).toString();
        Status status = new Status(1, ID, "[DEBUG]\n" + message);
        if (standalone) {
            CodeGenPlugin.getLogger().finest(message);
        }
        return status;
    }

    public static IStatus info(String message) {
        Status status = new Status(1, ID, message);
        if (standalone) {
            CodeGenPlugin.getLogger().info(message);
        } else {
            CodeGenPlugin.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static IStatus warning(String message) {
        Status status = new Status(2, ID, message);
        if (standalone) {
            CodeGenPlugin.getLogger().warning(message);
        } else {
            CodeGenPlugin.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static IStatus error(String message) {
        return CodeGenPlugin.error("Error", null);
    }

    public static IStatus error(Throwable e) {
        return CodeGenPlugin.error("Error", e);
    }

    public static IStatus error(String message, Throwable e) {
        MultiStatus status = null;
        if (e instanceof DetailedThrowable) {
            status = new MultiStatus(ID, 4, message, null);
            String details = e.toString();
            String[] stringArray = details.split(System.getProperty("line.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                status.add((IStatus)new Status(4, ID, line));
                ++n2;
            }
        } else {
            status = new Status(4, ID, message, e);
        }
        if (standalone) {
            CodeGenPlugin.getLogger().severe(status.toString());
            if (printStackTrace && e != null) {
                e.printStackTrace();
            }
        } else {
            CodeGenPlugin.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static void setStandalone(boolean printTrace) {
        standalone = true;
        printStackTrace = printTrace;
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

