/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.protocoleditor.internal;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageKind;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.codegen.utils.UMLRealTimeProfileUtil;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTProtocolUtil {
    public static void createProtocolContainerContent(Package pContainer, String oldName, String newName) {
        Collaboration protocol = (Collaboration)pContainer.getPackagedElement(oldName, false, UMLPackage.Literals.COLLABORATION, false);
        if (protocol == null) {
            protocol = pContainer.getPackagedElement(newName, false, UMLPackage.Literals.COLLABORATION, true);
        } else {
            protocol.setName(newName);
        }
        UMLRTProtocolUtil.applyStereoType((Element)protocol, "UMLRealTime::Protocol");
        UMLRTProtocolUtil.addRtMessageSet(pContainer, (PackageableElement)protocol, oldName, newName, RTMessageKind.IN);
        UMLRTProtocolUtil.addRtMessageSet(pContainer, (PackageableElement)protocol, UMLRTProtocolUtil.getMessageSetName(oldName, RTMessageKind.OUT), UMLRTProtocolUtil.getMessageSetName(newName, RTMessageKind.OUT), RTMessageKind.OUT);
        UMLRTProtocolUtil.addRtMessageSet(pContainer, (PackageableElement)protocol, UMLRTProtocolUtil.getMessageSetName(oldName, RTMessageKind.IN_OUT), UMLRTProtocolUtil.getMessageSetName(newName, RTMessageKind.IN_OUT), RTMessageKind.IN_OUT);
        pContainer.getPackagedElement("*", false, UMLPackage.Literals.ANY_RECEIVE_EVENT, true);
        pContainer.setName(newName);
    }

    private static Interface addRtMessageSet(Package container, PackageableElement protocol, String oldName, String newName, RTMessageKind kind) {
        Interface messageSet = UMLRTProtocolUtil.getMessageSet(container, kind);
        if (messageSet != null) {
            messageSet.setName(newName);
            return messageSet;
        }
        messageSet = (Interface)container.getPackagedElement(oldName, false, UMLPackage.Literals.INTERFACE, false);
        if (messageSet == null) {
            messageSet = (Interface)container.getPackagedElement(newName, false, UMLPackage.Literals.INTERFACE, true);
        } else {
            messageSet.setName(newName);
        }
        UMLRTProtocolUtil.applyStereoType((Element)messageSet, "UMLRealTime::RTMessageSet");
        RTMessageSet rtMessageSet = UMLRealTimeProfileUtil.getRTMessageSet((Element)messageSet);
        rtMessageSet.setRtMsgKind(kind);
        if (kind.equals((Object)RTMessageKind.IN)) {
            UMLRTProtocolUtil.addProtocolDependency(container, "ProtocolRealizesIncomingInterface", UMLPackage.Literals.REALIZATION, (NamedElement)protocol, (NamedElement)messageSet);
        } else if (kind.equals((Object)RTMessageKind.OUT)) {
            UMLRTProtocolUtil.addProtocolDependency(container, "ProtocolUsesOutgoingInterface", UMLPackage.Literals.USAGE, (NamedElement)protocol, (NamedElement)messageSet);
        } else if (kind.equals((Object)RTMessageKind.IN_OUT)) {
            UMLRTProtocolUtil.addProtocolDependency(container, "ProtocolRealizesSymInterface", UMLPackage.Literals.REALIZATION, (NamedElement)protocol, (NamedElement)messageSet);
            UMLRTProtocolUtil.addProtocolDependency(container, "ProtocolUsesSymInterface", UMLPackage.Literals.USAGE, (NamedElement)protocol, (NamedElement)messageSet);
        }
        return messageSet;
    }

    private static void addProtocolDependency(Package container, String name, EClass eClass, NamedElement client, NamedElement supplier) {
        for (Element e : container.getOwnedElements()) {
            Dependency d;
            if (!e.eClass().equals(eClass) || !(d = (Dependency)e).getClients().contains((Object)client) || !d.getSuppliers().contains((Object)supplier)) continue;
            d.setName(name);
            return;
        }
        Dependency dependency = (Dependency)container.getPackagedElement(name, false, eClass, true);
        EList clients = dependency.getClients();
        EList suppliers = dependency.getSuppliers();
        clients.clear();
        clients.add((Object)client);
        suppliers.clear();
        suppliers.add((Object)supplier);
    }

    public static void applyStereoType(Element element, String qualifiedName) {
        Stereotype protocolStereotype = element.getAppliedStereotype(qualifiedName);
        if (protocolStereotype == null) {
            protocolStereotype = element.getApplicableStereotype(qualifiedName);
            element.applyStereotype(protocolStereotype);
        }
    }

    public static Package getProtocolContainer(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject instanceof Element && UMLRealTimeProfileUtil.isProtocolContainer((Element)((Element)eObject))) {
            return (Package)eObject;
        }
        return UMLRTProtocolUtil.getProtocolContainer(eObject.eContainer());
    }

    public static Interface getMessageSet(Package protocolContainer, RTMessageKind kind) {
        String protocolName = protocolContainer.getName();
        Collaboration protocol = (Collaboration)protocolContainer.getPackagedElement(protocolName, false, UMLPackage.Literals.COLLABORATION, false);
        if (protocol == null) {
            return null;
        }
        if (kind.equals((Object)RTMessageKind.IN)) {
            EList<Interface> provides = UMLRTProtocolUtil.getProvideds(protocol);
            if (!provides.isEmpty()) {
                return (Interface)provides.get(0);
            }
        } else if (kind.equals((Object)RTMessageKind.OUT)) {
            EList<Interface> requires = UMLRTProtocolUtil.getRequireds(protocol);
            if (!requires.isEmpty()) {
                return (Interface)requires.get(0);
            }
        } else {
            EList<Interface> provides = UMLRTProtocolUtil.getProvideds(protocol);
            EList<Interface> requires = UMLRTProtocolUtil.getRequireds(protocol);
            for (Interface p : provides) {
                if (!requires.contains((Object)p)) continue;
                return p;
            }
        }
        return null;
    }

    private static String getMessageSetName(String protocolName, RTMessageKind kind) {
        if (kind.equals((Object)RTMessageKind.OUT)) {
            return String.valueOf(protocolName) + "~";
        }
        if (kind.equals((Object)RTMessageKind.IN_OUT)) {
            return String.valueOf(protocolName) + "Sym";
        }
        return protocolName;
    }

    public static EList<Interface> getProvideds(Collaboration source) {
        BasicEList provideds = new BasicEList();
        for (DirectedRelationship directedRelation : source.getSourceDirectedRelationships()) {
            NamedElement supplier;
            EList suppliers;
            if (!(directedRelation instanceof Realization) || (suppliers = ((Realization)directedRelation).getSuppliers()).size() <= 0 || !((supplier = (NamedElement)suppliers.get(0)) instanceof Interface)) continue;
            provideds.add((Object)((Interface)supplier));
        }
        return provideds;
    }

    public static EList<Interface> getRequireds(Collaboration source) {
        return source.getUsedInterfaces();
    }
}

