/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.protocoleditor.properties;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageKind;
import org.eclipse.papyrus.views.properties.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.papyrusrt.codegen.utils.UMLRealTimeProfileUtil;
import org.eclipse.papyrusrt.protocoleditor.Activator;
import org.eclipse.papyrusrt.protocoleditor.UMLRTModelElementSelectionService;
import org.eclipse.papyrusrt.protocoleditor.internal.UMLRTProtocolUtil;
import org.eclipse.papyrusrt.protocoleditor.properties.UMLRTMultiReferenceEditor;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ProtocolContainerOperationSection
extends Composite {
    private Composite listArea;

    public ProtocolContainerOperationSection(Composite parent, int style) {
        super(parent, style);
        EObject selectedElement = UMLRTModelElementSelectionService.getSelectedEObject();
        this.listArea = this.createListArea(parent, style, selectedElement);
        final UMLRTModelElementSelectionService.IModelExplorerSelectionChangeListener listener = new UMLRTModelElementSelectionService.IModelExplorerSelectionChangeListener(){

            @Override
            public void selectionChanged(ISelection selection) {
                EObject selectedElement;
                if (selection.isEmpty()) {
                    return;
                }
                if (((IStructuredSelection)selection).getFirstElement() instanceof IAdaptable && (selectedElement = (EObject)((IAdaptable)((IStructuredSelection)selection).getFirstElement()).getAdapter(EObject.class)) instanceof Element && UMLRealTimeProfileUtil.isProtocolContainer((Element)((Element)selectedElement))) {
                    if (ProtocolContainerOperationSection.this.listArea != null && !ProtocolContainerOperationSection.this.listArea.isDisposed()) {
                        ProtocolContainerOperationSection.this.listArea.dispose();
                    }
                    if (ProtocolContainerOperationSection.this.getParent() != null && !ProtocolContainerOperationSection.this.getParent().isDisposed()) {
                        ProtocolContainerOperationSection.this.listArea = ProtocolContainerOperationSection.this.createListArea(ProtocolContainerOperationSection.this.getParent(), ProtocolContainerOperationSection.this.getParent().getStyle(), selectedElement);
                        ProtocolContainerOperationSection.this.getParent().layout(true);
                    }
                }
            }
        };
        UMLRTModelElementSelectionService.addListener(listener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                UMLRTModelElementSelectionService.removeListener(listener);
            }
        });
    }

    private Composite createListArea(Composite parent, int style, EObject selectedElement) {
        UMLRTMultiReferenceEditor editor;
        IObservableList observable;
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new PropertiesLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        if (selectedElement == null) {
            return composite;
        }
        Package protocolContainer = (Package)selectedElement;
        Interface inMessageSet = UMLRTProtocolUtil.getMessageSet(protocolContainer, RTMessageKind.IN);
        Interface outMessageSet = UMLRTProtocolUtil.getMessageSet(protocolContainer, RTMessageKind.OUT);
        Interface inOutMessageSet = UMLRTProtocolUtil.getMessageSet(protocolContainer, RTMessageKind.IN_OUT);
        EcorePropertyEditorFactory factory = new EcorePropertyEditorFactory(UMLPackage.Literals.INTERFACE__OWNED_OPERATION);
        if (inMessageSet != null) {
            observable = (IObservableList)new UMLModelElement((EObject)inMessageSet).getObservable("ownedOperation");
            editor = new UMLRTMultiReferenceEditor(composite, style, "In", (EObject)inMessageSet, observable, factory);
            TreeViewer inMessageTreeViewer = editor.getViewer();
            this.addDnDSupport(inMessageTreeViewer);
        }
        if (outMessageSet != null) {
            observable = (IObservableList)new UMLModelElement((EObject)outMessageSet).getObservable("ownedOperation");
            editor = new UMLRTMultiReferenceEditor(composite, style, "Out", (EObject)outMessageSet, observable, factory);
            TreeViewer outMessageTreeViewer = editor.getViewer();
            this.addDnDSupport(outMessageTreeViewer);
        }
        if (inOutMessageSet != null) {
            observable = (IObservableList)new UMLModelElement((EObject)inOutMessageSet).getObservable("ownedOperation");
            editor = new UMLRTMultiReferenceEditor(composite, style, "InOut", (EObject)inOutMessageSet, observable, factory);
            TreeViewer inOutMessageTreeViewer = editor.getViewer();
            this.addDnDSupport(inOutMessageTreeViewer);
        }
        return composite;
    }

    private void addDnDSupport(final TreeViewer viewer) {
        viewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                if (transfer.isSupportedType(event.dataType)) {
                    transfer.setSelection(viewer.getSelection());
                    transfer.setSelectionSetTime((long)(event.time & 0xFFFF));
                }
            }
        });
        viewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)viewer){

            public boolean performDrop(Object data) {
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
                if (selection.isEmpty()) {
                    return false;
                }
                if (!(selection.getFirstElement() instanceof Operation)) {
                    return false;
                }
                final EObject element = (EObject)selection.getFirstElement();
                if (!(viewer.getInput() instanceof IObservableList)) {
                    return false;
                }
                final IObservableList observable = (IObservableList)viewer.getInput();
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
                EMFCommandOperation command = new EMFCommandOperation(editingDomain, (Command)new RecordingCommand(editingDomain, "Move Element"){

                    protected void doExecute() {
                        observable.add((Object)element);
                    }
                });
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                }
                catch (ExecutionException e1) {
                    Activator.log.error("Failed to move element", (Throwable)e1);
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                int location = this.getCurrentLocation();
                boolean valid = (location == 4 || location == 3) && transfer.isSupportedType(transferType);
                return valid;
            }
        });
    }
}

