/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.protocoleditor.properties;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;
import org.eclipse.papyrus.infra.widgets.providers.TreeCollectionContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrus.views.properties.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrusrt.protocoleditor.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class UMLRTMultiReferenceEditor
extends Composite
implements ISelectionChangedListener,
IChangeListener {
    protected Composite buttonSection;
    protected TreeViewer treeViewer;
    protected EcorePropertyEditorFactory factory;
    protected EObject context;
    protected IAtomicOperationExecutor executor;
    protected TransactionalEditingDomain editingDomain;
    protected Button up;
    protected Button down;
    protected Button add;
    protected Button remove;
    protected Button edit;
    IObservableList observable;

    public UMLRTMultiReferenceEditor(Composite parent, int style, String label, EObject context, IObservableList observable, EcorePropertyEditorFactory propertyFactory) {
        super(parent, style);
        this.context = context;
        this.observable = observable;
        observable.addChangeListener((IChangeListener)this);
        this.editingDomain = TransactionUtil.getEditingDomain((EObject)context);
        this.executor = (IAtomicOperationExecutor)Platform.getAdapterManager().getAdapter((Object)context, IAtomicOperationExecutor.class);
        this.factory = propertyFactory;
        this.setLayout((Layout)new GridLayout(label == null ? 1 : 2, false));
        if (label != null) {
            Label labelWidget = new Label((Composite)this, 0);
            labelWidget.setText(label);
        }
        this.buttonSection = new Composite((Composite)this, 0);
        this.buttonSection.setLayout((Layout)new FillLayout());
        this.buttonSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Tree tree = new Tree((Composite)this, style | 2 | 0x200 | 0x100 | 0x800 | 0x10000);
        GridData treeData = new GridData(4, 0, true, true);
        treeData.horizontalSpan = 2;
        treeData.heightHint = 80;
        tree.setLayoutData((Object)treeData);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)TreeCollectionContentProvider.instance);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new UMLLabelProvider());
        this.treeViewer.setInput((Object)observable);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                final EObject selectedElement = UMLRTMultiReferenceEditor.this.getSelectedElement();
                if (selectedElement != null) {
                    EMFCommandOperation command = new EMFCommandOperation(UMLRTMultiReferenceEditor.this.editingDomain, (Command)new RecordingCommand(UMLRTMultiReferenceEditor.this.editingDomain, "Edit Element"){

                        protected void doExecute() {
                            if ((this).UMLRTMultiReferenceEditor.this.factory.canEdit()) {
                                (this).UMLRTMultiReferenceEditor.this.factory.edit((this).UMLRTMultiReferenceEditor.this.treeViewer.getControl(), (Object)selectedElement);
                            }
                        }
                    });
                    try {
                        OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                    }
                    catch (ExecutionException e1) {
                        Activator.log.error("Failed to add new element", (Throwable)e1);
                    }
                    UMLRTMultiReferenceEditor.this.treeViewer.refresh((Object)selectedElement, true);
                }
            }
        });
        this.createControlButtons();
    }

    public void dispose() {
        this.observable.removeChangeListener((IChangeListener)this);
        super.dispose();
    }

    private EObject getSelectedElement() {
        ISelection selection = this.treeViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (EObject)((IStructuredSelection)selection).getFirstElement();
    }

    protected void createControlButtons() {
        this.up = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Up_12x12.gif"), "Move up");
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final EObject selectedElement = UMLRTMultiReferenceEditor.this.getSelectedElement();
                if (selectedElement == null) {
                    return;
                }
                EMFCommandOperation command = new EMFCommandOperation(UMLRTMultiReferenceEditor.this.editingDomain, (Command)new RecordingCommand(UMLRTMultiReferenceEditor.this.editingDomain, "Move Element"){

                    protected void doExecute() {
                        int index = (this).UMLRTMultiReferenceEditor.this.observable.indexOf(selectedElement);
                        if (index == 0) {
                            return;
                        }
                        (this).UMLRTMultiReferenceEditor.this.observable.move(index - 1, index);
                    }
                });
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                }
                catch (ExecutionException e1) {
                    Activator.log.error("Failed to move element", (Throwable)e1);
                }
                UMLRTMultiReferenceEditor.this.treeViewer.refresh();
            }
        });
        this.down = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Down_12x12.gif"), "Move down");
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final EObject selectedElement = UMLRTMultiReferenceEditor.this.getSelectedElement();
                if (selectedElement == null) {
                    return;
                }
                EMFCommandOperation command = new EMFCommandOperation(UMLRTMultiReferenceEditor.this.editingDomain, (Command)new RecordingCommand(UMLRTMultiReferenceEditor.this.editingDomain, "Move Element"){

                    protected void doExecute() {
                        int index = (this).UMLRTMultiReferenceEditor.this.observable.indexOf(selectedElement);
                        if (index + 1 == (this).UMLRTMultiReferenceEditor.this.observable.size()) {
                            return;
                        }
                        (this).UMLRTMultiReferenceEditor.this.observable.move(index + 1, index);
                    }
                });
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                }
                catch (ExecutionException e1) {
                    Activator.log.error("Failed to move element", (Throwable)e1);
                }
                UMLRTMultiReferenceEditor.this.treeViewer.refresh();
            }
        });
        this.add = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Add_12x12.gif"), "Add element");
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(final SelectionEvent e) {
                EMFCommandOperation command = new EMFCommandOperation(UMLRTMultiReferenceEditor.this.editingDomain, (Command)new RecordingCommand(UMLRTMultiReferenceEditor.this.editingDomain, "Add Element"){

                    protected void doExecute() {
                        Object result;
                        if ((this).UMLRTMultiReferenceEditor.this.factory.canCreateObject() && (result = (this).UMLRTMultiReferenceEditor.this.factory.createObject((Control)e.getSource(), (Object)(this).UMLRTMultiReferenceEditor.this.context)) != null) {
                            (this).UMLRTMultiReferenceEditor.this.observable.add(result);
                        }
                    }
                });
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                }
                catch (ExecutionException e1) {
                    Activator.log.error("Failed to add new element", (Throwable)e1);
                }
                UMLRTMultiReferenceEditor.this.treeViewer.refresh();
            }
        });
        this.remove = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Delete_12x12.gif"), "Remove element");
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final EObject selectedElement = UMLRTMultiReferenceEditor.this.getSelectedElement();
                if (selectedElement == null) {
                    return;
                }
                UMLRTMultiReferenceEditor.this.treeViewer.setSelection(null);
                UMLRTMultiReferenceEditor.this.treeViewer.remove((Object)selectedElement);
                EMFCommandOperation command = new EMFCommandOperation(UMLRTMultiReferenceEditor.this.editingDomain, (Command)new RecordingCommand(UMLRTMultiReferenceEditor.this.editingDomain, "Delete Element"){

                    protected void doExecute() {
                        (this).UMLRTMultiReferenceEditor.this.observable.remove(selectedElement);
                    }
                });
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                }
                catch (ExecutionException e1) {
                    Activator.log.error("Failed to add new element", (Throwable)e1);
                }
            }
        });
        this.edit = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Edit_12x12.gif"), "Edit element");
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(final SelectionEvent e) {
                final EObject selectedElement = UMLRTMultiReferenceEditor.this.getSelectedElement();
                if (selectedElement == null) {
                    return;
                }
                EMFCommandOperation command = new EMFCommandOperation(UMLRTMultiReferenceEditor.this.editingDomain, (Command)new RecordingCommand(UMLRTMultiReferenceEditor.this.editingDomain, "Edit Element"){

                    protected void doExecute() {
                        if ((this).UMLRTMultiReferenceEditor.this.factory.canEdit()) {
                            (this).UMLRTMultiReferenceEditor.this.factory.edit((Control)e.getSource(), selectedElement);
                        }
                    }
                });
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
                }
                catch (ExecutionException e1) {
                    Activator.log.error("Failed to add new element", (Throwable)e1);
                }
                UMLRTMultiReferenceEditor.this.treeViewer.refresh((Object)selectedElement, true);
            }
        });
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.buttonSection, 8);
        button.setImage(image);
        button.setToolTipText(toolTipText);
        return button;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }

    public void handleChange(ChangeEvent arg0) {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.refresh();
        }
    }

    public class MultiReferenceEditorContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object arg0) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IObservableList) {
                return ((IObservableList)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            return false;
        }
    }
}

