/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.UserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.IReferencable;

public abstract class NamedElement
extends UserElement
implements IReferencable {
    private final Name name;

    protected NamedElement(String ident) {
        this.name = new Name(ident);
    }

    protected NamedElement(HeaderFile header, Name name) {
        super(header);
        this.name = name;
    }

    public Name getName() {
        return this.name;
    }

    public void setParent(NamedElement parent) {
        this.name.setParent(parent);
    }

    @Override
    public HeaderFile getDefinedIn() {
        HeaderFile header = super.getDefinedIn();
        if (header != null) {
            return header;
        }
        return this.getName().getDefinedIn();
    }

    @Override
    public boolean write(CppFormatter fmt, Name name, List<Type.Pointer> pointerSpec, List<Expression> arrayBounds) {
        if (!fmt.write(this.getName()) || !fmt.pendingSpace()) {
            return false;
        }
        boolean first = true;
        for (Type.Pointer ptr : pointerSpec) {
            if (first) {
                first = false;
            } else if (!fmt.space()) {
                return false;
            }
            if (ptr.write(fmt)) continue;
            return false;
        }
        if (!fmt.pendingSpace() || name != null && !fmt.write(name)) {
            return false;
        }
        for (Expression bound : arrayBounds) {
            if (fmt.write('[') && (bound == null || bound.write(fmt)) && fmt.write(']')) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name.toString();
    }
}

